/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri.updater;

import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.opentripplanner.ext.siri.SiriFuzzyTripMatcher;
import org.opentripplanner.ext.siri.SiriTimetableSnapshotSource;
import org.opentripplanner.ext.siri.updater.SiriVMHttpTripUpdateSource;
import org.opentripplanner.ext.siri.updater.SiriVMUpdaterParameters;
import org.opentripplanner.ext.siri.updater.VehicleMonitoringSource;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.updater.PollingGraphUpdater;
import org.opentripplanner.updater.WriteToGraphCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.ServiceDelivery;
import uk.org.siri.siri20.Siri;

public class SiriVMUpdater
extends PollingGraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(SiriVMUpdater.class);
    protected WriteToGraphCallback saveResultOnGraph;
    private final VehicleMonitoringSource updateSource;
    private Integer logFrequency;
    private Integer maxSnapshotFrequency;
    private final Boolean purgeExpiredData;
    private final String feedId;
    private SiriFuzzyTripMatcher siriFuzzyTripMatcher;
    private final boolean fuzzyTripMatching;
    private SiriTimetableSnapshotSource snapshotSource;

    public SiriVMUpdater(SiriVMUpdaterParameters config) {
        super(config);
        int maxSnapshotFrequency;
        this.feedId = config.getFeedId();
        this.updateSource = new SiriVMHttpTripUpdateSource(config.sourceParameters());
        int logFrequency = config.getLogFrequency();
        if (logFrequency >= 0) {
            this.logFrequency = logFrequency;
        }
        if ((maxSnapshotFrequency = config.getMaxSnapshotFrequencyMs()) >= 0) {
            this.maxSnapshotFrequency = maxSnapshotFrequency;
        }
        this.purgeExpiredData = config.purgeExpiredData();
        this.fuzzyTripMatching = config.fuzzyTripMatching();
        this.blockReadinessUntilInitialized = config.blockReadinessUntilInitialized();
        LOG.info("Creating stop time updater (SIRI VM) running every {} seconds : {}", (Object)this.pollingPeriodSeconds, (Object)this.updateSource);
    }

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    @Override
    public void setup(Graph graph) {
        if (this.fuzzyTripMatching) {
            this.siriFuzzyTripMatcher = new SiriFuzzyTripMatcher(new RoutingService(graph));
        }
        this.snapshotSource = graph.getOrSetupTimetableSnapshotProvider(SiriTimetableSnapshotSource::new);
        if (this.logFrequency != null) {
            this.snapshotSource.logFrequency = this.logFrequency;
        }
        if (this.maxSnapshotFrequency != null) {
            this.snapshotSource.maxSnapshotFrequency = this.maxSnapshotFrequency;
        }
        if (this.purgeExpiredData != null) {
            this.snapshotSource.purgeExpiredData = this.purgeExpiredData;
        }
        if (this.siriFuzzyTripMatcher != null) {
            this.siriFuzzyTripMatcher = new SiriFuzzyTripMatcher(new RoutingService(graph));
        }
    }

    @Override
    public void runPolling() {
        boolean moreData = false;
        do {
            Siri updates;
            if ((updates = this.updateSource.getUpdates()) == null) continue;
            boolean fullDataset = this.updateSource.getFullDatasetValueOfLastUpdates();
            ServiceDelivery serviceDelivery = updates.getServiceDelivery();
            moreData = BooleanUtils.isTrue((Boolean)serviceDelivery.isMoreData());
            boolean markPrimed = !moreData;
            List vmds = serviceDelivery.getVehicleMonitoringDeliveries();
            if (vmds == null) continue;
            this.saveResultOnGraph.execute(graph -> {
                this.snapshotSource.applyVehicleMonitoring(graph, this.feedId, fullDataset, vmds);
                if (markPrimed) {
                    this.primed = true;
                }
            });
        } while (moreData);
    }

    @Override
    public void teardown() {
    }

    public String toString() {
        String s = this.updateSource == null ? "NONE" : this.updateSource.toString();
        return "Polling SIRI VM updater with update source = " + s;
    }
}

