/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri.updater;

import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.opentripplanner.ext.siri.SiriTimetableSnapshotSource;
import org.opentripplanner.ext.siri.updater.EstimatedTimetableSource;
import org.opentripplanner.ext.siri.updater.SiriETHttpTripUpdateSource;
import org.opentripplanner.ext.siri.updater.SiriETUpdaterParameters;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.updater.PollingGraphUpdater;
import org.opentripplanner.updater.WriteToGraphCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.ServiceDelivery;
import uk.org.siri.siri20.Siri;

public class SiriETUpdater
extends PollingGraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(SiriETUpdater.class);
    protected WriteToGraphCallback saveResultOnGraph;
    private final EstimatedTimetableSource updateSource;
    private Integer logFrequency;
    private Integer maxSnapshotFrequency;
    private final Boolean purgeExpiredData;
    private final String feedId;
    private SiriTimetableSnapshotSource snapshotSource;

    public SiriETUpdater(SiriETUpdaterParameters config) {
        super(config);
        int maxSnapshotFrequency;
        this.feedId = config.getFeedId();
        this.updateSource = new SiriETHttpTripUpdateSource(config.sourceParameters());
        int logFrequency = config.getLogFrequency();
        if (logFrequency >= 0) {
            this.logFrequency = logFrequency;
        }
        if ((maxSnapshotFrequency = config.getMaxSnapshotFrequencyMs()) >= 0) {
            this.maxSnapshotFrequency = maxSnapshotFrequency;
        }
        this.purgeExpiredData = config.purgeExpiredData();
        this.blockReadinessUntilInitialized = config.blockReadinessUntilInitialized();
        LOG.info("Creating stop time updater (SIRI ET) running every {} seconds : {}", (Object)this.pollingPeriodSeconds, (Object)this.updateSource);
    }

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    @Override
    public void setup(Graph graph) {
        this.snapshotSource = graph.getOrSetupTimetableSnapshotProvider(SiriTimetableSnapshotSource::new);
        if (this.logFrequency != null) {
            this.snapshotSource.logFrequency = this.logFrequency;
        }
        if (this.maxSnapshotFrequency != null) {
            this.snapshotSource.maxSnapshotFrequency = this.maxSnapshotFrequency;
        }
        if (this.purgeExpiredData != null) {
            this.snapshotSource.purgeExpiredData = this.purgeExpiredData;
        }
    }

    @Override
    public void runPolling() {
        boolean moreData = false;
        do {
            Siri updates;
            if ((updates = this.updateSource.getUpdates()) == null) continue;
            boolean fullDataset = this.updateSource.getFullDatasetValueOfLastUpdates();
            ServiceDelivery serviceDelivery = updates.getServiceDelivery();
            moreData = BooleanUtils.isTrue((Boolean)serviceDelivery.isMoreData());
            boolean markPrimed = !moreData;
            List etds = serviceDelivery.getEstimatedTimetableDeliveries();
            if (etds == null) continue;
            this.saveResultOnGraph.execute(graph -> {
                this.snapshotSource.applyEstimatedTimetable(graph, this.feedId, fullDataset, etds);
                if (markPrimed) {
                    this.primed = true;
                }
            });
        } while (moreData);
    }

    @Override
    public void teardown() {
    }

    public String toString() {
        String s = this.updateSource == null ? "NONE" : this.updateSource.toString();
        return "Polling SIRI ET updater with update source = " + s;
    }
}

