/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import javax.xml.datatype.Duration;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.DateMapper;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.trippattern.RealTimeState;
import org.opentripplanner.routing.trippattern.TripTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.ArrivalBoardingActivityEnumeration;
import uk.org.siri.siri20.CallStatusEnumeration;
import uk.org.siri.siri20.DepartureBoardingActivityEnumeration;
import uk.org.siri.siri20.EstimatedCall;
import uk.org.siri.siri20.EstimatedVehicleJourney;
import uk.org.siri.siri20.MonitoredCallStructure;
import uk.org.siri.siri20.NaturalLanguageStringStructure;
import uk.org.siri.siri20.RecordedCall;
import uk.org.siri.siri20.VehicleActivityStructure;

public class TimetableHelper {
    private static final Logger LOG = LoggerFactory.getLogger(TimetableHelper.class);

    public static TripTimes createUpdatedTripTimes(Graph graph, Timetable timetable, EstimatedVehicleJourney journey, TimeZone timeZone, FeedScopedId tripId) {
        if (journey == null) {
            return null;
        }
        int tripIndex = timetable.getTripIndex(tripId);
        if (tripIndex == -1) {
            LOG.debug("tripId {} not found in pattern.", (Object)tripId);
            return null;
        }
        TripTimes existingTripTimes = timetable.getTripTimes(tripIndex);
        TripTimes oldTimes = new TripTimes(existingTripTimes);
        if (journey.isCancellation() != null && journey.isCancellation().booleanValue()) {
            oldTimes.cancelTrip();
            return oldTimes;
        }
        EstimatedVehicleJourney.EstimatedCalls journeyEstimatedCalls = journey.getEstimatedCalls();
        EstimatedVehicleJourney.RecordedCalls journeyRecordedCalls = journey.getRecordedCalls();
        List estimatedCalls = journeyEstimatedCalls != null ? journeyEstimatedCalls.getEstimatedCalls() : Collections.EMPTY_LIST;
        List recordedCalls = journeyRecordedCalls != null ? journeyRecordedCalls.getRecordedCalls() : Collections.EMPTY_LIST;
        boolean stopPatternChanged = false;
        Trip trip = TimetableHelper.getTrip(tripId, timetable);
        List<StopTime> modifiedStopTimes = TimetableHelper.createModifiedStopTimes(timetable, oldTimes, journey, trip, new RoutingService(graph));
        if (modifiedStopTimes == null) {
            return null;
        }
        TripTimes newTimes = new TripTimes(trip, modifiedStopTimes, graph.deduplicator);
        newTimes.setServiceCode(oldTimes.getServiceCode());
        ZoneId zoneId = graph.getTimeZone().toZoneId();
        int callCounter = 0;
        ZonedDateTime departureDate = null;
        HashSet<Object> alreadyVisited = new HashSet<Object>();
        boolean isJourneyPredictionInaccurate = journey.isPredictionInaccurate() != null && journey.isPredictionInaccurate() != false;
        int departureFromPreviousStop = 0;
        int lastArrivalDelay = 0;
        int lastDepartureDelay = 0;
        for (StopLocation stop : timetable.getPattern().getStops()) {
            boolean foundMatch = false;
            for (RecordedCall recordedCall : recordedCalls) {
                int departureTime;
                int arrivalTime;
                StopLocation alternativeStop;
                if (alreadyVisited.contains(recordedCall)) continue;
                foundMatch = stop.getId().getId().equals(recordedCall.getStopPointRef().getValue());
                if (!foundMatch && stop.isPartOfStation() && (alternativeStop = graph.index.getStopForId(new FeedScopedId(stop.getId().getFeedId(), recordedCall.getStopPointRef().getValue()))) != null && stop.isPartOfSameStationAs(alternativeStop)) {
                    foundMatch = true;
                    stopPatternChanged = true;
                }
                if (!foundMatch) continue;
                if (departureDate == null) {
                    departureDate = recordedCall.getAimedDepartureTime();
                    if (departureDate == null) {
                        departureDate = recordedCall.getAimedArrivalTime();
                    }
                    if (oldTimes.getDepartureTime(0) > 86400) {
                        int dayOffsetCount = oldTimes.getDepartureTime(0) / 86400;
                        departureDate = departureDate.minusDays(dayOffsetCount);
                    }
                }
                if (recordedCall.isCancellation() != null && recordedCall.isCancellation().booleanValue()) {
                    modifiedStopTimes.get(callCounter).cancel();
                    newTimes.setCancelled(callCounter);
                }
                int realtimeArrivalTime = arrivalTime = newTimes.getArrivalTime(callCounter);
                if (recordedCall.getActualArrivalTime() != null) {
                    realtimeArrivalTime = DateMapper.secondsSinceStartOfService(departureDate, recordedCall.getActualArrivalTime(), zoneId);
                    newTimes.setRecorded(callCounter, true);
                } else if (recordedCall.getExpectedArrivalTime() != null) {
                    realtimeArrivalTime = DateMapper.secondsSinceStartOfService(departureDate, recordedCall.getExpectedArrivalTime(), zoneId);
                } else if (recordedCall.getAimedArrivalTime() != null) {
                    realtimeArrivalTime = DateMapper.secondsSinceStartOfService(departureDate, recordedCall.getAimedArrivalTime(), zoneId);
                }
                int arrivalDelay = realtimeArrivalTime - arrivalTime;
                newTimes.updateArrivalDelay(callCounter, arrivalDelay);
                lastArrivalDelay = arrivalDelay;
                int realtimeDepartureTime = departureTime = newTimes.getDepartureTime(callCounter);
                if (recordedCall.getActualDepartureTime() != null) {
                    realtimeDepartureTime = DateMapper.secondsSinceStartOfService(departureDate, recordedCall.getActualDepartureTime(), zoneId);
                    newTimes.setRecorded(callCounter, true);
                } else if (recordedCall.getExpectedDepartureTime() != null) {
                    realtimeDepartureTime = DateMapper.secondsSinceStartOfService(departureDate, recordedCall.getExpectedDepartureTime(), zoneId);
                } else if (recordedCall.getAimedDepartureTime() != null) {
                    realtimeDepartureTime = DateMapper.secondsSinceStartOfService(departureDate, recordedCall.getAimedDepartureTime(), zoneId);
                }
                int departureDelay = realtimeDepartureTime - departureTime;
                newTimes.updateDepartureDelay(callCounter, departureDelay);
                lastDepartureDelay = departureDelay;
                departureFromPreviousStop = newTimes.getDepartureTime(callCounter);
                alreadyVisited.add(recordedCall);
                break;
            }
            if (!foundMatch) {
                for (EstimatedCall estimatedCall : estimatedCalls) {
                    int departureTime;
                    CallStatusEnumeration departureStatus;
                    StopLocation alternativeStop;
                    if (alreadyVisited.contains(estimatedCall)) continue;
                    foundMatch = stop.getId().getId().equals(estimatedCall.getStopPointRef().getValue());
                    if (!foundMatch && stop.isPartOfStation() && (alternativeStop = graph.index.getStopForId(new FeedScopedId(stop.getId().getFeedId(), estimatedCall.getStopPointRef().getValue()))) != null && stop.isPartOfSameStationAs(alternativeStop)) {
                        foundMatch = true;
                        stopPatternChanged = true;
                    }
                    if (!foundMatch) continue;
                    if (departureDate == null && (departureDate = estimatedCall.getAimedDepartureTime()) == null) {
                        departureDate = estimatedCall.getAimedArrivalTime();
                    }
                    if (estimatedCall.isCancellation() != null && estimatedCall.isCancellation().booleanValue()) {
                        modifiedStopTimes.get(callCounter).cancel();
                        newTimes.setCancelled(callCounter);
                    }
                    boolean isCallPredictionInaccurate = estimatedCall.isPredictionInaccurate() != null && estimatedCall.isPredictionInaccurate() != false;
                    newTimes.setPredictionInaccurate(callCounter, isJourneyPredictionInaccurate | isCallPredictionInaccurate);
                    CallStatusEnumeration arrivalStatus = estimatedCall.getArrivalStatus();
                    if (arrivalStatus == CallStatusEnumeration.CANCELLED) {
                        modifiedStopTimes.get(callCounter).cancelDropOff();
                    }
                    if ((departureStatus = estimatedCall.getDepartureStatus()) == CallStatusEnumeration.CANCELLED) {
                        modifiedStopTimes.get(callCounter).cancelPickup();
                    }
                    int arrivalTime = newTimes.getArrivalTime(callCounter);
                    int realtimeArrivalTime = -1;
                    if (estimatedCall.getExpectedArrivalTime() != null) {
                        realtimeArrivalTime = DateMapper.secondsSinceStartOfService(departureDate, estimatedCall.getExpectedArrivalTime(), zoneId);
                    } else if (estimatedCall.getAimedArrivalTime() != null) {
                        realtimeArrivalTime = DateMapper.secondsSinceStartOfService(departureDate, estimatedCall.getAimedArrivalTime(), zoneId);
                    }
                    int realtimeDepartureTime = departureTime = newTimes.getDepartureTime(callCounter);
                    if (estimatedCall.getExpectedDepartureTime() != null) {
                        realtimeDepartureTime = DateMapper.secondsSinceStartOfService(departureDate, estimatedCall.getExpectedDepartureTime(), zoneId);
                    } else if (estimatedCall.getAimedDepartureTime() != null) {
                        realtimeDepartureTime = DateMapper.secondsSinceStartOfService(departureDate, estimatedCall.getAimedDepartureTime(), zoneId);
                    }
                    if (realtimeArrivalTime == -1) {
                        realtimeArrivalTime = realtimeDepartureTime;
                    }
                    int arrivalDelay = realtimeArrivalTime - arrivalTime;
                    newTimes.updateArrivalDelay(callCounter, arrivalDelay);
                    lastArrivalDelay = arrivalDelay;
                    int departureDelay = realtimeDepartureTime - departureTime;
                    newTimes.updateDepartureDelay(callCounter, departureDelay);
                    lastDepartureDelay = departureDelay;
                    departureFromPreviousStop = newTimes.getDepartureTime(callCounter);
                    alreadyVisited.add(estimatedCall);
                    break;
                }
            }
            if (!foundMatch) {
                if (timetable.getPattern().isBoardAndAlightAt(callCounter, PickDrop.NONE)) {
                    newTimes.updateArrivalTime(callCounter, departureFromPreviousStop);
                    newTimes.updateDepartureTime(callCounter, departureFromPreviousStop);
                } else {
                    int arrivalDelay = lastArrivalDelay;
                    int departureDelay = lastDepartureDelay;
                    if (lastArrivalDelay == 0 && lastDepartureDelay == 0) {
                        arrivalDelay = existingTripTimes.getArrivalDelay(callCounter);
                        departureDelay = existingTripTimes.getDepartureDelay(callCounter);
                    }
                    newTimes.updateArrivalDelay(callCounter, arrivalDelay);
                    newTimes.updateDepartureDelay(callCounter, departureDelay);
                }
                departureFromPreviousStop = newTimes.getDepartureTime(callCounter);
            }
            ++callCounter;
        }
        if (stopPatternChanged) {
            newTimes.setRealTimeState(RealTimeState.MODIFIED);
        } else {
            newTimes.setRealTimeState(RealTimeState.UPDATED);
        }
        if (journey.isCancellation() != null && journey.isCancellation().booleanValue()) {
            LOG.debug("Trip is cancelled");
            newTimes.cancelTrip();
        }
        if (!newTimes.timesIncreasing()) {
            LOG.info("TripTimes are non-increasing after applying SIRI delay propagation - LineRef {}, TripId {}.", (Object)journey.getLineRef().getValue(), (Object)tripId);
            return null;
        }
        if (newTimes.getNumStops() != timetable.getPattern().numberOfStops()) {
            return null;
        }
        LOG.debug("A valid TripUpdate object was applied using the Timetable class update method.");
        return newTimes;
    }

    public static List<StopLocation> createModifiedStops(Timetable timetable, EstimatedVehicleJourney journey, RoutingService routingService) {
        if (journey == null) {
            return null;
        }
        EstimatedVehicleJourney.EstimatedCalls journeyEstimatedCalls = journey.getEstimatedCalls();
        EstimatedVehicleJourney.RecordedCalls journeyRecordedCalls = journey.getRecordedCalls();
        List estimatedCalls = journeyEstimatedCalls != null ? journeyEstimatedCalls.getEstimatedCalls() : Collections.EMPTY_LIST;
        List recordedCalls = journeyRecordedCalls != null ? journeyRecordedCalls.getRecordedCalls() : Collections.EMPTY_LIST;
        TripPattern pattern = timetable.getPattern();
        ArrayList<Object> alreadyVisited = new ArrayList<Object>();
        ArrayList<StopLocation> modifiedStops = new ArrayList<StopLocation>();
        for (int i = 0; i < pattern.numberOfStops(); ++i) {
            StopLocation alternativeStop;
            boolean stopsMatchById;
            StopLocation stop = pattern.getStop(i);
            boolean foundMatch = false;
            if (i < recordedCalls.size()) {
                for (RecordedCall recordedCall : recordedCalls) {
                    if (alreadyVisited.contains(recordedCall)) continue;
                    stopsMatchById = stop.getId().getId().equals(recordedCall.getStopPointRef().getValue());
                    if (!stopsMatchById && stop.isPartOfStation() && (alternativeStop = routingService.getStopForId(new FeedScopedId(stop.getId().getFeedId(), recordedCall.getStopPointRef().getValue()))) != null && stop.isPartOfSameStationAs(alternativeStop)) {
                        stopsMatchById = true;
                        stop = alternativeStop;
                    }
                    if (!stopsMatchById) continue;
                    foundMatch = true;
                    modifiedStops.add(stop);
                    alreadyVisited.add(recordedCall);
                    break;
                }
            } else {
                for (EstimatedCall estimatedCall : estimatedCalls) {
                    if (alreadyVisited.contains(estimatedCall)) continue;
                    stopsMatchById = stop.getId().getId().equals(estimatedCall.getStopPointRef().getValue());
                    if (!stopsMatchById && stop.isPartOfStation() && (alternativeStop = routingService.getStopForId(new FeedScopedId(stop.getId().getFeedId(), estimatedCall.getStopPointRef().getValue()))) != null && stop.isPartOfSameStationAs(alternativeStop)) {
                        stopsMatchById = true;
                        stop = alternativeStop;
                    }
                    if (!stopsMatchById) continue;
                    foundMatch = true;
                    modifiedStops.add(stop);
                    alreadyVisited.add(estimatedCall);
                    break;
                }
            }
            if (foundMatch) continue;
            modifiedStops.add(stop);
        }
        return modifiedStops;
    }

    public static List<StopTime> createModifiedStopTimes(Timetable timetable, TripTimes oldTimes, EstimatedVehicleJourney journey, Trip trip, RoutingService routingService) {
        if (journey == null) {
            return null;
        }
        List estimatedCalls = journey.getEstimatedCalls() != null ? journey.getEstimatedCalls().getEstimatedCalls() : Collections.EMPTY_LIST;
        List recordedCalls = journey.getRecordedCalls() != null ? journey.getRecordedCalls().getRecordedCalls() : Collections.EMPTY_LIST;
        List<StopLocation> stops = TimetableHelper.createModifiedStops(timetable, journey, routingService);
        ArrayList<StopTime> modifiedStops = new ArrayList<StopTime>();
        ZonedDateTime departureDate = null;
        int numberOfRecordedCalls = journey.getRecordedCalls() != null && journey.getRecordedCalls().getRecordedCalls() != null ? journey.getRecordedCalls().getRecordedCalls().size() : 0;
        HashSet<Object> alreadyVisited = new HashSet<Object>();
        for (int i = 0; i < stops.size(); ++i) {
            StopLocation stop = stops.get(i);
            StopTime stopTime = new StopTime();
            stopTime.setStop(stop);
            stopTime.setTrip(trip);
            stopTime.setStopSequence(i);
            stopTime.setDropOffType(timetable.getPattern().getAlightType(i));
            stopTime.setPickupType(timetable.getPattern().getBoardType(i));
            stopTime.setArrivalTime(oldTimes.getScheduledArrivalTime(i));
            stopTime.setDepartureTime(oldTimes.getScheduledDepartureTime(i));
            stopTime.setStopHeadsign(oldTimes.getHeadsign(i));
            boolean foundMatch = false;
            if (i < numberOfRecordedCalls) {
                for (RecordedCall recordedCall : recordedCalls) {
                    StopLocation alternativeStop;
                    if (alreadyVisited.contains(recordedCall)) continue;
                    String callStopRef = recordedCall.getStopPointRef().getValue();
                    boolean stopsMatchById = stop.getId().getId().equals(callStopRef);
                    if (!stopsMatchById && stop.isPartOfStation() && (alternativeStop = routingService.getStopForId(new FeedScopedId(stop.getId().getFeedId(), callStopRef))) != null && stop.isPartOfSameStationAs(alternativeStop)) {
                        stopsMatchById = true;
                        stopTime.setStop(alternativeStop);
                    }
                    if (!stopsMatchById) continue;
                    foundMatch = true;
                    if (recordedCall.isCancellation() != null && recordedCall.isCancellation().booleanValue()) {
                        stopTime.cancel();
                    }
                    modifiedStops.add(stopTime);
                    alreadyVisited.add(recordedCall);
                    break;
                }
            } else {
                for (EstimatedCall estimatedCall : estimatedCalls) {
                    StopLocation alternativeStop;
                    boolean stopsMatchById;
                    if (alreadyVisited.contains(estimatedCall)) continue;
                    if (departureDate == null) {
                        ZonedDateTime zonedDateTime = departureDate = estimatedCall.getAimedDepartureTime() != null ? estimatedCall.getAimedDepartureTime() : estimatedCall.getAimedArrivalTime();
                    }
                    if (!(stopsMatchById = stop.getId().getId().equals(estimatedCall.getStopPointRef().getValue())) && stop.isPartOfStation() && (alternativeStop = routingService.getStopForId(new FeedScopedId(stop.getId().getFeedId(), estimatedCall.getStopPointRef().getValue()))) != null && stop.isPartOfSameStationAs(alternativeStop)) {
                        stopsMatchById = true;
                        stopTime.setStop(alternativeStop);
                    }
                    if (!stopsMatchById) continue;
                    foundMatch = true;
                    CallStatusEnumeration arrivalStatus = estimatedCall.getArrivalStatus();
                    if (arrivalStatus == CallStatusEnumeration.CANCELLED) {
                        stopTime.cancelDropOff();
                    } else if (estimatedCall.getArrivalBoardingActivity() == ArrivalBoardingActivityEnumeration.ALIGHTING) {
                        stopTime.setDropOffType(PickDrop.SCHEDULED);
                    } else if (estimatedCall.getArrivalBoardingActivity() == ArrivalBoardingActivityEnumeration.NO_ALIGHTING) {
                        stopTime.setDropOffType(PickDrop.NONE);
                    } else if (estimatedCall.getArrivalBoardingActivity() == null && i == 0) {
                        stopTime.setDropOffType(PickDrop.NONE);
                    }
                    CallStatusEnumeration departureStatus = estimatedCall.getDepartureStatus();
                    if (departureStatus == CallStatusEnumeration.CANCELLED) {
                        stopTime.cancelPickup();
                    } else if (estimatedCall.getDepartureBoardingActivity() == DepartureBoardingActivityEnumeration.BOARDING) {
                        stopTime.setPickupType(PickDrop.SCHEDULED);
                    } else if (estimatedCall.getDepartureBoardingActivity() == DepartureBoardingActivityEnumeration.NO_BOARDING) {
                        stopTime.setPickupType(PickDrop.NONE);
                    } else if (estimatedCall.getDepartureBoardingActivity() == null && i == stops.size() - 1) {
                        stopTime.setPickupType(PickDrop.NONE);
                    }
                    if (estimatedCall.isCancellation() != null && estimatedCall.isCancellation().booleanValue()) {
                        stopTime.cancel();
                    }
                    if (estimatedCall.getDestinationDisplaies() != null && !estimatedCall.getDestinationDisplaies().isEmpty()) {
                        NaturalLanguageStringStructure destinationDisplay = (NaturalLanguageStringStructure)estimatedCall.getDestinationDisplaies().get(0);
                        stopTime.setStopHeadsign(destinationDisplay.getValue());
                    }
                    modifiedStops.add(stopTime);
                    alreadyVisited.add(estimatedCall);
                    break;
                }
            }
            if (foundMatch) continue;
            modifiedStops.add(stopTime);
        }
        return modifiedStops;
    }

    public static TripTimes createUpdatedTripTimes(Timetable timetable, Graph graph, VehicleActivityStructure activity, TimeZone timeZone, FeedScopedId tripId) {
        if (activity == null) {
            return null;
        }
        VehicleActivityStructure.MonitoredVehicleJourney mvj = activity.getMonitoredVehicleJourney();
        int tripIndex = timetable.getTripIndex(tripId);
        if (tripIndex == -1) {
            LOG.trace("tripId {} not found in pattern.", (Object)tripId);
            return null;
        }
        TripTimes existingTripTimes = timetable.getTripTimes(tripIndex);
        TripTimes newTimes = new TripTimes(existingTripTimes);
        MonitoredCallStructure update = mvj.getMonitoredCall();
        if (update == null) {
            return null;
        }
        VehicleActivityStructure.MonitoredVehicleJourney monitoredVehicleJourney = activity.getMonitoredVehicleJourney();
        Duration delay = null;
        if (monitoredVehicleJourney != null) {
            MonitoredCallStructure monitoredCall;
            delay = monitoredVehicleJourney.getDelay();
            int updatedDelay = 0;
            if (delay != null) {
                updatedDelay = delay.getSign() * (delay.getHours() * 3600 + delay.getMinutes() * 60 + delay.getSeconds());
            }
            if ((monitoredCall = monitoredVehicleJourney.getMonitoredCall()) != null && monitoredCall.getStopPointRef() != null) {
                boolean matchFound = false;
                int arrivalDelay = 0;
                int departureDelay = 0;
                TripPattern pattern = timetable.getPattern();
                for (int index = 0; index < newTimes.getNumStops(); ++index) {
                    if (!matchFound) {
                        FeedScopedId alternativeId;
                        StopLocation alternativeStop;
                        StopLocation stop = pattern.getStop(index);
                        matchFound = stop.getId().getId().equals(monitoredCall.getStopPointRef().getValue());
                        if (!matchFound && stop.isPartOfStation() && (alternativeStop = graph.index.getStopForId(alternativeId = new FeedScopedId(stop.getId().getFeedId(), monitoredCall.getStopPointRef().getValue()))) != null && alternativeStop.isPartOfStation()) {
                            matchFound = stop.isPartOfSameStationAs(alternativeStop);
                        }
                        if (matchFound) {
                            arrivalDelay = departureDelay = updatedDelay;
                        } else {
                            arrivalDelay = Math.min(existingTripTimes.getArrivalDelay(index), updatedDelay);
                            departureDelay = Math.min(existingTripTimes.getDepartureDelay(index), updatedDelay);
                        }
                    }
                    newTimes.updateArrivalDelay(index, arrivalDelay);
                    newTimes.updateDepartureDelay(index, departureDelay);
                }
            }
        }
        if (!newTimes.timesIncreasing()) {
            LOG.info("TripTimes are non-increasing after applying SIRI delay propagation - delay: {}", (Object)delay);
            return null;
        }
        if (newTimes.getRealTimeState() != RealTimeState.MODIFIED) {
            newTimes.setRealTimeState(RealTimeState.UPDATED);
        }
        return newTimes;
    }

    public static Trip getTrip(FeedScopedId tripId, Timetable timetable) {
        for (TripTimes tt : timetable.getTripTimes()) {
            if (!tt.getTrip().getId().equals(tripId)) continue;
            return tt.getTrip();
        }
        return null;
    }
}

