/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri;

import java.util.concurrent.atomic.AtomicInteger;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Trip;

class SiriTripPatternIdGenerator {
    private final AtomicInteger counter = new AtomicInteger(0);

    SiriTripPatternIdGenerator() {
    }

    FeedScopedId generateUniqueTripPatternId(Trip trip) {
        Route route = trip.getRoute();
        FeedScopedId routeId = route.getId();
        String directionId = trip.getGtfsDirectionIdAsString("");
        String id = String.format("%s:%s:%03d:RT", routeId.getId(), directionId, this.counter.incrementAndGet());
        return new FeedScopedId(routeId.getFeedId(), id);
    }
}

