/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.opentripplanner.ext.siri.SiriTripPatternIdGenerator;
import org.opentripplanner.ext.siri.StopPatternServiceDateKey;
import org.opentripplanner.ext.siri.TripServiceDateKey;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopPattern;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.routing.graph.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiriTripPatternCache {
    private static final Logger log = LoggerFactory.getLogger(SiriTripPatternCache.class);
    private final Map<StopPatternServiceDateKey, TripPattern> cache = new HashMap<StopPatternServiceDateKey, TripPattern>();
    private final ListMultimap<StopLocation, TripPattern> patternsForStop = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private final Map<TripServiceDateKey, TripPattern> updatedTripPatternsForTripCache = new HashMap<TripServiceDateKey, TripPattern>();
    private final SiriTripPatternIdGenerator tripPatternIdGenerator;

    public SiriTripPatternCache(SiriTripPatternIdGenerator tripPatternIdGenerator) {
        this.tripPatternIdGenerator = tripPatternIdGenerator;
    }

    public synchronized TripPattern getOrCreateTripPattern(@NotNull StopPattern stopPattern, @NotNull Trip trip, @NotNull Graph graph, @NotNull ServiceDate serviceDate) {
        TripPattern cachedTripPattern;
        TripServiceDateKey tripServiceDateKey;
        StopPatternServiceDateKey key = new StopPatternServiceDateKey(stopPattern, serviceDate);
        TripPattern tripPattern = this.cache.get(key);
        if (tripPattern == null) {
            FeedScopedId id = this.tripPatternIdGenerator.generateUniqueTripPatternId(trip);
            tripPattern = new TripPattern(id, trip.getRoute(), stopPattern);
            tripPattern.setServiceCodes(graph.getServiceCodes());
            tripPattern.getScheduledTimetable().finish();
            TripPattern originalTripPattern = graph.index.getPatternForTrip().get(trip);
            tripPattern.setCreatedByRealtimeUpdater();
            if (originalTripPattern != null) {
                tripPattern.setOriginalTripPattern(originalTripPattern);
                tripPattern.setHopGeometriesFromPattern(originalTripPattern);
            }
            this.cache.put(key, tripPattern);
        }
        if (this.updatedTripPatternsForTripCache.containsKey(tripServiceDateKey = new TripServiceDateKey(trip, serviceDate)) && (cachedTripPattern = this.updatedTripPatternsForTripCache.get(tripServiceDateKey)) != null && !tripPattern.stopPatternIsEqual(cachedTripPattern)) {
            int sizeBefore = this.patternsForStop.values().size();
            long t1 = System.currentTimeMillis();
            this.patternsForStop.values().removeAll(Arrays.asList(cachedTripPattern));
            int sizeAfter = this.patternsForStop.values().size();
            log.info("Removed outdated TripPattern for {} stops in {} ms - tripId: {}", new Object[]{sizeBefore - sizeAfter, System.currentTimeMillis() - t1, trip.getId()});
        }
        for (StopLocation stop : tripPattern.getStops()) {
            if (this.patternsForStop.containsEntry((Object)stop, (Object)tripPattern)) continue;
            this.patternsForStop.put((Object)stop, (Object)tripPattern);
        }
        this.updatedTripPatternsForTripCache.put(tripServiceDateKey, tripPattern);
        return tripPattern;
    }

    public List<TripPattern> getAddedTripPatternsForStop(Stop stop) {
        return this.patternsForStop.get((Object)stop);
    }
}

