/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri;

import com.google.common.base.Preconditions;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.ext.siri.SiriFuzzyTripMatcher;
import org.opentripplanner.ext.siri.SiriTransportModeMapper;
import org.opentripplanner.ext.siri.SiriTripPatternCache;
import org.opentripplanner.ext.siri.SiriTripPatternIdGenerator;
import org.opentripplanner.ext.siri.TimetableHelper;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Operator;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopPattern;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.TimetableSnapshot;
import org.opentripplanner.model.TimetableSnapshotProvider;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.DateMapper;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.TransitLayerUpdater;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.trippattern.RealTimeState;
import org.opentripplanner.routing.trippattern.TripTimes;
import org.rutebanken.netex.model.BusSubmodeEnumeration;
import org.rutebanken.netex.model.RailSubmodeEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.ArrivalBoardingActivityEnumeration;
import uk.org.siri.siri20.DepartureBoardingActivityEnumeration;
import uk.org.siri.siri20.EstimatedCall;
import uk.org.siri.siri20.EstimatedTimetableDeliveryStructure;
import uk.org.siri.siri20.EstimatedVehicleJourney;
import uk.org.siri.siri20.EstimatedVersionFrameStructure;
import uk.org.siri.siri20.NaturalLanguageStringStructure;
import uk.org.siri.siri20.RecordedCall;
import uk.org.siri.siri20.VehicleActivityStructure;
import uk.org.siri.siri20.VehicleModesEnumeration;
import uk.org.siri.siri20.VehicleMonitoringDeliveryStructure;

public class SiriTimetableSnapshotSource
implements TimetableSnapshotProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SiriTimetableSnapshotSource.class);
    private static boolean keepLogging = true;
    public int logFrequency = 2000;
    public int maxSnapshotFrequency = 1000;
    private volatile TimetableSnapshot snapshot = null;
    private final TimetableSnapshot buffer = new TimetableSnapshot();
    private final ReentrantLock bufferLock = new ReentrantLock(true);
    private final SiriTripPatternIdGenerator tripPatternIdGenerator = new SiriTripPatternIdGenerator();
    private final SiriTripPatternCache tripPatternCache = new SiriTripPatternCache(this.tripPatternIdGenerator);
    public boolean purgeExpiredData = true;
    protected ServiceDate lastPurgeDate = null;
    protected long lastSnapshotTime = -1L;
    private final TimeZone timeZone;
    private final RoutingService routingService;
    private final SiriFuzzyTripMatcher siriFuzzyTripMatcher;
    private final TransitLayerUpdater transitLayerUpdater;

    public SiriTimetableSnapshotSource(Graph graph) {
        this.timeZone = graph.getTimeZone();
        this.routingService = new RoutingService(graph);
        this.transitLayerUpdater = graph.transitLayerUpdater;
        this.siriFuzzyTripMatcher = new SiriFuzzyTripMatcher(this.routingService);
    }

    @Override
    public TimetableSnapshot getTimetableSnapshot() {
        TimetableSnapshot snapshotToReturn;
        if (this.bufferLock.tryLock()) {
            try {
                snapshotToReturn = this.getTimetableSnapshot(false);
            }
            finally {
                this.bufferLock.unlock();
            }
        } else {
            snapshotToReturn = this.snapshot;
        }
        return snapshotToReturn;
    }

    private TimetableSnapshot getTimetableSnapshot(boolean force) {
        long now = System.currentTimeMillis();
        if (force || now - this.lastSnapshotTime > (long)this.maxSnapshotFrequency) {
            if (force || this.buffer.isDirty()) {
                LOG.debug("Committing {}", (Object)this.buffer.toString());
                this.snapshot = this.buffer.commit(this.transitLayerUpdater, force);
            } else {
                LOG.debug("Buffer was unchanged, keeping old snapshot.");
            }
            this.lastSnapshotTime = System.currentTimeMillis();
        } else {
            LOG.debug("Snapshot frequency exceeded. Reusing snapshot {}", (Object)this.snapshot);
        }
        return this.snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyVehicleMonitoring(Graph graph, String feedId, boolean fullDataset, List<VehicleMonitoringDeliveryStructure> updates) {
        if (updates == null) {
            LOG.warn("updates is null");
            return;
        }
        this.bufferLock.lock();
        try {
            if (fullDataset) {
                this.buffer.clear(feedId);
            }
            for (VehicleMonitoringDeliveryStructure vmDelivery : updates) {
                List notes;
                List cancellations;
                ServiceDate serviceDate = new ServiceDate();
                List activities = vmDelivery.getVehicleActivities();
                if (activities != null) {
                    LOG.info("Handling {} VM-activities.", (Object)activities.size());
                    int handledCounter = 0;
                    int skippedCounter = 0;
                    for (VehicleActivityStructure activity : activities) {
                        boolean handled = this.handleModifiedTrip(graph, feedId, activity, serviceDate);
                        if (handled) {
                            ++handledCounter;
                            continue;
                        }
                        ++skippedCounter;
                    }
                    LOG.info("Applied {} VM-activities, skipped {}.", (Object)handledCounter, (Object)skippedCounter);
                }
                if ((cancellations = vmDelivery.getVehicleActivityCancellations()) != null && !cancellations.isEmpty()) {
                    LOG.info("TODO: Handle {} cancellations.", (Object)cancellations.size());
                }
                if ((notes = vmDelivery.getVehicleActivityNotes()) == null || notes.isEmpty()) continue;
                LOG.info("TODO: Handle {} notes.", (Object)notes.size());
            }
            if (this.purgeExpiredData) {
                boolean modified = this.purgeExpiredData();
                this.getTimetableSnapshot(modified);
            } else {
                this.getTimetableSnapshot(false);
            }
        }
        finally {
            this.bufferLock.unlock();
            if (keepLogging) {
                LOG.info("Reducing SIRI-VM logging until restart");
                keepLogging = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyEstimatedTimetable(Graph graph, String feedId, boolean fullDataset, List<EstimatedTimetableDeliveryStructure> updates) {
        if (updates == null) {
            LOG.warn("updates is null");
            return;
        }
        this.bufferLock.lock();
        try {
            if (fullDataset) {
                this.buffer.clear(feedId);
            }
            for (EstimatedTimetableDeliveryStructure etDelivery : updates) {
                List estimatedJourneyVersions = etDelivery.getEstimatedJourneyVersionFrames();
                if (estimatedJourneyVersions == null) continue;
                for (EstimatedVersionFrameStructure estimatedJourneyVersion : estimatedJourneyVersions) {
                    List journeys = estimatedJourneyVersion.getEstimatedVehicleJourneies();
                    LOG.debug("Handling {} EstimatedVehicleJourneys.", (Object)journeys.size());
                    int handledCounter = 0;
                    int skippedCounter = 0;
                    int addedCounter = 0;
                    int notMonitoredCounter = 0;
                    for (EstimatedVehicleJourney journey : journeys) {
                        if (journey.isExtraJourney() != null && journey.isExtraJourney().booleanValue()) {
                            try {
                                if (this.handleAddedTrip(graph, feedId, journey)) {
                                    ++addedCounter;
                                    continue;
                                }
                                ++skippedCounter;
                            }
                            catch (Throwable t) {
                                LOG.warn("Adding ExtraJourney with id='{}' failed, caused by '{}'.", (Object)journey.getEstimatedVehicleJourneyCode(), (Object)t.getMessage());
                                ++skippedCounter;
                            }
                            continue;
                        }
                        if (this.handleModifiedTrip(graph, feedId, journey)) {
                            ++handledCounter;
                            continue;
                        }
                        if (journey.isMonitored() != null && !journey.isMonitored().booleanValue()) {
                            ++notMonitoredCounter;
                            continue;
                        }
                        ++skippedCounter;
                    }
                    LOG.debug("Processed EstimatedVehicleJourneys: updated {}, added {}, skipped {}, not monitored {}.", new Object[]{handledCounter, addedCounter, skippedCounter, notMonitoredCounter});
                }
            }
            LOG.debug("message contains {} trip updates", (Object)updates.size());
            LOG.debug("end of update message");
            if (this.purgeExpiredData) {
                boolean modified = this.purgeExpiredData();
                this.getTimetableSnapshot(modified);
            } else {
                this.getTimetableSnapshot(false);
            }
        }
        finally {
            this.bufferLock.unlock();
        }
    }

    private boolean handleModifiedTrip(Graph graph, String feedId, VehicleActivityStructure activity, ServiceDate serviceDate) {
        if (activity.getValidUntilTime().isBefore(ZonedDateTime.now())) {
            return false;
        }
        if (activity.getMonitoredVehicleJourney() == null || activity.getMonitoredVehicleJourney().getVehicleRef() == null || activity.getMonitoredVehicleJourney().getLineRef() == null) {
            return false;
        }
        Boolean isMonitored = activity.getMonitoredVehicleJourney().isMonitored();
        if (isMonitored != null && !isMonitored.booleanValue()) {
            return false;
        }
        Set<Trip> trips = this.siriFuzzyTripMatcher.match(activity);
        if (trips == null || trips.isEmpty()) {
            if (keepLogging) {
                String lineRef = activity.getMonitoredVehicleJourney().getLineRef() != null ? activity.getMonitoredVehicleJourney().getLineRef().getValue() : null;
                String vehicleRef = activity.getMonitoredVehicleJourney().getVehicleRef() != null ? activity.getMonitoredVehicleJourney().getVehicleRef().getValue() : null;
                String tripId = activity.getMonitoredVehicleJourney().getCourseOfJourneyRef() != null ? activity.getMonitoredVehicleJourney().getCourseOfJourneyRef().getValue() : null;
                LOG.debug("No trip found for [isMonitored={}, lineRef={}, vehicleRef={}, tripId={}], skipping VehicleActivity.", new Object[]{isMonitored, lineRef, vehicleRef, tripId});
            }
            return false;
        }
        Trip trip = this.getTripForJourney(trips, activity.getMonitoredVehicleJourney());
        if (trip == null) {
            return false;
        }
        Set<TripPattern> patterns = this.getPatternsForTrip(trips, activity.getMonitoredVehicleJourney());
        if (patterns == null) {
            return false;
        }
        boolean success = false;
        for (TripPattern pattern : patterns) {
            if (!this.handleTripPatternUpdate(graph, pattern, activity, trip, serviceDate)) continue;
            success = true;
        }
        if (!success) {
            LOG.info("Pattern not updated for trip " + trip.getId());
        }
        return success;
    }

    private boolean handleTripPatternUpdate(Graph graph, TripPattern pattern, VehicleActivityStructure activity, Trip trip, ServiceDate serviceDate) {
        Timetable currentTimetable = this.getCurrentTimetable(pattern, serviceDate);
        TripTimes updatedTripTimes = TimetableHelper.createUpdatedTripTimes(currentTimetable, graph, activity, this.timeZone, trip.getId());
        if (updatedTripTimes == null) {
            return false;
        }
        return this.buffer.update(pattern, updatedTripTimes, serviceDate);
    }

    private Timetable getCurrentTimetable(TripPattern tripPattern, ServiceDate serviceDate) {
        TimetableSnapshot timetableSnapshot = this.getTimetableSnapshot();
        if (timetableSnapshot != null) {
            return this.getTimetableSnapshot().resolve(tripPattern, serviceDate);
        }
        return tripPattern.getScheduledTimetable();
    }

    private boolean handleAddedTrip(Graph graph, String feedId, EstimatedVehicleJourney estimatedVehicleJourney) {
        FeedScopedId routeId;
        Route route;
        String newServiceJourneyRef = estimatedVehicleJourney.getEstimatedVehicleJourneyCode();
        Preconditions.checkNotNull((Object)newServiceJourneyRef, (Object)"EstimatedVehicleJourneyCode is required");
        Preconditions.checkNotNull((Object)estimatedVehicleJourney.getLineRef(), (Object)"LineRef is required");
        String lineRef = estimatedVehicleJourney.getLineRef().getValue();
        Preconditions.checkNotNull((Object)estimatedVehicleJourney.getOperatorRef(), (Object)"OperatorRef is required");
        String operatorRef = estimatedVehicleJourney.getOperatorRef().getValue();
        String externalLineRef = estimatedVehicleJourney.getExternalLineRef() != null ? estimatedVehicleJourney.getExternalLineRef().getValue() : lineRef;
        Operator operator = graph.index.getOperatorForId().get(new FeedScopedId(feedId, operatorRef));
        FeedScopedId tripId = new FeedScopedId(feedId, newServiceJourneyRef);
        Route replacedRoute = null;
        if (externalLineRef != null) {
            replacedRoute = graph.index.getRouteForId(new FeedScopedId(feedId, externalLineRef));
        }
        if ((route = graph.index.getRouteForId(routeId = new FeedScopedId(feedId, lineRef))) == null) {
            route = new Route(routeId);
            T2<TransitMode, String> transitMode = this.getTransitMode(estimatedVehicleJourney.getVehicleModes(), replacedRoute);
            route.setMode((TransitMode)((Object)transitMode.first));
            route.setNetexSubmode((String)transitMode.second);
            route.setOperator(operator);
            Agency agency = graph.index.getAllRoutes().stream().filter(route1 -> route1 != null && route1.getOperator() != null && route1.getOperator().equals(operator)).findFirst().get().getAgency();
            route.setAgency(agency);
            if (estimatedVehicleJourney.getPublishedLineNames() != null && !estimatedVehicleJourney.getPublishedLineNames().isEmpty()) {
                route.setShortName(((NaturalLanguageStringStructure)estimatedVehicleJourney.getPublishedLineNames().get(0)).getValue());
            }
            LOG.info("Adding route {} to graph.", (Object)routeId);
            graph.index.addRoutes(route);
        }
        Trip trip = new Trip(tripId);
        trip.setRoute(route);
        ServiceDate serviceDate = this.getServiceDateForEstimatedVehicleJourney(estimatedVehicleJourney);
        if (serviceDate == null) {
            return false;
        }
        FeedScopedId calServiceId = graph.getOrCreateServiceIdForDate(serviceDate);
        if (calServiceId == null) {
            return false;
        }
        trip.setServiceId(calServiceId);
        if (estimatedVehicleJourney.getPublishedLineNames() != null && !estimatedVehicleJourney.getPublishedLineNames().isEmpty()) {
            trip.setRouteShortName(((NaturalLanguageStringStructure)estimatedVehicleJourney.getPublishedLineNames().get(0)).getValue());
        }
        if (estimatedVehicleJourney.getDestinationNames() != null && !estimatedVehicleJourney.getDestinationNames().isEmpty()) {
            trip.setTripHeadsign(((NaturalLanguageStringStructure)estimatedVehicleJourney.getDestinationNames().get(0)).getValue());
        }
        trip.setTripOperator(operator);
        trip.setShapeId(null);
        trip.setBlockId(null);
        trip.setTripShortName(null);
        ArrayList<StopLocation> addedStops = new ArrayList<StopLocation>();
        ArrayList<StopTime> aimedStopTimes = new ArrayList<StopTime>();
        ZonedDateTime departureTime = null;
        List estimatedCalls = estimatedVehicleJourney.getEstimatedCalls().getEstimatedCalls();
        for (int i = 0; i < estimatedCalls.size(); ++i) {
            EstimatedCall estimatedCall = (EstimatedCall)estimatedCalls.get(i);
            StopLocation stop = this.getStopForStopId(feedId, estimatedCall.getStopPointRef().getValue());
            StopTime stopTime = new StopTime();
            stopTime.setStop(stop);
            stopTime.setStopSequence(i);
            stopTime.setTrip(trip);
            ZonedDateTime aimedArrivalTime = estimatedCall.getAimedArrivalTime();
            ZonedDateTime aimedDepartureTime = estimatedCall.getAimedDepartureTime();
            if (departureTime == null) {
                departureTime = aimedDepartureTime;
            }
            if (aimedArrivalTime != null) {
                stopTime.setArrivalTime(this.calculateSecondsSinceMidnight(departureTime, aimedArrivalTime));
            }
            if (aimedDepartureTime != null) {
                stopTime.setDepartureTime(this.calculateSecondsSinceMidnight(departureTime, aimedDepartureTime));
            }
            if (estimatedCall.getArrivalBoardingActivity() == ArrivalBoardingActivityEnumeration.ALIGHTING) {
                stopTime.setDropOffType(PickDrop.SCHEDULED);
            } else {
                stopTime.setDropOffType(PickDrop.NONE);
            }
            if (estimatedCall.getDepartureBoardingActivity() == DepartureBoardingActivityEnumeration.BOARDING) {
                stopTime.setPickupType(PickDrop.SCHEDULED);
            } else {
                stopTime.setPickupType(PickDrop.NONE);
            }
            if (estimatedCall.getDestinationDisplaies() != null && !estimatedCall.getDestinationDisplaies().isEmpty()) {
                NaturalLanguageStringStructure destinationDisplay = (NaturalLanguageStringStructure)estimatedCall.getDestinationDisplaies().get(0);
                stopTime.setStopHeadsign(destinationDisplay.getValue());
            } else if (trip.getTripHeadsign() == null) {
                stopTime.setStopHeadsign("");
            }
            if (i == 0) {
                stopTime.setArrivalTime(stopTime.getDepartureTime());
            } else if (i == estimatedCalls.size() - 1) {
                stopTime.setDepartureTime(stopTime.getArrivalTime());
            }
            if (estimatedCall.isCancellation() != null && estimatedCall.isCancellation().booleanValue()) {
                stopTime.cancel();
            }
            addedStops.add(stop);
            aimedStopTimes.add(stopTime);
        }
        StopPattern stopPattern = new StopPattern(aimedStopTimes);
        FeedScopedId id = this.tripPatternIdGenerator.generateUniqueTripPatternId(trip);
        TripPattern pattern = new TripPattern(id, trip.getRoute(), stopPattern);
        TripTimes tripTimes = new TripTimes(trip, aimedStopTimes, graph.deduplicator);
        boolean isJourneyPredictionInaccurate = estimatedVehicleJourney.isPredictionInaccurate() != null && estimatedVehicleJourney.isPredictionInaccurate() != false;
        for (int i = 0; i < estimatedCalls.size(); ++i) {
            EstimatedCall estimatedCall = (EstimatedCall)estimatedCalls.get(i);
            ZonedDateTime expectedArrival = estimatedCall.getExpectedArrivalTime();
            ZonedDateTime expectedDeparture = estimatedCall.getExpectedDepartureTime();
            int aimedArrivalTime = ((StopTime)aimedStopTimes.get(i)).getArrivalTime();
            int aimedDepartureTime = ((StopTime)aimedStopTimes.get(i)).getDepartureTime();
            if (expectedArrival != null) {
                int expectedArrivalTime = this.calculateSecondsSinceMidnight(departureTime, expectedArrival);
                tripTimes.updateArrivalDelay(i, expectedArrivalTime - aimedArrivalTime);
            }
            if (expectedDeparture != null) {
                int expectedDepartureTime = this.calculateSecondsSinceMidnight(departureTime, expectedDeparture);
                tripTimes.updateDepartureDelay(i, expectedDepartureTime - aimedDepartureTime);
            }
            if (estimatedCall.isCancellation() != null && estimatedCall.isCancellation().booleanValue()) {
                tripTimes.setCancelled(i);
            }
            boolean isCallPredictionInaccurate = estimatedCall.isPredictionInaccurate() != null && estimatedCall.isPredictionInaccurate() != false;
            tripTimes.setPredictionInaccurate(i, isJourneyPredictionInaccurate | isCallPredictionInaccurate);
            if (i == 0) {
                tripTimes.updateArrivalTime(i, tripTimes.getDepartureTime(i));
                continue;
            }
            if (i != estimatedCalls.size() - 1) continue;
            tripTimes.updateDepartureTime(i, tripTimes.getArrivalTime(i));
        }
        graph.index.getTripForId().put(tripId, trip);
        graph.index.getPatternForTrip().put(trip, pattern);
        if (estimatedVehicleJourney.isCancellation() != null && estimatedVehicleJourney.isCancellation().booleanValue()) {
            tripTimes.cancelTrip();
        } else {
            tripTimes.setRealTimeState(RealTimeState.ADDED);
        }
        tripTimes.setServiceCode(graph.getServiceCodes().get(calServiceId));
        pattern.add(tripTimes);
        Preconditions.checkState((boolean)tripTimes.timesIncreasing(), (Object)"Non-increasing triptimes for added trip");
        return this.addTripToGraphAndBuffer(feedId, graph, trip, aimedStopTimes, addedStops, tripTimes, serviceDate);
    }

    private T2<TransitMode, String> getTransitMode(List<VehicleModesEnumeration> vehicleModes, Route replacedRoute) {
        TransitMode transitMode = SiriTransportModeMapper.mapTransitMainMode(vehicleModes);
        String transitSubMode = this.resolveTransitSubMode(transitMode, replacedRoute);
        return new T2<TransitMode, String>(transitMode, transitSubMode);
    }

    private String resolveTransitSubMode(TransitMode transitMode, Route replacedRoute) {
        TransitMode replacedRouteMode;
        if (replacedRoute != null && (replacedRouteMode = replacedRoute.getMode()) != null && replacedRouteMode.equals((Object)TransitMode.RAIL)) {
            if (transitMode.equals((Object)TransitMode.RAIL)) {
                return RailSubmodeEnumeration.REPLACEMENT_RAIL_SERVICE.value();
            }
            if (transitMode.equals((Object)TransitMode.BUS)) {
                return BusSubmodeEnumeration.RAIL_REPLACEMENT_BUS.value();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean handleModifiedTrip(Graph graph, String feedId, EstimatedVehicleJourney estimatedVehicleJourney) {
        if (estimatedVehicleJourney.isMonitored() != null && !estimatedVehicleJourney.isMonitored().booleanValue() && estimatedVehicleJourney.isCancellation() != null && !estimatedVehicleJourney.isCancellation().booleanValue()) {
            return false;
        }
        String operatorRef = estimatedVehicleJourney.getOperatorRef() != null ? estimatedVehicleJourney.getOperatorRef().getValue() : null;
        String vehicleModes = "" + estimatedVehicleJourney.getVehicleModes();
        String lineRef = estimatedVehicleJourney.getLineRef().getValue();
        String vehicleRef = estimatedVehicleJourney.getVehicleRef() != null ? estimatedVehicleJourney.getVehicleRef().getValue() : null;
        ServiceDate serviceDate = this.getServiceDateForEstimatedVehicleJourney(estimatedVehicleJourney);
        if (serviceDate == null) {
            return false;
        }
        HashSet<TripTimes> times = new HashSet<TripTimes>();
        HashSet<TripPattern> patterns = new HashSet<TripPattern>();
        Trip tripMatchedByServiceJourneyId = this.siriFuzzyTripMatcher.findTripByDatedVehicleJourneyRef(estimatedVehicleJourney);
        if (tripMatchedByServiceJourneyId != null) {
            TripPattern exactPattern = this.routingService.getPatternForTrip().get(tripMatchedByServiceJourneyId);
            if (exactPattern != null) {
                Timetable currentTimetable = this.getCurrentTimetable(exactPattern, serviceDate);
                TripTimes tripTimes = TimetableHelper.createUpdatedTripTimes(graph, currentTimetable, estimatedVehicleJourney, this.timeZone, tripMatchedByServiceJourneyId.getId());
                if (tripTimes == null) {
                    LOG.info("Failed to update TripTimes for trip found by exact match {}", (Object)tripMatchedByServiceJourneyId.getId());
                    return false;
                }
                times.add(tripTimes);
                patterns.add(exactPattern);
            }
        } else {
            Set<Trip> trips = this.siriFuzzyTripMatcher.match(estimatedVehicleJourney);
            if (trips == null || trips.isEmpty()) {
                LOG.debug("No trips found for EstimatedVehicleJourney. [operator={}, vehicleModes={}, lineRef={}, vehicleRef={}]", new Object[]{operatorRef, vehicleModes, lineRef, vehicleRef});
                return false;
            }
            Set<Trip> matchingTrips = this.getTripForJourney(trips, estimatedVehicleJourney);
            if (matchingTrips == null || matchingTrips.isEmpty()) {
                LOG.debug("Found no matching trip for SIRI ET (serviceDate, departureTime). [operator={}, vehicleModes={}, lineRef={}, vehicleJourneyRef={}]", new Object[]{operatorRef, vehicleModes, lineRef, vehicleRef});
                return false;
            }
            for (Trip matchingTrip : matchingTrips) {
                Timetable currentTimetable;
                TripTimes updatedTripTimes;
                TripPattern pattern = this.getPatternForTrip(matchingTrip, estimatedVehicleJourney);
                if (pattern == null || (updatedTripTimes = TimetableHelper.createUpdatedTripTimes(graph, currentTimetable = this.getCurrentTimetable(pattern, serviceDate), estimatedVehicleJourney, this.timeZone, matchingTrip.getId())) == null) continue;
                patterns.add(pattern);
                times.add(updatedTripTimes);
            }
        }
        if (patterns.isEmpty()) {
            LOG.debug("Found no matching pattern for SIRI ET (firstStopId, lastStopId, numberOfStops). [operator={}, vehicleModes={}, lineRef={}, vehicleRef={}]", new Object[]{operatorRef, vehicleModes, lineRef, vehicleRef});
            return false;
        }
        if (times.isEmpty()) {
            return false;
        }
        boolean result = false;
        Iterator iterator = times.iterator();
        block1: while (iterator.hasNext()) {
            TripTimes tripTimes = (TripTimes)iterator.next();
            Trip trip = tripTimes.getTrip();
            Iterator iterator2 = patterns.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block1;
                TripPattern pattern = (TripPattern)iterator2.next();
                if (tripTimes.getNumStops() == pattern.numberOfStops()) {
                    if (!tripTimes.isCanceled()) {
                        this.cancelScheduledTrip(feedId, trip.getId().getId(), serviceDate);
                        this.removePreviousRealtimeUpdate(feedId, trip.getId().getId(), serviceDate);
                        Timetable currentTimetable = this.getCurrentTimetable(pattern, serviceDate);
                        List<StopLocation> modifiedStops = TimetableHelper.createModifiedStops(currentTimetable, estimatedVehicleJourney, this.routingService);
                        List<StopTime> modifiedStopTimes = TimetableHelper.createModifiedStopTimes(currentTimetable, tripTimes, estimatedVehicleJourney, trip, this.routingService);
                        if (modifiedStops != null && modifiedStops.isEmpty()) {
                            tripTimes.cancelTrip();
                        } else {
                            result |= this.addTripToGraphAndBuffer(feedId, graph, trip, modifiedStopTimes, modifiedStops, tripTimes, serviceDate);
                        }
                    } else {
                        result |= this.buffer.update(pattern, tripTimes, serviceDate);
                    }
                    LOG.debug("Applied realtime data for trip {}", (Object)trip.getId().getId());
                    continue;
                }
                LOG.debug("Ignoring update since number of stops do not match");
            }
            break;
        }
        return result;
    }

    private ServiceDate getServiceDateForEstimatedVehicleJourney(EstimatedVehicleJourney estimatedVehicleJourney) {
        ZonedDateTime date;
        if (estimatedVehicleJourney.getRecordedCalls() != null && !estimatedVehicleJourney.getRecordedCalls().getRecordedCalls().isEmpty()) {
            date = ((RecordedCall)estimatedVehicleJourney.getRecordedCalls().getRecordedCalls().get(0)).getAimedDepartureTime();
        } else {
            EstimatedCall firstCall = (EstimatedCall)estimatedVehicleJourney.getEstimatedCalls().getEstimatedCalls().get(0);
            date = firstCall.getAimedDepartureTime();
        }
        if (date == null) {
            return null;
        }
        return new ServiceDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    private int calculateSecondsSinceMidnight(ZonedDateTime dateTime) {
        return DateMapper.secondsSinceStartOfService(dateTime, dateTime, this.routingService.getTimeZone().toZoneId());
    }

    private int calculateSecondsSinceMidnight(ZonedDateTime startOfService, ZonedDateTime dateTime) {
        return DateMapper.secondsSinceStartOfService(startOfService, dateTime, this.routingService.getTimeZone().toZoneId());
    }

    private boolean addTripToGraphAndBuffer(String feedId, Graph graph, Trip trip, List<StopTime> stopTimes, List<StopLocation> stops, TripTimes updatedTripTimes, ServiceDate serviceDate) {
        Preconditions.checkNotNull(stops);
        Preconditions.checkArgument((stopTimes.size() == stops.size() ? 1 : 0) != 0, (Object)"number of stop should match the number of stop time updates");
        StopPattern stopPattern = new StopPattern(stopTimes);
        TripPattern pattern = this.tripPatternCache.getOrCreateTripPattern(stopPattern, trip, graph, serviceDate);
        int serviceCode = graph.getServiceCodes().get(trip.getServiceId());
        if (!pattern.getServices().get(serviceCode)) {
            BitSet services = (BitSet)pattern.getServices().clone();
            services.set(serviceCode);
            pattern.setServices(services);
        }
        pattern.getScheduledTimetable().getTripTimes().clear();
        pattern.getScheduledTimetable().addTripTimes(updatedTripTimes);
        pattern.getScheduledTimetable().finish();
        pattern.getScheduledTimetable().getTripTimes().clear();
        this.buffer.update(pattern, updatedTripTimes, serviceDate);
        return this.buffer.update(pattern, updatedTripTimes, serviceDate);
    }

    private boolean cancelScheduledTrip(String feedId, String tripId, ServiceDate serviceDate) {
        boolean success = false;
        TripPattern pattern = this.getPatternForTripId(feedId, tripId);
        if (pattern != null) {
            Timetable timetable = pattern.getScheduledTimetable();
            int tripIndex = timetable.getTripIndex(tripId);
            if (tripIndex == -1) {
                LOG.warn("Could not cancel scheduled trip {}", (Object)tripId);
            } else {
                TripTimes newTripTimes = new TripTimes(timetable.getTripTimes(tripIndex));
                newTripTimes.cancelTrip();
                this.buffer.update(pattern, newTripTimes, serviceDate);
                success = true;
            }
        }
        return success;
    }

    private boolean removePreviousRealtimeUpdate(String feedId, String tripId, ServiceDate serviceDate) {
        boolean success = false;
        FeedScopedId feedScopedTripId = new FeedScopedId(feedId, tripId);
        TripPattern pattern = this.buffer.getLastAddedTripPattern(feedScopedTripId, serviceDate);
        if (pattern != null) {
            this.buffer.removeLastAddedTripPattern(feedScopedTripId, serviceDate);
            this.buffer.removeRealtimeUpdatedTripTimes(pattern, feedScopedTripId, serviceDate);
            success = true;
        }
        return success;
    }

    private boolean purgeExpiredData() {
        ServiceDate today = new ServiceDate();
        ServiceDate previously = today.previous().previous();
        if (this.lastPurgeDate != null && this.lastPurgeDate.compareTo(previously) > 0) {
            return false;
        }
        LOG.debug("purging expired realtime data");
        this.lastPurgeDate = previously;
        return this.buffer.purgeExpiredData(previously);
    }

    private TripPattern getPatternForTripId(String feedId, String tripId) {
        Trip trip = this.routingService.getTripForId().get(new FeedScopedId(feedId, tripId));
        return this.routingService.getPatternForTrip().get(trip);
    }

    private Set<TripPattern> getPatternsForTrip(Set<Trip> matches, VehicleActivityStructure.MonitoredVehicleJourney monitoredVehicleJourney) {
        if (monitoredVehicleJourney.getOriginRef() == null) {
            return null;
        }
        ZonedDateTime date = monitoredVehicleJourney.getOriginAimedDepartureTime();
        if (date == null) {
            date = ZonedDateTime.now();
        }
        ServiceDate realTimeReportedServiceDate = new ServiceDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
        HashSet<TripPattern> patterns = new HashSet<TripPattern>();
        for (Trip currentTrip : matches) {
            TripPattern tripPattern = this.routingService.getPatternForTrip().get(currentTrip);
            Set<ServiceDate> serviceDates = this.routingService.getCalendarService().getServiceDatesForServiceId(currentTrip.getServiceId());
            if (!serviceDates.contains(realTimeReportedServiceDate)) continue;
            StopLocation firstStop = tripPattern.getStop(0);
            StopLocation lastStop = tripPattern.lastStop();
            String siriOriginRef = monitoredVehicleJourney.getOriginRef().getValue();
            if (monitoredVehicleJourney.getDestinationRef() != null) {
                String siriDestinationRef = monitoredVehicleJourney.getDestinationRef().getValue();
                boolean firstStopIsMatch = firstStop.getId().getId().equals(siriOriginRef);
                boolean lastStopIsMatch = lastStop.getId().getId().equals(siriDestinationRef);
                if (!firstStopIsMatch && firstStop.isPartOfStation()) {
                    StopLocation otherFirstStop = this.routingService.getStopForId(new FeedScopedId(firstStop.getId().getFeedId(), siriOriginRef));
                    firstStopIsMatch = firstStop.isPartOfSameStationAs(otherFirstStop);
                }
                if (!lastStopIsMatch && lastStop.isPartOfStation()) {
                    StopLocation otherLastStop = this.routingService.getStopForId(new FeedScopedId(lastStop.getId().getFeedId(), siriDestinationRef));
                    lastStopIsMatch = lastStop.isPartOfSameStationAs(otherLastStop);
                }
                if (!(firstStopIsMatch & lastStopIsMatch)) continue;
                TripPattern lastAddedTripPattern = this.buffer.getLastAddedTripPattern(currentTrip.getId(), realTimeReportedServiceDate);
                if (lastAddedTripPattern != null) {
                    patterns.add(lastAddedTripPattern);
                    continue;
                }
                patterns.add(tripPattern);
                continue;
            }
            if (!firstStop.getId().getId().equals(siriOriginRef)) continue;
            tripPattern.getScheduledTimetable().getTripTimes().get(0).getDepartureTime(0);
            patterns.add(tripPattern);
        }
        return patterns;
    }

    private Set<TripPattern> getPatternForTrip(Set<Trip> trips, EstimatedVehicleJourney journey) {
        HashSet<TripPattern> patterns = new HashSet<TripPattern>();
        for (Trip trip : trips) {
            TripPattern pattern = this.getPatternForTrip(trip, journey);
            if (pattern == null) continue;
            patterns.add(pattern);
        }
        return patterns;
    }

    private TripPattern getPatternForTrip(Trip trip, EstimatedVehicleJourney journey) {
        String journeyLastStopId;
        EstimatedCall estimatedCall;
        ServiceDate journeyDate;
        String journeyFirstStopId;
        RecordedCall recordedCall;
        List recordedCalls;
        Set<ServiceDate> serviceDates = this.routingService.getCalendarService().getServiceDatesForServiceId(trip.getServiceId());
        List list = recordedCalls = journey.getRecordedCalls() != null ? journey.getRecordedCalls().getRecordedCalls() : new ArrayList();
        if (journey.getEstimatedCalls() == null) {
            return null;
        }
        List estimatedCalls = journey.getEstimatedCalls().getEstimatedCalls();
        if (recordedCalls != null && !recordedCalls.isEmpty()) {
            recordedCall = (RecordedCall)recordedCalls.get(0);
            journeyFirstStopId = recordedCall.getStopPointRef().getValue();
            journeyDate = new ServiceDate(Date.from(recordedCall.getAimedDepartureTime().toInstant()));
        } else if (estimatedCalls != null && !estimatedCalls.isEmpty()) {
            estimatedCall = (EstimatedCall)estimatedCalls.get(0);
            journeyFirstStopId = estimatedCall.getStopPointRef().getValue();
            journeyDate = new ServiceDate(Date.from(estimatedCall.getAimedDepartureTime().toInstant()));
        } else {
            return null;
        }
        if (estimatedCalls != null && !estimatedCalls.isEmpty()) {
            estimatedCall = (EstimatedCall)estimatedCalls.get(estimatedCalls.size() - 1);
            journeyLastStopId = estimatedCall.getStopPointRef().getValue();
        } else if (recordedCalls != null && !recordedCalls.isEmpty()) {
            recordedCall = (RecordedCall)recordedCalls.get(recordedCalls.size() - 1);
            journeyLastStopId = recordedCall.getStopPointRef().getValue();
        } else {
            return null;
        }
        TripPattern lastAddedTripPattern = null;
        if (this.getTimetableSnapshot() != null) {
            lastAddedTripPattern = this.getTimetableSnapshot().getLastAddedTripPattern(trip.getId(), journeyDate);
        }
        TripPattern tripPattern = lastAddedTripPattern != null ? lastAddedTripPattern : this.routingService.getPatternForTrip().get(trip);
        StopLocation firstStop = tripPattern.firstStop();
        StopLocation lastStop = tripPattern.lastStop();
        if (serviceDates.contains(journeyDate)) {
            boolean firstStopIsMatch = firstStop.getId().getId().equals(journeyFirstStopId);
            boolean lastStopIsMatch = lastStop.getId().getId().equals(journeyLastStopId);
            if (!firstStopIsMatch && firstStop.isPartOfStation()) {
                StopLocation otherFirstStop = this.routingService.getStopForId(new FeedScopedId(firstStop.getId().getFeedId(), journeyFirstStopId));
                firstStopIsMatch = firstStop.isPartOfSameStationAs(otherFirstStop);
            }
            if (!lastStopIsMatch && lastStop.isPartOfStation()) {
                StopLocation otherLastStop = this.routingService.getStopForId(new FeedScopedId(lastStop.getId().getFeedId(), journeyLastStopId));
                lastStopIsMatch = lastStop.isPartOfSameStationAs(otherLastStop);
            }
            if (firstStopIsMatch & lastStopIsMatch) {
                return tripPattern;
            }
            return null;
        }
        return null;
    }

    private Trip getTripForJourney(Set<Trip> trips, VehicleActivityStructure.MonitoredVehicleJourney monitoredVehicleJourney) {
        ZonedDateTime date = monitoredVehicleJourney.getOriginAimedDepartureTime();
        if (date == null) {
            date = ZonedDateTime.now();
        }
        ServiceDate serviceDate = new ServiceDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
        ArrayList<Trip> results = new ArrayList<Trip>();
        for (Trip trip : trips) {
            Set<ServiceDate> serviceDatesForServiceId = this.routingService.getCalendarService().getServiceDatesForServiceId(trip.getServiceId());
            for (ServiceDate next : serviceDatesForServiceId) {
                if (!next.equals(serviceDate)) continue;
                results.add(trip);
            }
        }
        if (results.size() == 1) {
            return (Trip)results.get(0);
        }
        if (results.size() > 1) {
            if (monitoredVehicleJourney.getLineRef() != null && monitoredVehicleJourney.getLineRef().getValue() != null) {
                String lineRef = monitoredVehicleJourney.getLineRef().getValue();
                for (Trip trip : results) {
                    if (!lineRef.equals(trip.getRoute().getId().getId())) continue;
                    return trip;
                }
            }
            return (Trip)results.get(0);
        }
        return null;
    }

    private Set<Trip> getTripForJourney(Set<Trip> trips, EstimatedVehicleJourney journey) {
        String firstStopId;
        ZonedDateTime date;
        List recordedCalls = journey.getRecordedCalls() != null ? journey.getRecordedCalls().getRecordedCalls() : new ArrayList();
        List estimatedCalls = journey.getEstimatedCalls() != null ? journey.getEstimatedCalls().getEstimatedCalls() : null;
        int stopNumber = 1;
        if (recordedCalls != null && !recordedCalls.isEmpty()) {
            RecordedCall recordedCall = (RecordedCall)recordedCalls.get(0);
            date = recordedCall.getAimedDepartureTime();
            firstStopId = recordedCall.getStopPointRef().getValue();
        } else if (estimatedCalls != null && !estimatedCalls.isEmpty()) {
            EstimatedCall estimatedCall = (EstimatedCall)estimatedCalls.get(0);
            if (estimatedCall.getOrder() != null) {
                stopNumber = estimatedCall.getOrder().intValue();
            } else if (estimatedCall.getVisitNumber() != null) {
                stopNumber = estimatedCall.getVisitNumber().intValue();
            }
            firstStopId = estimatedCall.getStopPointRef().getValue();
            date = estimatedCall.getAimedDepartureTime();
        } else {
            return null;
        }
        if (date == null) {
            date = ZonedDateTime.now();
        }
        ServiceDate serviceDate = new ServiceDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
        int departureInSecondsSinceMidnight = this.calculateSecondsSinceMidnight(date);
        HashSet<Trip> result = new HashSet<Trip>();
        for (Trip trip : trips) {
            TripPattern pattern;
            Set<ServiceDate> serviceDatesForServiceId = this.routingService.getCalendarService().getServiceDatesForServiceId(trip.getServiceId());
            if (!serviceDatesForServiceId.contains(serviceDate) || stopNumber >= (pattern = this.routingService.getPatternForTrip().get(trip)).numberOfStops()) continue;
            boolean firstReportedStopIsFound = false;
            StopLocation stop = pattern.getStop(stopNumber - 1);
            if (firstStopId.equals(stop.getId().getId())) {
                firstReportedStopIsFound = true;
            } else {
                StopLocation alternativeStop;
                String agencyId = stop.getId().getFeedId();
                if (stop.isPartOfStation() && (alternativeStop = this.routingService.getStopForId(new FeedScopedId(agencyId, firstStopId))) != null && stop.isPartOfSameStationAs(alternativeStop)) {
                    firstReportedStopIsFound = true;
                }
            }
            if (!firstReportedStopIsFound) continue;
            for (TripTimes times : this.getCurrentTimetable(pattern, serviceDate).getTripTimes()) {
                if (times.getScheduledDepartureTime(stopNumber - 1) != departureInSecondsSinceMidnight || !this.routingService.getCalendarService().getServiceDatesForServiceId(times.getTrip().getServiceId()).contains(serviceDate)) continue;
                result.add(times.getTrip());
            }
        }
        if (result.size() >= 1) {
            return result;
        }
        return null;
    }

    private Route getRouteForRouteId(String feedId, String routeId) {
        return this.routingService.getRouteForId(new FeedScopedId(feedId, routeId));
    }

    private Trip getTripForTripId(String feedId, String tripId) {
        return this.routingService.getTripForId().get(new FeedScopedId(feedId, tripId));
    }

    private StopLocation getStopForStopId(String feedId, String stopId) {
        return this.routingService.getStopForId(new FeedScopedId(feedId, stopId));
    }
}

