/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.TransitEntity;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.DateMapper;
import org.opentripplanner.routing.trippattern.TripTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.EstimatedCall;
import uk.org.siri.siri20.EstimatedVehicleJourney;
import uk.org.siri.siri20.RecordedCall;
import uk.org.siri.siri20.VehicleActivityStructure;
import uk.org.siri.siri20.VehicleModesEnumeration;

public class SiriFuzzyTripMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(SiriFuzzyTripMatcher.class);
    private RoutingService routingService;
    private static Map<String, Set<Trip>> mappedTripsCache = new HashMap<String, Set<Trip>>();
    private static Map<String, Set<Trip>> mappedVehicleRefCache = new HashMap<String, Set<Trip>>();
    private static Map<String, Set<Route>> mappedRoutesCache = new HashMap<String, Set<Route>>();
    private static Map<String, Set<Trip>> start_stop_tripCache = new HashMap<String, Set<Trip>>();
    private static Map<String, Trip> vehicleJourneyTripCache = new HashMap<String, Trip>();
    private static Set<String> nonExistingStops = new HashSet<String>();

    public SiriFuzzyTripMatcher(RoutingService routingService) {
        this.routingService = routingService;
        SiriFuzzyTripMatcher.initCache(this.routingService);
    }

    public Set<Trip> match(VehicleActivityStructure activity) {
        VehicleActivityStructure.MonitoredVehicleJourney monitoredVehicleJourney = activity.getMonitoredVehicleJourney();
        Set<Trip> trips = new HashSet<Trip>();
        if (monitoredVehicleJourney != null) {
            String datedVehicleRef = null;
            if (monitoredVehicleJourney.getFramedVehicleJourneyRef() != null && (datedVehicleRef = monitoredVehicleJourney.getFramedVehicleJourneyRef().getDatedVehicleJourneyRef()) != null) {
                trips = mappedTripsCache.get(datedVehicleRef);
            }
            if (monitoredVehicleJourney.getDestinationRef() != null) {
                String destinationRef = monitoredVehicleJourney.getDestinationRef().getValue();
                ZonedDateTime arrivalTime = monitoredVehicleJourney.getDestinationAimedArrivalTime();
                if (arrivalTime != null) {
                    trips = this.getMatchingTripsOnStopOrSiblings(destinationRef, arrivalTime);
                }
            }
        }
        return trips;
    }

    Trip findTripByDatedVehicleJourneyRef(EstimatedVehicleJourney journey) {
        String serviceJourneyId = this.resolveDatedVehicleJourneyRef(journey);
        if (serviceJourneyId != null) {
            for (String feedId : this.routingService.getFeedIds()) {
                Trip trip = this.routingService.getTripForId().get(new FeedScopedId(feedId, serviceJourneyId));
                if (trip == null) continue;
                return trip;
            }
        }
        return null;
    }

    private String resolveDatedVehicleJourneyRef(EstimatedVehicleJourney journey) {
        if (journey.getFramedVehicleJourneyRef() != null) {
            return journey.getFramedVehicleJourneyRef().getDatedVehicleJourneyRef();
        }
        if (journey.getDatedVehicleJourneyRef() != null) {
            return journey.getDatedVehicleJourneyRef().getValue();
        }
        return null;
    }

    public Set<Trip> match(EstimatedVehicleJourney journey) {
        String serviceJourneyId;
        Set<Trip> trips = null;
        if (journey.getVehicleRef() != null && journey.getVehicleModes() != null && journey.getVehicleModes().contains(VehicleModesEnumeration.RAIL)) {
            trips = this.getCachedTripsByVehicleRef(journey.getVehicleRef().getValue());
        }
        if ((trips == null || trips.isEmpty()) && (serviceJourneyId = this.resolveDatedVehicleJourneyRef(journey)) != null) {
            trips = this.getCachedTripsBySiriId(serviceJourneyId);
        }
        if (trips == null || trips.isEmpty()) {
            String lastStopPoint = null;
            ZonedDateTime arrivalTime = null;
            if (journey.getEstimatedCalls() != null && journey.getEstimatedCalls().getEstimatedCalls() != null && !journey.getEstimatedCalls().getEstimatedCalls().isEmpty()) {
                List estimatedCalls = journey.getEstimatedCalls().getEstimatedCalls();
                EstimatedCall lastStop = (EstimatedCall)estimatedCalls.get(estimatedCalls.size() - 1);
                lastStopPoint = lastStop.getStopPointRef().getValue();
                arrivalTime = lastStop.getAimedArrivalTime() != null ? lastStop.getAimedArrivalTime() : lastStop.getAimedDepartureTime();
            } else if (journey.getRecordedCalls() != null && journey.getRecordedCalls().getRecordedCalls() != null && !journey.getRecordedCalls().getRecordedCalls().isEmpty()) {
                List recordedCalls = journey.getRecordedCalls().getRecordedCalls();
                RecordedCall lastStop = (RecordedCall)recordedCalls.get(recordedCalls.size() - 1);
                lastStopPoint = lastStop.getStopPointRef().getValue();
                ZonedDateTime zonedDateTime = arrivalTime = lastStop.getAimedArrivalTime() != null ? lastStop.getAimedArrivalTime() : lastStop.getAimedDepartureTime();
            }
            if (arrivalTime != null) {
                trips = this.getMatchingTripsOnStopOrSiblings(lastStopPoint, arrivalTime);
            }
        }
        return trips;
    }

    private Set<Trip> getMatchingTripsOnStopOrSiblings(String lastStopPoint, ZonedDateTime arrivalTime) {
        String feedId;
        StopLocation stop;
        int secondsSinceMidnight = DateMapper.secondsSinceStartOfService(arrivalTime, arrivalTime, this.routingService.getTimeZone().toZoneId());
        int secondsSinceMidnightYesterday = DateMapper.secondsSinceStartOfService(arrivalTime.minusDays(1L), arrivalTime, this.routingService.getTimeZone().toZoneId());
        Set<Trip> trips = start_stop_tripCache.get(SiriFuzzyTripMatcher.createStartStopKey(lastStopPoint, secondsSinceMidnight));
        if (trips == null) {
            trips = start_stop_tripCache.get(SiriFuzzyTripMatcher.createStartStopKey(lastStopPoint, secondsSinceMidnightYesterday));
        }
        if ((trips == null || trips.isEmpty()) && (stop = this.routingService.getStopForId(new FeedScopedId(feedId = this.routingService.getFeedIds().iterator().next(), lastStopPoint))) != null && stop.isPartOfStation()) {
            Collection<StopLocation> allQuays = stop.getParentStation().getChildStops();
            for (StopLocation quay : allQuays) {
                Set<Trip> tripSet = start_stop_tripCache.get(SiriFuzzyTripMatcher.createStartStopKey(quay.getId().getId(), secondsSinceMidnight));
                if (tripSet == null) continue;
                if (trips == null) {
                    trips = tripSet;
                    continue;
                }
                trips.addAll(tripSet);
            }
        }
        return trips;
    }

    private Set<Trip> getCachedTripsByVehicleRef(String vehicleRef) {
        if (vehicleRef == null) {
            return null;
        }
        return mappedVehicleRefCache.getOrDefault(vehicleRef, new HashSet());
    }

    private Set<Trip> getCachedTripsBySiriId(String tripId) {
        if (tripId == null) {
            return null;
        }
        return mappedTripsCache.getOrDefault(tripId, new HashSet());
    }

    private static void initCache(RoutingService index) {
        if (mappedTripsCache.isEmpty()) {
            HashSet<TransitEntity> initialSet;
            Set<Trip> trips = index.getPatternForTrip().keySet();
            for (Trip trip2 : trips) {
                TripPattern tripPattern = index.getPatternForTrip().get(trip2);
                String currentTripId = SiriFuzzyTripMatcher.getUnpaddedTripId(trip2.getId().getId());
                if (mappedTripsCache.containsKey(currentTripId)) {
                    mappedTripsCache.get(currentTripId).add(trip2);
                } else {
                    initialSet = new HashSet<TransitEntity>();
                    initialSet.add(trip2);
                    mappedTripsCache.put(currentTripId, initialSet);
                }
                if (tripPattern != null && tripPattern.matchesModeOrSubMode(TransitMode.RAIL, "railReplacementBus") && trip2.getInternalPlanningCode() != null) {
                    String internalPlanningCode = trip2.getInternalPlanningCode();
                    if (mappedVehicleRefCache.containsKey(internalPlanningCode)) {
                        mappedVehicleRefCache.get(internalPlanningCode).add(trip2);
                    } else {
                        HashSet<Trip> initialSet2 = new HashSet<Trip>();
                        initialSet2.add(trip2);
                        mappedVehicleRefCache.put(internalPlanningCode, initialSet2);
                    }
                }
                String lastStopId = tripPattern.lastStop().getId().getId();
                TripTimes tripTimes = tripPattern.getScheduledTimetable().getTripTimes(trip2);
                if (tripTimes == null) continue;
                int arrivalTime = tripTimes.getArrivalTime(tripTimes.getNumStops() - 1);
                String key = SiriFuzzyTripMatcher.createStartStopKey(lastStopId, arrivalTime);
                if (start_stop_tripCache.containsKey(key)) {
                    start_stop_tripCache.get(key).add(trip2);
                    continue;
                }
                HashSet<Trip> initialSet3 = new HashSet<Trip>();
                initialSet3.add(trip2);
                start_stop_tripCache.put(key, initialSet3);
            }
            Set routes = index.getPatternsForRoute().keySet();
            for (Route route : routes) {
                String currentRouteId = SiriFuzzyTripMatcher.getUnpaddedTripId(route.getId().getId());
                if (mappedRoutesCache.containsKey(currentRouteId)) {
                    mappedRoutesCache.get(currentRouteId).add(route);
                    continue;
                }
                initialSet = new HashSet();
                initialSet.add(route);
                mappedRoutesCache.put(currentRouteId, initialSet);
            }
            LOG.info("Built route-cache [{}].", (Object)mappedRoutesCache.size());
            LOG.info("Built vehicleRef-cache [{}].", (Object)mappedVehicleRefCache.size());
            LOG.info("Built trips-cache [{}].", (Object)mappedTripsCache.size());
            LOG.info("Built start-stop-cache [{}].", (Object)start_stop_tripCache.size());
        }
        if (vehicleJourneyTripCache.isEmpty()) {
            index.getTripForId().values().forEach(trip -> vehicleJourneyTripCache.put(trip.getId().getId(), (Trip)trip));
        }
    }

    private static String createStartStopKey(String lastStopId, int lastStopArrivalTime) {
        return lastStopId + ":" + lastStopArrivalTime;
    }

    private static String getUnpaddedTripId(String id) {
        if (id.indexOf("-") > 0) {
            return id.substring(0, id.indexOf("-"));
        }
        return id;
    }

    public Set<Route> getRoutesForStop(FeedScopedId siriStopId) {
        StopLocation stop = this.routingService.getStopForId(siriStopId);
        return this.routingService.getRoutesForStop(stop);
    }

    public FeedScopedId getStop(String siriStopId) {
        if (nonExistingStops.contains(siriStopId)) {
            return null;
        }
        StopLocation firstStop = this.routingService.getAllStops().stream().findFirst().get();
        FeedScopedId id = new FeedScopedId(firstStop.getId().getFeedId(), siriStopId);
        if (this.routingService.getStopForId(id) != null) {
            return id;
        }
        if (this.routingService.getStationById(id) != null) {
            return id;
        }
        Collection<StopLocation> stops = this.routingService.getAllStops();
        for (StopLocation stop : stops) {
            if (!stop.getId().getId().equals(siriStopId)) continue;
            return stop.getId();
        }
        for (Station station : this.routingService.getStations()) {
            if (!station.getId().getId().equals(siriStopId)) continue;
            return station.getId();
        }
        nonExistingStops.add(siriStopId);
        return null;
    }

    public Set<Route> getRoutes(String lineRefValue) {
        return mappedRoutesCache.getOrDefault(lineRefValue, new HashSet());
    }

    public FeedScopedId getTripId(String vehicleJourney) {
        Trip trip = vehicleJourneyTripCache.get(vehicleJourney);
        if (trip != null) {
            return trip.getId();
        }
        for (String feedId : this.routingService.getFeedIds()) {
            trip = this.routingService.getTripForId().get(new FeedScopedId(feedId, vehicleJourney));
            if (trip == null) continue;
            vehicleJourneyTripCache.put(vehicleJourney, trip);
            return trip.getId();
        }
        return null;
    }

    public int getTripDepartureTime(FeedScopedId tripId) {
        TripTimes tripTimes;
        Trip trip = this.routingService.getTripForId().get(tripId);
        TripPattern tripPattern = this.routingService.getPatternForTrip().get(trip);
        if (tripPattern != null && (tripTimes = tripPattern.getScheduledTimetable().getTripTimes(trip)) != null) {
            return tripTimes.getArrivalTime(0);
        }
        return -1;
    }

    public int getTripArrivalTime(FeedScopedId tripId) {
        TripTimes tripTimes;
        Trip trip = this.routingService.getTripForId().get(tripId);
        TripPattern tripPattern = this.routingService.getPatternForTrip().get(trip);
        if (tripPattern != null && (tripTimes = tripPattern.getScheduledTimetable().getTripTimes(trip)) != null) {
            return tripTimes.getArrivalTime(tripTimes.getNumStops() - 1);
        }
        return -1;
    }

    public List<FeedScopedId> getTripIdForInternalPlanningCodeServiceDateAndMode(String internalPlanningCode, ServiceDate serviceDate, TransitMode mode, String transportSubmode) {
        Set<Trip> cachedTripsBySiriId = this.getCachedTripsBySiriId(internalPlanningCode);
        if (cachedTripsBySiriId.isEmpty()) {
            cachedTripsBySiriId = this.getCachedTripsByVehicleRef(internalPlanningCode);
        }
        ArrayList<FeedScopedId> matches = new ArrayList<FeedScopedId>();
        for (Trip trip : cachedTripsBySiriId) {
            Set<ServiceDate> serviceDates;
            TripPattern tripPattern = this.routingService.getPatternForTrip().get(trip);
            if (!tripPattern.matchesModeOrSubMode(mode, transportSubmode) || !(serviceDates = this.routingService.getCalendarService().getServiceDatesForServiceId(trip.getServiceId())).contains(serviceDate) || trip.getInternalPlanningCode() == null || !trip.getInternalPlanningCode().equals(internalPlanningCode)) continue;
            matches.add(trip.getId());
        }
        return matches;
    }
}

