/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opentripplanner.ext.siri.SiriFuzzyTripMatcher;
import org.opentripplanner.ext.siri.SiriSeverityMapper;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.routing.alertpatch.AlertUrl;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.StopCondition;
import org.opentripplanner.routing.alertpatch.TimePeriod;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.DateMapper;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.util.I18NString;
import org.opentripplanner.util.NonLocalizedString;
import org.opentripplanner.util.TranslatedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.ifopt.siri20.StopPlaceRef;
import uk.org.siri.siri20.AffectedLineStructure;
import uk.org.siri.siri20.AffectedOperatorStructure;
import uk.org.siri.siri20.AffectedStopPointStructure;
import uk.org.siri.siri20.AffectedVehicleJourneyStructure;
import uk.org.siri.siri20.AffectsScopeStructure;
import uk.org.siri.siri20.DataFrameRefStructure;
import uk.org.siri.siri20.DefaultedTextStructure;
import uk.org.siri.siri20.FramedVehicleJourneyRefStructure;
import uk.org.siri.siri20.HalfOpenTimestampOutputRangeStructure;
import uk.org.siri.siri20.InfoLinkStructure;
import uk.org.siri.siri20.LineRef;
import uk.org.siri.siri20.NaturalLanguageStringStructure;
import uk.org.siri.siri20.NetworkRefStructure;
import uk.org.siri.siri20.OperatorRefStructure;
import uk.org.siri.siri20.PtSituationElement;
import uk.org.siri.siri20.RoutePointTypeEnumeration;
import uk.org.siri.siri20.ServiceDelivery;
import uk.org.siri.siri20.SituationExchangeDeliveryStructure;
import uk.org.siri.siri20.StopPointRef;
import uk.org.siri.siri20.VehicleJourneyRef;
import uk.org.siri.siri20.WorkflowStatusEnumeration;

public class SiriAlertsUpdateHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SiriAlertsUpdateHandler.class);
    private TransitAlertService transitAlertService;
    private long earlyStart;
    private SiriFuzzyTripMatcher siriFuzzyTripMatcher;
    private final String feedId;
    private final Graph graph;
    private final Set<TransitAlert> alerts = new HashSet<TransitAlert>();

    public SiriAlertsUpdateHandler(String feedId, Graph graph) {
        this.feedId = feedId;
        this.graph = graph;
    }

    public void update(ServiceDelivery delivery) {
        for (SituationExchangeDeliveryStructure sxDelivery : delivery.getSituationExchangeDeliveries()) {
            SituationExchangeDeliveryStructure.Situations situations = sxDelivery.getSituations();
            if (situations == null) continue;
            long t1 = System.currentTimeMillis();
            int addedCounter = 0;
            int expiredCounter = 0;
            for (PtSituationElement sxElement : situations.getPtSituationElements()) {
                boolean expireSituation = sxElement.getProgress() != null && sxElement.getProgress().equals((Object)WorkflowStatusEnumeration.CLOSED);
                String situationNumber = sxElement.getSituationNumber() != null ? sxElement.getSituationNumber().getValue() : null;
                if (expireSituation) {
                    this.alerts.removeIf(transitAlert -> transitAlert.getId().equals(situationNumber));
                    ++expiredCounter;
                    continue;
                }
                TransitAlert alert = this.handleAlert(sxElement);
                ++addedCounter;
                if (alert == null) continue;
                alert.setId(situationNumber);
                if (alert.getEntities().isEmpty()) {
                    LOG.info("No match found for Alert - setting Unknown entity for situation with situationNumber {}", (Object)situationNumber);
                    alert.addEntity(new EntitySelector.Unknown("Alert had no entities that could be handled"));
                }
                this.alerts.removeIf(transitAlert -> transitAlert.getId().equals(situationNumber));
                this.alerts.add(alert);
            }
            this.transitAlertService.setAlerts(this.alerts);
            LOG.info("Added {} alerts, expired {} alerts based on {} situations, current alert-count: {}, elapsed time {}ms", new Object[]{addedCounter, expiredCounter, situations.getPtSituationElements().size(), this.transitAlertService.getAllAlerts().size(), System.currentTimeMillis() - t1});
        }
    }

    private TransitAlert handleAlert(PtSituationElement situation) {
        AffectsScopeStructure affectsStructure;
        TransitAlert alert = this.createAlertWithTexts(situation);
        if (!(alert.alertHeaderText != null && !alert.alertHeaderText.toString().isEmpty() || alert.alertDescriptionText != null && !alert.alertDescriptionText.toString().isEmpty() || alert.alertDetailText != null && !alert.alertDetailText.toString().isEmpty())) {
            LOG.debug("Empty Alert - ignoring situationNumber: {}", situation.getSituationNumber() != null ? situation.getSituationNumber().getValue() : null);
            return null;
        }
        ArrayList<TimePeriod> periods = new ArrayList<TimePeriod>();
        if (situation.getValidityPeriods().size() > 0) {
            for (HalfOpenTimestampOutputRangeStructure activePeriod : situation.getValidityPeriods()) {
                long realStart = activePeriod.getStartTime() != null ? this.getEpochSecond(activePeriod.getStartTime()) : 0L;
                long start = activePeriod.getStartTime() != null ? realStart - this.earlyStart : 0L;
                long realEnd = activePeriod.getEndTime() != null ? this.getEpochSecond(activePeriod.getEndTime()) : Long.MAX_VALUE;
                long end = activePeriod.getEndTime() != null ? realEnd : Long.MAX_VALUE;
                periods.add(new TimePeriod(start, end));
            }
        } else {
            periods.add(new TimePeriod(0L, Long.MAX_VALUE));
        }
        alert.setTimePeriods(periods);
        if (situation.getPriority() != null) {
            alert.priority = situation.getPriority().intValue();
        }
        if ((affectsStructure = situation.getAffects()) != null) {
            AffectsScopeStructure.VehicleJourneys vjs;
            AffectsScopeStructure.Networks networks;
            FeedScopedId stopId;
            AffectsScopeStructure.Operators operators = affectsStructure.getOperators();
            if (operators != null && this.isNotEmpty(operators.getAffectedOperators())) {
                for (AffectedOperatorStructure affectedOperator : operators.getAffectedOperators()) {
                    OperatorRefStructure operatorRef = affectedOperator.getOperatorRef();
                    if (operatorRef == null || operatorRef.getValue() == null) continue;
                    String agencyId = operatorRef.getValue();
                    alert.addEntity(new EntitySelector.Agency(new FeedScopedId(this.feedId, agencyId)));
                }
            }
            AffectsScopeStructure.StopPoints stopPoints = affectsStructure.getStopPoints();
            AffectsScopeStructure.StopPlaces stopPlaces = affectsStructure.getStopPlaces();
            if (stopPoints != null && this.isNotEmpty(stopPoints.getAffectedStopPoints())) {
                for (Object stopPoint : stopPoints.getAffectedStopPoints()) {
                    StopPointRef stopPointRef = stopPoint.getStopPointRef();
                    if (stopPointRef == null || stopPointRef.getValue() == null) continue;
                    stopId = this.siriFuzzyTripMatcher.getStop(stopPointRef.getValue());
                    if (stopId == null) {
                        stopId = new FeedScopedId(this.feedId, stopPointRef.getValue());
                    }
                    alert.addEntity(new EntitySelector.Stop(stopId));
                    this.updateStopConditions(alert, stopPoint.getStopConditions());
                }
            } else if (stopPlaces != null && this.isNotEmpty(stopPlaces.getAffectedStopPlaces())) {
                for (Object stopPoint : stopPlaces.getAffectedStopPlaces()) {
                    StopPlaceRef stopPlace = stopPoint.getStopPlaceRef();
                    if (stopPlace == null || stopPlace.getValue() == null) continue;
                    stopId = this.siriFuzzyTripMatcher.getStop(stopPlace.getValue());
                    if (stopId == null) {
                        stopId = new FeedScopedId(this.feedId, stopPlace.getValue());
                    }
                    alert.addEntity(new EntitySelector.Stop(stopId));
                }
            }
            if ((networks = affectsStructure.getNetworks()) != null && this.isNotEmpty(networks.getAffectedNetworks())) {
                for (AffectsScopeStructure.Networks.AffectedNetwork affectedNetwork : networks.getAffectedNetworks()) {
                    Object line2;
                    List affectedLines = affectedNetwork.getAffectedLines();
                    if (this.isNotEmpty(affectedLines)) {
                        for (Object line2 : affectedLines) {
                            LineRef lineRef = line2.getLineRef();
                            if (lineRef == null || lineRef.getValue() == null) continue;
                            ArrayList affectedStops = new ArrayList();
                            AffectedLineStructure.Routes routes = line2.getRoutes();
                            if (routes != null) {
                                for (Object route : routes.getAffectedRoutes()) {
                                    if (route.getStopPoints() == null) continue;
                                    List stopPointsList = route.getStopPoints().getAffectedStopPointsAndLinkProjectionToNextStopPoints();
                                    for (Serializable serializable : stopPointsList) {
                                        if (!(serializable instanceof AffectedStopPointStructure)) continue;
                                        AffectedStopPointStructure stopPointStructure = (AffectedStopPointStructure)serializable;
                                        affectedStops.add(stopPointStructure);
                                    }
                                }
                            }
                            FeedScopedId affectedRoute = new FeedScopedId(this.feedId, lineRef.getValue());
                            if (!affectedStops.isEmpty()) {
                                Object route;
                                route = affectedStops.iterator();
                                while (route.hasNext()) {
                                    AffectedStopPointStructure affectedStop = (AffectedStopPointStructure)route.next();
                                    FeedScopedId stop = this.siriFuzzyTripMatcher.getStop(affectedStop.getStopPointRef().getValue());
                                    if (stop == null) {
                                        stop = new FeedScopedId(this.feedId, affectedStop.getStopPointRef().getValue());
                                    }
                                    alert.addEntity(new EntitySelector.StopAndRoute(stop, affectedRoute));
                                    this.updateStopConditions(alert, affectedStop.getStopConditions());
                                }
                                continue;
                            }
                            alert.addEntity(new EntitySelector.Route(affectedRoute));
                        }
                        continue;
                    }
                    NetworkRefStructure networkRef = affectedNetwork.getNetworkRef();
                    if (networkRef == null || networkRef.getValue() == null) continue;
                    line2 = networkRef.getValue();
                }
            }
            if ((vjs = affectsStructure.getVehicleJourneys()) != null && this.isNotEmpty(vjs.getAffectedVehicleJourneies())) {
                for (AffectedVehicleJourneyStructure affectedVehicleJourney : vjs.getAffectedVehicleJourneies()) {
                    Set<Route> affectedRoutes;
                    FramedVehicleJourneyRefStructure framedVehicleJourneyRef;
                    ZonedDateTime startOfService;
                    List vehicleJourneyReves;
                    String lineRef = null;
                    if (affectedVehicleJourney.getLineRef() != null) {
                        lineRef = affectedVehicleJourney.getLineRef().getValue();
                    }
                    ArrayList<AffectedStopPointStructure> affectedStops = new ArrayList<AffectedStopPointStructure>();
                    List routes = affectedVehicleJourney.getRoutes();
                    if (routes != null) {
                        for (Object route : routes) {
                            if (route.getStopPoints() == null) continue;
                            List stopPointsList = route.getStopPoints().getAffectedStopPointsAndLinkProjectionToNextStopPoints();
                            for (Serializable serializable : stopPointsList) {
                                if (!(serializable instanceof AffectedStopPointStructure)) continue;
                                AffectedStopPointStructure stopPointStructure = (AffectedStopPointStructure)serializable;
                                affectedStops.add(stopPointStructure);
                            }
                        }
                    }
                    if (this.isNotEmpty(vehicleJourneyReves = affectedVehicleJourney.getVehicleJourneyReves())) {
                        Object route;
                        route = vehicleJourneyReves.iterator();
                        while (route.hasNext()) {
                            VehicleJourneyRef vehicleJourneyRef = (VehicleJourneyRef)route.next();
                            List<FeedScopedId> tripIds = new ArrayList<FeedScopedId>();
                            FeedScopedId tripIdFromVehicleJourney = this.siriFuzzyTripMatcher.getTripId(vehicleJourneyRef.getValue());
                            ZonedDateTime originAimedDepartureTime = affectedVehicleJourney.getOriginAimedDepartureTime() != null ? affectedVehicleJourney.getOriginAimedDepartureTime() : ZonedDateTime.now();
                            startOfService = DateMapper.asStartOfService(originAimedDepartureTime);
                            ServiceDate serviceDate = new ServiceDate(startOfService.toLocalDate());
                            if (tripIdFromVehicleJourney != null) {
                                tripIds.add(tripIdFromVehicleJourney);
                            } else {
                                tripIds = this.siriFuzzyTripMatcher.getTripIdForInternalPlanningCodeServiceDateAndMode(vehicleJourneyRef.getValue(), serviceDate, TransitMode.RAIL, "railReplacementBus");
                            }
                            for (FeedScopedId tripId : tripIds) {
                                if (!affectedStops.isEmpty()) {
                                    for (AffectedStopPointStructure affectedStop : affectedStops) {
                                        FeedScopedId stop = this.siriFuzzyTripMatcher.getStop(affectedStop.getStopPointRef().getValue());
                                        if (stop == null) {
                                            stop = new FeedScopedId(this.feedId, affectedStop.getStopPointRef().getValue());
                                        }
                                        alert.addEntity(new EntitySelector.StopAndTrip(stop, tripId, serviceDate));
                                        this.updateStopConditions(alert, affectedStop.getStopConditions());
                                    }
                                    continue;
                                }
                                alert.addEntity(new EntitySelector.Trip(tripId, serviceDate));
                            }
                        }
                    }
                    if ((framedVehicleJourneyRef = affectedVehicleJourney.getFramedVehicleJourneyRef()) != null) {
                        DataFrameRefStructure dataFrameRef = framedVehicleJourneyRef.getDataFrameRef();
                        String datedVehicleJourneyRef = framedVehicleJourneyRef.getDatedVehicleJourneyRef();
                        FeedScopedId tripId = this.siriFuzzyTripMatcher.getTripId(datedVehicleJourneyRef);
                        if (tripId != null) {
                            ServiceDate serviceDate = null;
                            if (dataFrameRef != null && dataFrameRef.getValue() != null) {
                                startOfService = DateMapper.asStartOfService(LocalDate.parse(dataFrameRef.getValue()), this.graph.getTimeZone().toZoneId());
                                serviceDate = new ServiceDate(startOfService.getYear(), startOfService.getMonthValue(), startOfService.getDayOfMonth());
                            }
                            if (!affectedStops.isEmpty()) {
                                for (AffectedStopPointStructure affectedStop : affectedStops) {
                                    FeedScopedId stop = this.siriFuzzyTripMatcher.getStop(affectedStop.getStopPointRef().getValue());
                                    if (stop == null) {
                                        stop = new FeedScopedId(this.feedId, affectedStop.getStopPointRef().getValue());
                                    }
                                    alert.addEntity(new EntitySelector.StopAndTrip(stop, tripId, serviceDate));
                                }
                            } else {
                                alert.addEntity(new EntitySelector.Trip(tripId, serviceDate));
                            }
                        }
                    }
                    if (lineRef == null || (affectedRoutes = this.siriFuzzyTripMatcher.getRoutes(lineRef)) == null) continue;
                    for (Route route : affectedRoutes) {
                        alert.addEntity(new EntitySelector.Route(route.getId()));
                    }
                }
            }
        }
        if (alert.getStopConditions().isEmpty()) {
            this.updateStopConditions(alert, null);
        }
        alert.alertType = situation.getReportType();
        alert.severity = SiriSeverityMapper.getAlertSeverityForSiriSeverity(situation.getSeverity());
        if (situation.getParticipantRef() != null) {
            String codespace = situation.getParticipantRef().getValue();
            alert.setFeedId(codespace + ":Authority:" + codespace);
        }
        return alert;
    }

    private long getEpochSecond(ZonedDateTime startTime) {
        return startTime.toEpochSecond();
    }

    private TransitAlert createAlertWithTexts(PtSituationElement situation) {
        TransitAlert alert = new TransitAlert();
        alert.alertDescriptionText = this.getTranslatedString(situation.getDescriptions());
        alert.alertDetailText = this.getTranslatedString(situation.getDetails());
        alert.alertAdviceText = this.getTranslatedString(situation.getAdvices());
        alert.alertHeaderText = this.getTranslatedString(situation.getSummaries());
        alert.alertUrl = this.getInfoLinkAsString(situation.getInfoLinks());
        alert.setAlertUrlList(this.getInfoLinks(situation.getInfoLinks()));
        return alert;
    }

    private I18NString getInfoLinkAsString(PtSituationElement.InfoLinks infoLinks) {
        InfoLinkStructure infoLinkStructure;
        if (infoLinks != null && this.isNotEmpty(infoLinks.getInfoLinks()) && (infoLinkStructure = (InfoLinkStructure)infoLinks.getInfoLinks().get(0)) != null && infoLinkStructure.getUri() != null) {
            return new NonLocalizedString(infoLinkStructure.getUri());
        }
        return null;
    }

    private List<AlertUrl> getInfoLinks(PtSituationElement.InfoLinks infoLinks) {
        ArrayList<AlertUrl> alertUrls = new ArrayList<AlertUrl>();
        if (infoLinks != null && this.isNotEmpty(infoLinks.getInfoLinks())) {
            for (InfoLinkStructure infoLink : infoLinks.getInfoLinks()) {
                AlertUrl alertUrl = new AlertUrl();
                List labels = infoLink.getLabels();
                if (labels != null && !labels.isEmpty()) {
                    NaturalLanguageStringStructure label = (NaturalLanguageStringStructure)labels.get(0);
                    alertUrl.label = label.getValue();
                }
                alertUrl.uri = infoLink.getUri();
                alertUrls.add(alertUrl);
            }
        }
        return alertUrls;
    }

    private void updateStopConditions(TransitAlert alertPatch, List<RoutePointTypeEnumeration> stopConditions) {
        HashSet<StopCondition> alertStopConditions = new HashSet<StopCondition>();
        if (stopConditions != null) {
            for (RoutePointTypeEnumeration stopCondition : stopConditions) {
                switch (stopCondition) {
                    case EXCEPTIONAL_STOP: {
                        alertStopConditions.add(StopCondition.EXCEPTIONAL_STOP);
                        break;
                    }
                    case DESTINATION: {
                        alertStopConditions.add(StopCondition.DESTINATION);
                        break;
                    }
                    case NOT_STOPPING: {
                        alertStopConditions.add(StopCondition.NOT_STOPPING);
                        break;
                    }
                    case REQUEST_STOP: {
                        alertStopConditions.add(StopCondition.REQUEST_STOP);
                        break;
                    }
                    case START_POINT: {
                        alertStopConditions.add(StopCondition.START_POINT);
                    }
                }
            }
        }
        if (alertStopConditions.isEmpty()) {
            alertStopConditions.add(StopCondition.START_POINT);
            alertStopConditions.add(StopCondition.DESTINATION);
        }
        alertPatch.getStopConditions().addAll(alertStopConditions);
    }

    private boolean isNotEmpty(List<?> list) {
        return list != null && !list.isEmpty();
    }

    private I18NString getTranslatedString(List<DefaultedTextStructure> input) {
        HashMap<String, String> translations = new HashMap<String, String>();
        if (input != null && input.size() > 0) {
            for (DefaultedTextStructure textStructure : input) {
                String language = "";
                String value = "";
                if (textStructure.getLang() != null) {
                    language = textStructure.getLang();
                }
                if (textStructure.getValue() != null) {
                    value = textStructure.getValue();
                }
                translations.put(language, value);
            }
        } else {
            translations.put("", "");
        }
        return translations.isEmpty() ? null : TranslatedString.getI18NString(translations);
    }

    public void setTransitAlertService(TransitAlertService transitAlertService) {
        this.transitAlertService = transitAlertService;
    }

    public long getEarlyStart() {
        return this.earlyStart;
    }

    public void setEarlyStart(long earlyStart) {
        this.earlyStart = earlyStart;
    }

    public void setSiriFuzzyTripMatcher(SiriFuzzyTripMatcher siriFuzzyTripMatcher) {
        this.siriFuzzyTripMatcher = siriFuzzyTripMatcher;
    }
}

