/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.reportapi.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.opentripplanner.ext.reportapi.model.BicyleSafetyReport;
import org.opentripplanner.ext.reportapi.model.TransfersReport;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.routing.graph.GraphIndex;
import org.opentripplanner.standalone.server.OTPServer;

@Path(value="/report")
@Produces(value={"text/plain"})
public class ReportResource {
    private final TransferService transferService;
    private final GraphIndex index;

    public ReportResource(@Context OTPServer server) {
        this.transferService = server.getRouter().graph.getTransferService();
        this.index = server.getRouter().graph.index;
    }

    @GET
    @Path(value="/transfers.csv")
    @Produces(value={"application/octet-stream"})
    public String getTransfersAsCsv() {
        return TransfersReport.export(this.transferService.listAll(), this.index);
    }

    @GET
    @Path(value="/bicycle-safety.html")
    @Produces(value={"text/html"})
    public Response getBicycleSafetyPage() {
        InputStream is = this.getClass().getResourceAsStream("/reportapi/report.html");
        try {
            return Response.ok((Object)new String(is.readAllBytes(), StandardCharsets.UTF_8)).build();
        }
        catch (IOException e) {
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/bicycle-safety.csv")
    @Produces(value={"text/csv"})
    public Response getBicycleSafetyAsCsv(@DefaultValue(value="default") @QueryParam(value="osmWayPropertySet") String osmWayPropertySet) {
        return Response.ok((Object)BicyleSafetyReport.makeCsv(osmWayPropertySet)).header("Content-Disposition", (Object)("attachment; filename=\"" + osmWayPropertySet + "-bicycle-safety.csv\"")).build();
    }
}

