/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.reportapi.model;

import org.opentripplanner.common.model.P2;
import org.opentripplanner.ext.reportapi.model.CsvReportBuilder;
import org.opentripplanner.graph_builder.module.osm.WayPropertySet;
import org.opentripplanner.graph_builder.module.osm.WayPropertySetSource;

public class BicyleSafetyReport {
    public static void main(String[] args) {
        System.out.println(BicyleSafetyReport.makeCsv("norway"));
    }

    public static String makeCsv(String configName) {
        WayPropertySet wayPropertySet = new WayPropertySet();
        WayPropertySetSource source = WayPropertySetSource.fromConfig(configName);
        source.populateProperties(wayPropertySet);
        CsvReportBuilder buf = new CsvReportBuilder(",");
        buf.addHeader("OSM tags for osmWayPropertySet " + configName, "mixin", "permissions", "safety penalty there", "safety penalty back");
        wayPropertySet.getWayProperties().forEach(p -> {
            buf.addText(p.getSpecifier().toString());
            buf.addBoolean(p.isSafetyMixin());
            buf.addText(p.getProperties().getPermission().toString());
            P2<Double> safetyProps = p.getProperties().getSafetyFeatures();
            buf.addNumber((Number)safetyProps.first);
            buf.addNumber((Number)safetyProps.second);
            buf.newLine();
        });
        return buf.toString();
    }
}

