/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.parkAndRideApi;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.routing.vertextype.VehicleParkingEntranceVertex;
import org.opentripplanner.standalone.server.OTPServer;
import org.opentripplanner.standalone.server.Router;

@Path(value="/routers/{ignoreRouterId}/park_and_ride")
public class ParkAndRideResource {
    @Context
    OTPServer otpServer;
    @Deprecated
    @PathParam(value="ignoreRouterId")
    private String ignoreRouterId;

    @GET
    @Produces(value={"application/json"})
    public Response getParkAndRide(@QueryParam(value="lowerLeft") String lowerLeft, @QueryParam(value="upperRight") String upperRight, @QueryParam(value="maxTransitDistance") Double maxTransitDistance) {
        Router router = this.otpServer.getRouter();
        Envelope envelope = lowerLeft != null ? ParkAndRideResource.getEnvelope(lowerLeft, upperRight) : new Envelope(-180.0, 180.0, -90.0, 90.0);
        ArrayList<ParkAndRideInfo> prs = new ArrayList<ParkAndRideInfo>();
        for (Vertex v : router.graph.getVertices()) {
            List<TransitStopVertex> stops;
            if (!(v instanceof VehicleParkingEntranceVertex) || !((VehicleParkingEntranceVertex)v).getVehicleParking().hasAnyCarPlaces() || !envelope.contains(v.getX(), v.getY()) || maxTransitDistance != null && (stops = router.graph.getStreetIndex().getNearbyTransitStops(new Coordinate(v.getX(), v.getY()), maxTransitDistance)).isEmpty()) continue;
            prs.add(new ParkAndRideInfo((VehicleParkingEntranceVertex)v));
        }
        return Response.status((Response.Status)Response.Status.OK).entity(prs).build();
    }

    public static Envelope getEnvelope(String lowerLeft, String upperRight) {
        String[] lowerLeftParts = lowerLeft.split(",");
        String[] upperRightParts = upperRight.split(",");
        return new Envelope(Double.parseDouble(lowerLeftParts[1]), Double.parseDouble(upperRightParts[1]), Double.parseDouble(lowerLeftParts[0]), Double.parseDouble(upperRightParts[0]));
    }

    public static class ParkAndRideInfo {
        public String name;
        public Double x;
        public Double y;

        public ParkAndRideInfo(VehicleParkingEntranceVertex vertex) {
            this.name = vertex.getDefaultName();
            this.x = vertex.getX();
            this.y = vertex.getY();
        }
    }
}

