/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.stream.Collectors;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLRequestContext;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.model.Route;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.core.FareComponent;

public class LegacyGraphQLfareComponentImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLFareComponent {
    @Override
    public DataFetcher<String> fareId() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).fareId.toString();
    }

    @Override
    public DataFetcher<String> currency() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).price.getCurrency().getCurrencyCode();
    }

    @Override
    public DataFetcher<Integer> cents() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).price.getCents();
    }

    @Override
    public DataFetcher<Iterable<Route>> routes() {
        return environment -> {
            RoutingService routingService = this.getRoutingService(environment);
            return this.getSource((DataFetchingEnvironment)environment).routes.stream().map(routingService::getRouteForId).collect(Collectors.toList());
        };
    }

    private RoutingService getRoutingService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).getRoutingService();
    }

    private FareComponent getSource(DataFetchingEnvironment environment) {
        return (FareComponent)environment.getSource();
    }
}

