/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLRequestContext;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.routing.RoutingService;

public class LegacyGraphQLStoptimeImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLStoptime {
    @Override
    public DataFetcher<Object> stop() {
        return environment -> this.getRoutingService(environment).getStopForId(this.getSource(environment).getStopId());
    }

    @Override
    public DataFetcher<Integer> scheduledArrival() {
        return environment -> this.missingValueToNull(this.getSource(environment).getScheduledArrival());
    }

    @Override
    public DataFetcher<Integer> realtimeArrival() {
        return environment -> this.missingValueToNull(this.getSource(environment).getRealtimeArrival());
    }

    @Override
    public DataFetcher<Integer> arrivalDelay() {
        return environment -> this.missingValueToNull(this.getSource(environment).getArrivalDelay());
    }

    @Override
    public DataFetcher<Integer> scheduledDeparture() {
        return environment -> this.missingValueToNull(this.getSource(environment).getScheduledDeparture());
    }

    @Override
    public DataFetcher<Integer> realtimeDeparture() {
        return environment -> this.missingValueToNull(this.getSource(environment).getRealtimeDeparture());
    }

    @Override
    public DataFetcher<Integer> departureDelay() {
        return environment -> this.getSource(environment).getDepartureDelay();
    }

    @Override
    public DataFetcher<Boolean> timepoint() {
        return environment -> this.getSource(environment).isTimepoint();
    }

    @Override
    public DataFetcher<Boolean> realtime() {
        return environment -> this.getSource(environment).isRealtime();
    }

    @Override
    public DataFetcher<String> realtimeState() {
        return environment -> this.getSource(environment).getRealtimeState().name();
    }

    @Override
    public DataFetcher<String> pickupType() {
        return environment -> {
            switch (this.getSource(environment).getPickupType().getGtfsCode()) {
                case 0: {
                    return "SCHEDULED";
                }
                case 1: {
                    return "NONE";
                }
                case 2: {
                    return "CALL_AGENCY";
                }
                case 3: {
                    return "COORDINATE_WITH_DRIVER";
                }
            }
            return null;
        };
    }

    @Override
    public DataFetcher<String> dropoffType() {
        return environment -> {
            switch (this.getSource(environment).getDropoffType().getGtfsCode()) {
                case 0: {
                    return "SCHEDULED";
                }
                case 1: {
                    return "NONE";
                }
                case 2: {
                    return "CALL_AGENCY";
                }
                case 3: {
                    return "COORDINATE_WITH_DRIVER";
                }
            }
            return null;
        };
    }

    @Override
    public DataFetcher<Long> serviceDay() {
        return environment -> this.getSource(environment).getServiceDay();
    }

    @Override
    public DataFetcher<Trip> trip() {
        return environment -> this.getSource(environment).getTrip();
    }

    @Override
    public DataFetcher<String> headsign() {
        return environment -> this.getSource(environment).getHeadsign();
    }

    private RoutingService getRoutingService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).getRoutingService();
    }

    private TripTimeOnDate getSource(DataFetchingEnvironment environment) {
        return (TripTimeOnDate)environment.getSource();
    }

    private Integer missingValueToNull(int value) {
        if (value == -999) {
            return null;
        }
        return value;
    }
}

