/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLRequestContext;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLTypes;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopTimesInPattern;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.routing.stoptimes.ArrivalDeparture;

public class LegacyGraphQLStopImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLStop {
    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> this.getValue(environment, stop -> new Relay.ResolvedGlobalId("Stop", stop.getId().toString()), station -> new Relay.ResolvedGlobalId("Stop", station.getId().toString()));
    }

    @Override
    public DataFetcher<Iterable<TripTimeOnDate>> stopTimesForPattern() {
        return environment -> this.getValue(environment, stop -> {
            LegacyGraphQLTypes.LegacyGraphQLStopStopTimesForPatternArgs args;
            RoutingService routingService = this.getRoutingService(environment);
            TripPattern pattern = routingService.getTripPatternForId(FeedScopedId.parseId((args = new LegacyGraphQLTypes.LegacyGraphQLStopStopTimesForPatternArgs(environment.getArguments())).getLegacyGraphQLId()));
            if (pattern == null) {
                return null;
            }
            return routingService.stopTimesForPatternAtStop((StopLocation)stop, pattern, args.getLegacyGraphQLStartTime(), args.getLegacyGraphQLTimeRange(), args.getLegacyGraphQLNumberOfDepartures(), args.getLegacyGraphQLOmitNonPickups() != false ? ArrivalDeparture.DEPARTURES : ArrivalDeparture.BOTH);
        }, station -> null);
    }

    @Override
    public DataFetcher<String> gtfsId() {
        return environment -> this.getValue(environment, stop -> stop.getId().toString(), station -> station.getId().toString());
    }

    @Override
    public DataFetcher<String> name() {
        return environment -> this.getValue(environment, StopLocation::getName, Station::getName);
    }

    @Override
    public DataFetcher<Double> lat() {
        return environment -> this.getValue(environment, StopLocation::getLat, Station::getLat);
    }

    @Override
    public DataFetcher<Double> lon() {
        return environment -> this.getValue(environment, StopLocation::getLon, Station::getLon);
    }

    @Override
    public DataFetcher<String> code() {
        return environment -> this.getValue(environment, StopLocation::getCode, Station::getCode);
    }

    @Override
    public DataFetcher<String> desc() {
        return environment -> this.getValue(environment, StopLocation::getDescription, Station::getDescription);
    }

    @Override
    public DataFetcher<String> zoneId() {
        return environment -> this.getValue(environment, StopLocation::getFirstZoneAsString, station -> null);
    }

    @Override
    public DataFetcher<String> url() {
        return environment -> this.getValue(environment, StopLocation::getUrl, Station::getUrl);
    }

    @Override
    public DataFetcher<Object> locationType() {
        return environment -> this.getValue(environment, stop -> "STOP", station -> "STATION");
    }

    @Override
    public DataFetcher<Object> parentStation() {
        return environment -> this.getValue(environment, StopLocation::getParentStation, station -> null);
    }

    @Override
    public DataFetcher<Object> wheelchairBoarding() {
        return environment -> this.getValue(environment, StopLocation::getWheelchairBoarding, station -> null);
    }

    @Override
    public DataFetcher<String> direction() {
        return environment -> null;
    }

    @Override
    public DataFetcher<Object> geometries() {
        return environment -> this.getValue(environment, StopLocation::getGeometry, Station::getGeometry);
    }

    @Override
    public DataFetcher<String> timezone() {
        return environment -> this.getValue(environment, stop -> stop.getTimeZone().toString(), station -> station.getTimezone().toString());
    }

    @Override
    public DataFetcher<Integer> vehicleType() {
        return environment -> null;
    }

    @Override
    public DataFetcher<String> vehicleMode() {
        return environment -> this.getValue(environment, stop -> {
            if (stop.getVehicleType() != null) {
                return stop.getVehicleType().name();
            }
            return this.getRoutingService(environment).getPatternsForStop((StopLocation)stop).stream().map(TripPattern::getMode).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).map(Enum::toString).orElse(null);
        }, station -> {
            RoutingService routingService = this.getRoutingService(environment);
            return station.getChildStops().stream().flatMap(stop -> routingService.getPatternsForStop((StopLocation)stop).stream().map(TripPattern::getMode)).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).map(Enum::toString).orElse(null);
        });
    }

    @Override
    public DataFetcher<String> platformCode() {
        return environment -> this.getValue(environment, StopLocation::getPlatformCode, station -> null);
    }

    @Override
    public DataFetcher<Object> cluster() {
        return environment -> null;
    }

    @Override
    public DataFetcher<Iterable<Object>> stops() {
        return environment -> this.getValue(environment, stop -> null, station -> new ArrayList<StopLocation>(station.getChildStops()));
    }

    @Override
    public DataFetcher<Iterable<Route>> routes() {
        return this::getRoutes;
    }

    @Override
    public DataFetcher<Iterable<TripPattern>> patterns() {
        return this::getPatterns;
    }

    @Override
    public DataFetcher<Iterable<NearbyStop>> transfers() {
        return environment -> this.getValue(environment, stop -> {
            Integer maxDistance = new LegacyGraphQLTypes.LegacyGraphQLStopTransfersArgs(environment.getArguments()).getLegacyGraphQLMaxDistance();
            return this.getRoutingService(environment).getTransfersByStop((StopLocation)stop).stream().filter(transfer -> maxDistance == null || transfer.getDistanceMeters() < (double)maxDistance.intValue()).filter(transfer -> transfer.to instanceof Stop).map(transfer -> new NearbyStop(transfer.to, transfer.getDistanceMeters(), transfer.getEdges(), GeometryUtils.concatenateLineStrings(transfer.getEdges().stream().map(Edge::getGeometry).collect(Collectors.toList())), null)).collect(Collectors.toList());
        }, station -> null);
    }

    @Override
    public DataFetcher<Iterable<StopTimesInPattern>> stoptimesForServiceDate() {
        return environment -> {
            ServiceDate date;
            RoutingService routingService = this.getRoutingService(environment);
            LegacyGraphQLTypes.LegacyGraphQLStopStoptimesForServiceDateArgs args = new LegacyGraphQLTypes.LegacyGraphQLStopStoptimesForServiceDateArgs(environment.getArguments());
            try {
                date = ServiceDate.parseString(args.getLegacyGraphQLDate());
            }
            catch (ParseException e) {
                return null;
            }
            Function<StopLocation, List> stopTFunction = stop -> routingService.getStopTimesForStop((StopLocation)stop, date, args.getLegacyGraphQLOmitNonPickups() != false ? ArrivalDeparture.DEPARTURES : ArrivalDeparture.BOTH);
            return this.getValue(environment, stopTFunction, station -> station.getChildStops().stream().map(stopTFunction).flatMap(Collection::stream).collect(Collectors.toList()));
        };
    }

    @Override
    public DataFetcher<Iterable<StopTimesInPattern>> stoptimesForPatterns() {
        return environment -> {
            RoutingService routingService = this.getRoutingService(environment);
            LegacyGraphQLTypes.LegacyGraphQLStopStoptimesForPatternsArgs args = new LegacyGraphQLTypes.LegacyGraphQLStopStoptimesForPatternsArgs(environment.getArguments());
            Function<StopLocation, List> stopTFunction = stop -> routingService.stopTimesForStop((StopLocation)stop, args.getLegacyGraphQLStartTime(), args.getLegacyGraphQLTimeRange(), args.getLegacyGraphQLNumberOfDepartures(), args.getLegacyGraphQLOmitNonPickups() != false ? ArrivalDeparture.DEPARTURES : ArrivalDeparture.BOTH, false);
            return this.getValue(environment, stopTFunction, station -> station.getChildStops().stream().map(stopTFunction).flatMap(Collection::stream).collect(Collectors.toList()));
        };
    }

    @Override
    public DataFetcher<Iterable<TripTimeOnDate>> stoptimesWithoutPatterns() {
        return environment -> {
            RoutingService routingService = this.getRoutingService(environment);
            LegacyGraphQLTypes.LegacyGraphQLStopStoptimesForPatternsArgs args = new LegacyGraphQLTypes.LegacyGraphQLStopStoptimesForPatternsArgs(environment.getArguments());
            Function<StopLocation, Stream> stopTFunction = stop -> routingService.stopTimesForStop((StopLocation)stop, args.getLegacyGraphQLStartTime(), args.getLegacyGraphQLTimeRange(), args.getLegacyGraphQLNumberOfDepartures(), args.getLegacyGraphQLOmitNonPickups() != false ? ArrivalDeparture.DEPARTURES : ArrivalDeparture.BOTH, false).stream();
            Stream stream = this.getValue(environment, stopTFunction, station -> station.getChildStops().stream().flatMap(stopTFunction));
            return stream.flatMap(stoptimesWithPattern -> stoptimesWithPattern.times.stream()).sorted(Comparator.comparing(t -> t.getServiceDay() + (long)t.getRealtimeDeparture())).limit(args.getLegacyGraphQLNumberOfDepartures().intValue()).collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<Iterable<TransitAlert>> alerts() {
        return environment -> {
            TransitAlertService alertService = this.getRoutingService(environment).getTransitAlertService();
            LegacyGraphQLTypes.LegacyGraphQLStopAlertsArgs args = new LegacyGraphQLTypes.LegacyGraphQLStopAlertsArgs(environment.getArguments());
            List types = (List)args.getLegacyGraphQLTypes();
            FeedScopedId id = this.getValue(environment, stop -> stop.getId(), station -> station.getId());
            if (types != null) {
                ArrayList<TransitAlert> alerts = new ArrayList<TransitAlert>();
                if (types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.STOP)) {
                    alerts.addAll(alertService.getStopAlerts(id));
                }
                if (types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.STOP_ON_ROUTES) || types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.STOP_ON_TRIPS)) {
                    alerts.addAll(alertService.getAllAlerts().stream().filter(alert -> alert.getEntities().stream().anyMatch(entity -> types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.STOP_ON_ROUTES) && entity instanceof EntitySelector.StopAndRoute && ((EntitySelector.StopAndRoute)entity).stopAndRoute.stop.equals(id) || types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.STOP_ON_TRIPS) && entity instanceof EntitySelector.StopAndTrip && ((EntitySelector.StopAndTrip)entity).stopAndTrip.stop.equals(id))).collect(Collectors.toList()));
                }
                if (types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.PATTERNS) || types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.TRIPS)) {
                    this.getPatterns(environment).forEach(pattern -> {
                        if (types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.PATTERNS)) {
                            alerts.addAll(alertService.getDirectionAndRouteAlerts(pattern.getDirection().gtfsCode, pattern.getRoute().getId()));
                        }
                        if (types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.TRIPS)) {
                            pattern.scheduledTripsAsStream().forEach(trip -> alerts.addAll(alertService.getTripAlerts(trip.getId(), null)));
                        }
                    });
                }
                if (types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.ROUTES) || types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.AGENCIES_OF_ROUTES)) {
                    this.getRoutes(environment).forEach(route -> {
                        if (types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.ROUTES)) {
                            alerts.addAll(alertService.getRouteAlerts(route.getId()));
                        }
                        if (types.contains((Object)LegacyGraphQLTypes.LegacyGraphQLStopAlertType.AGENCIES_OF_ROUTES)) {
                            alerts.addAll(alertService.getAgencyAlerts(route.getAgency().getId()));
                        }
                    });
                }
                return alerts.stream().distinct().collect(Collectors.toList());
            }
            return alertService.getStopAlerts(id);
        };
    }

    private Collection<TripPattern> getPatterns(DataFetchingEnvironment environment) {
        return this.getValue(environment, stop -> this.getRoutingService(environment).getPatternsForStop((StopLocation)stop, true), station -> null);
    }

    private Collection<Route> getRoutes(DataFetchingEnvironment environment) {
        return this.getValue(environment, stop -> this.getRoutingService(environment).getRoutesForStop((StopLocation)stop), station -> null);
    }

    private RoutingService getRoutingService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).getRoutingService();
    }

    private <T> T getValue(DataFetchingEnvironment environment, Function<StopLocation, T> stopTFunction, Function<Station, T> stationTFunction) {
        Object source = environment.getSource();
        if (source instanceof StopLocation) {
            return stopTFunction.apply((StopLocation)source);
        }
        if (source instanceof Station) {
            return stationTFunction.apply((Station)source);
        }
        return null;
    }
}

