/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLRequestContext;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLTypes;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.services.TransitAlertService;

public class LegacyGraphQLRouteImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLRoute {
    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> new Relay.ResolvedGlobalId("Route", this.getSource(environment).getId().toString());
    }

    @Override
    public DataFetcher<String> gtfsId() {
        return environment -> this.getSource(environment).getId().toString();
    }

    @Override
    public DataFetcher<Agency> agency() {
        return environment -> this.getSource(environment).getAgency();
    }

    @Override
    public DataFetcher<String> shortName() {
        return environment -> this.getSource(environment).getShortName();
    }

    @Override
    public DataFetcher<String> longName() {
        return environment -> this.getSource(environment).getLongName();
    }

    @Override
    public DataFetcher<String> mode() {
        return environment -> this.getSource(environment).getMode().name();
    }

    @Override
    public DataFetcher<Integer> type() {
        return environment -> this.getSource(environment).getGtfsType();
    }

    @Override
    public DataFetcher<String> desc() {
        return environment -> this.getSource(environment).getDesc();
    }

    @Override
    public DataFetcher<String> url() {
        return environment -> this.getSource(environment).getUrl();
    }

    @Override
    public DataFetcher<String> color() {
        return environment -> this.getSource(environment).getColor();
    }

    @Override
    public DataFetcher<String> textColor() {
        return environment -> this.getSource(environment).getTextColor();
    }

    @Override
    public DataFetcher<String> bikesAllowed() {
        return environment -> {
            switch (this.getSource(environment).getBikesAllowed()) {
                case UNKNOWN: {
                    return "NO_INFORMATION";
                }
                case ALLOWED: {
                    return "POSSIBLE";
                }
                case NOT_ALLOWED: {
                    return "NOT_POSSIBLE";
                }
            }
            return null;
        };
    }

    @Override
    public DataFetcher<Iterable<TripPattern>> patterns() {
        return environment -> this.getRoutingService(environment).getPatternsForRoute().get((Object)this.getSource(environment));
    }

    @Override
    public DataFetcher<Iterable<Object>> stops() {
        return environment -> this.getStops(environment);
    }

    @Override
    public DataFetcher<Iterable<Trip>> trips() {
        return environment -> this.getTrips(environment);
    }

    @Override
    public DataFetcher<Iterable<TransitAlert>> alerts() {
        return environment -> {
            TransitAlertService alertService = this.getAlertService(environment);
            LegacyGraphQLTypes.LegacyGraphQLRouteAlertsArgs args = new LegacyGraphQLTypes.LegacyGraphQLRouteAlertsArgs(environment.getArguments());
            Iterable<LegacyGraphQLTypes.LegacyGraphQLRouteAlertType> types = args.getLegacyGraphQLTypes();
            if (types != null) {
                ArrayList alerts = new ArrayList();
                types.forEach(type -> {
                    switch (type) {
                        case ROUTE: {
                            alerts.addAll(alertService.getRouteAlerts(this.getSource(environment).getId()));
                            break;
                        }
                        case ROUTE_TYPE: {
                            alerts.addAll(alertService.getRouteTypeAlerts(this.getSource(environment).getGtfsType(), this.getSource(environment).getId().getFeedId()));
                            alerts.addAll(alertService.getRouteTypeAndAgencyAlerts(this.getSource(environment).getGtfsType(), this.getSource(environment).getAgency().getId()));
                            break;
                        }
                        case AGENCY: {
                            alerts.addAll(alertService.getAgencyAlerts(this.getSource(environment).getAgency().getId()));
                            break;
                        }
                        case TRIPS: {
                            this.getTrips(environment).forEach(trip -> alerts.addAll(alertService.getTripAlerts(trip.getId(), null)));
                            break;
                        }
                        case STOPS_ON_ROUTE: {
                            alerts.addAll(alertService.getAllAlerts().stream().filter(alert -> alert.getEntities().stream().anyMatch(entity -> entity instanceof EntitySelector.StopAndRoute && ((EntitySelector.StopAndRoute)entity).stopAndRoute.routeOrTrip.equals(this.getSource(environment).getId()))).collect(Collectors.toList()));
                            this.getStops(environment).forEach(stop -> alerts.addAll(alertService.getStopAlerts(((StopLocation)stop).getId())));
                            break;
                        }
                        case STOPS_ON_TRIPS: {
                            Iterable<Trip> trips = this.getTrips(environment);
                            trips.forEach(trip -> alerts.addAll(alertService.getAllAlerts().stream().filter(alert -> alert.getEntities().stream().anyMatch(entity -> entity instanceof EntitySelector.StopAndTrip && ((EntitySelector.StopAndTrip)entity).stopAndTrip.routeOrTrip.equals(trip.getId()))).collect(Collectors.toList())));
                            break;
                        }
                        case PATTERNS: {
                            alerts.addAll(alertService.getDirectionAndRouteAlerts(0, this.getSource(environment).getId()));
                            alerts.addAll(alertService.getDirectionAndRouteAlerts(1, this.getSource(environment).getId()));
                        }
                    }
                });
                return alerts.stream().distinct().collect(Collectors.toList());
            }
            return this.getAlertService(environment).getRouteAlerts(this.getSource(environment).getId());
        };
    }

    private Iterable<Object> getStops(DataFetchingEnvironment environment) {
        return this.getRoutingService(environment).getPatternsForRoute().get((Object)this.getSource(environment)).stream().map(TripPattern::getStops).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Iterable<Trip> getTrips(DataFetchingEnvironment environment) {
        return this.getRoutingService(environment).getPatternsForRoute().get((Object)this.getSource(environment)).stream().flatMap(TripPattern::scheduledTripsAsStream).collect(Collectors.toSet());
    }

    private TransitAlertService getAlertService(DataFetchingEnvironment environment) {
        return this.getRoutingService(environment).getTransitAlertService();
    }

    private RoutingService getRoutingService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).getRoutingService();
    }

    private Route getSource(DataFetchingEnvironment environment) {
        return (Route)environment.getSource();
    }
}

