/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStationUris;

public class LegacyGraphQLRentalVehicleImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLRentalVehicle {
    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> new Relay.ResolvedGlobalId("RentalVehicle", this.getSource(environment).getId().toString());
    }

    @Override
    public DataFetcher<String> vehicleId() {
        return environment -> this.getSource(environment).getId().toString();
    }

    @Override
    public DataFetcher<String> name() {
        return environment -> this.getSource(environment).getName().toString(environment.getLocale());
    }

    @Override
    public DataFetcher<Boolean> allowPickupNow() {
        return environment -> this.getSource(environment).allowPickupNow();
    }

    @Override
    public DataFetcher<String> network() {
        return environment -> this.getSource(environment).getNetwork();
    }

    @Override
    public DataFetcher<Double> lon() {
        return environment -> this.getSource(environment).getLongitude();
    }

    @Override
    public DataFetcher<Double> lat() {
        return environment -> this.getSource(environment).getLatitude();
    }

    @Override
    public DataFetcher<Boolean> operative() {
        return environment -> this.getSource(environment).isAllowPickup();
    }

    @Override
    public DataFetcher<VehicleRentalStationUris> rentalUris() {
        return environment -> this.getSource(environment).getRentalUris();
    }

    private VehicleRentalPlace getSource(DataFetchingEnvironment environment) {
        return (VehicleRentalPlace)environment.getSource();
    }
}

