/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import graphql.execution.DataFetcherResult;
import graphql.relay.Connection;
import graphql.relay.Relay;
import graphql.relay.SimpleListConnection;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.api.parameter.QualifiedMode;
import org.opentripplanner.api.parameter.QualifiedModeSet;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLRequestContext;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLTypes;
import org.opentripplanner.ext.legacygraphqlapi.mapping.LegacyGraphQLCauseMapper;
import org.opentripplanner.ext.legacygraphqlapi.mapping.LegacyGraphQLEffectMapper;
import org.opentripplanner.ext.legacygraphqlapi.mapping.LegacyGraphQLSeverityMapper;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Station;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.api.response.RoutingResponse;
import org.opentripplanner.routing.core.BicycleOptimizeType;
import org.opentripplanner.routing.core.FareRuleSet;
import org.opentripplanner.routing.error.RoutingValidationException;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.graphfinder.PatternAtStop;
import org.opentripplanner.routing.graphfinder.PlaceAtDistance;
import org.opentripplanner.routing.graphfinder.PlaceType;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingService;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStation;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStationService;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalVehicle;
import org.opentripplanner.routing.vertextype.TransitStopVertex;
import org.opentripplanner.updater.GtfsRealtimeFuzzyTripMatcher;
import org.opentripplanner.util.ResourceBundleSingleton;

public class LegacyGraphQLQueryTypeImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLQueryType {
    @Override
    public DataFetcher<Object> node() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeNodeArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeNodeArgs(environment.getArguments());
            String type = args.getLegacyGraphQLId().getType();
            String id = args.getLegacyGraphQLId().getId();
            RoutingService routingService = ((LegacyGraphQLRequestContext)environment.getContext()).getRoutingService();
            VehicleParkingService vehicleParkingService = routingService.getVehicleParkingService();
            VehicleRentalStationService vehicleRentalStationService = routingService.getVehicleRentalStationService();
            switch (type) {
                case "Agency": {
                    return routingService.getAgencyForId(FeedScopedId.parseId(id));
                }
                case "Alert": {
                    return null;
                }
                case "BikePark": {
                    FeedScopedId bikeParkId = FeedScopedId.parseId(id);
                    return vehicleParkingService == null ? null : vehicleParkingService.getBikeParks().filter(bikePark -> bikePark.getId().equals(bikeParkId)).findAny().orElse(null);
                }
                case "BikeRentalStation": {
                    return vehicleRentalStationService == null ? null : vehicleRentalStationService.getVehicleRentalPlace(FeedScopedId.parseId(id));
                }
                case "VehicleRentalStation": {
                    return vehicleRentalStationService == null ? null : vehicleRentalStationService.getVehicleRentalStation(FeedScopedId.parseId(id));
                }
                case "RentalVehicle": {
                    return vehicleRentalStationService == null ? null : vehicleRentalStationService.getVehicleRentalVehicle(FeedScopedId.parseId(id));
                }
                case "CarPark": {
                    FeedScopedId carParkId = FeedScopedId.parseId(id);
                    return vehicleParkingService == null ? null : vehicleParkingService.getCarParks().filter(carPark -> carPark.getId().equals(carParkId)).findAny().orElse(null);
                }
                case "Cluster": {
                    return null;
                }
                case "DepartureRow": {
                    return PatternAtStop.fromId(routingService, id);
                }
                case "Pattern": {
                    return routingService.getTripPatternForId(FeedScopedId.parseId(id));
                }
                case "placeAtDistance": {
                    String[] parts = id.split(";");
                    Relay.ResolvedGlobalId internalId = new Relay().fromGlobalId(parts[1]);
                    Object place = this.node().get(DataFetchingEnvironmentImpl.newDataFetchingEnvironment((DataFetchingEnvironment)environment).source(new Object()).arguments(Map.of("id", internalId)).build());
                    return new PlaceAtDistance(place, Double.parseDouble(parts[0]));
                }
                case "Route": {
                    return routingService.getRouteForId(FeedScopedId.parseId(id));
                }
                case "Stop": {
                    return routingService.getStopForId(FeedScopedId.parseId(id));
                }
                case "Stoptime": {
                    return null;
                }
                case "stopAtDistance": {
                    String[] parts = id.split(";");
                    StopLocation stop = routingService.getStopForId(FeedScopedId.parseId(parts[1]));
                    return new NearbyStop(stop, Integer.parseInt(parts[0]), null, null, null);
                }
                case "TicketType": {
                    return null;
                }
                case "Trip": {
                    FeedScopedId scopedId = FeedScopedId.parseId(id);
                    Trip trip = routingService.getTripForId().get(scopedId);
                    return trip;
                }
                case "VehicleParking": {
                    FeedScopedId vehicleParkingId = FeedScopedId.parseId(id);
                    return vehicleParkingService == null ? null : vehicleParkingService.getVehicleParkings().filter(bikePark -> bikePark.getId().equals(vehicleParkingId)).findAny().orElse(null);
                }
            }
            return null;
        };
    }

    @Override
    public DataFetcher<Iterable<String>> feeds() {
        return environment -> this.getRoutingService(environment).getFeedIds();
    }

    @Override
    public DataFetcher<Iterable<Agency>> agencies() {
        return environment -> this.getRoutingService(environment).getAgencies();
    }

    @Override
    public DataFetcher<Iterable<FareRuleSet>> ticketTypes() {
        return environment -> null;
    }

    @Override
    public DataFetcher<Agency> agency() {
        return environment -> {
            FeedScopedId id = FeedScopedId.parseId(new LegacyGraphQLTypes.LegacyGraphQLQueryTypeAgencyArgs(environment.getArguments()).getLegacyGraphQLId());
            return this.getRoutingService(environment).getAgencyForId(id);
        };
    }

    @Override
    public DataFetcher<Iterable<Object>> stops() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeStopsArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeStopsArgs(environment.getArguments());
            RoutingService routingService = this.getRoutingService(environment);
            if (args.getLegacyGraphQLIds() != null) {
                return StreamSupport.stream(args.getLegacyGraphQLIds().spliterator(), false).map(FeedScopedId::parseId).map(routingService::getStopForId).collect(Collectors.toList());
            }
            Stream<StopLocation> stopStream = routingService.getAllStops().stream();
            if (args.getLegacyGraphQLName() != null) {
                String name = args.getLegacyGraphQLName().toLowerCase(environment.getLocale());
                stopStream = stopStream.filter(stop -> stop.getName().toLowerCase(environment.getLocale()).startsWith(name));
            }
            return stopStream.collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<Iterable<Object>> stopsByBbox() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeStopsByBboxArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeStopsByBboxArgs(environment.getArguments());
            Envelope envelope = new Envelope(new Coordinate(args.getLegacyGraphQLMinLon().doubleValue(), args.getLegacyGraphQLMinLat().doubleValue()), new Coordinate(args.getLegacyGraphQLMaxLon().doubleValue(), args.getLegacyGraphQLMaxLat().doubleValue()));
            Stream<Stop> stopStream = this.getRoutingService(environment).getStopSpatialIndex().query(envelope).stream().filter(transitStopVertex -> envelope.contains(transitStopVertex.getCoordinate())).map(TransitStopVertex::getStop);
            if (args.getLegacyGraphQLFeeds() != null) {
                ArrayList feedIds = Lists.newArrayList(args.getLegacyGraphQLFeeds());
                stopStream = stopStream.filter(stop -> feedIds.contains(stop.getId().getFeedId()));
            }
            return stopStream.collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<Connection<NearbyStop>> stopsByRadius() {
        return environment -> {
            List<Object> stops;
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeStopsByRadiusArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeStopsByRadiusArgs(environment.getArguments());
            try {
                stops = this.getRoutingService(environment).findClosestStops(args.getLegacyGraphQLLat(), args.getLegacyGraphQLLon(), args.getLegacyGraphQLRadius().intValue());
            }
            catch (RoutingValidationException e) {
                stops = Collections.emptyList();
            }
            return new SimpleListConnection(stops).get(environment);
        };
    }

    @Override
    public DataFetcher<Connection<PlaceAtDistance>> nearest() {
        return environment -> {
            List places;
            List<FeedScopedId> filterByStops = null;
            List<FeedScopedId> filterByRoutes = null;
            ArrayList filterByBikeRentalStations = null;
            ArrayList filterByBikeParks = null;
            ArrayList filterByCarParks = null;
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeNearestArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeNearestArgs(environment.getArguments());
            LegacyGraphQLTypes.LegacyGraphQLInputFiltersInput filterByIds = args.getLegacyGraphQLFilterByIds();
            if (filterByIds != null) {
                filterByStops = filterByIds.getLegacyGraphQLStops() != null ? StreamSupport.stream(filterByIds.getLegacyGraphQLStops().spliterator(), false).map(FeedScopedId::parseId).collect(Collectors.toList()) : null;
                filterByRoutes = filterByIds.getLegacyGraphQLRoutes() != null ? StreamSupport.stream(filterByIds.getLegacyGraphQLRoutes().spliterator(), false).map(FeedScopedId::parseId).collect(Collectors.toList()) : null;
                filterByBikeRentalStations = filterByIds.getLegacyGraphQLBikeRentalStations() != null ? Lists.newArrayList(filterByIds.getLegacyGraphQLBikeRentalStations()) : null;
                filterByBikeParks = filterByIds.getLegacyGraphQLBikeParks() != null ? Lists.newArrayList(filterByIds.getLegacyGraphQLBikeParks()) : null;
                filterByCarParks = filterByIds.getLegacyGraphQLCarParks() != null ? Lists.newArrayList(filterByIds.getLegacyGraphQLCarParks()) : null;
            }
            List<TransitMode> filterByModes = args.getLegacyGraphQLFilterByModes() != null ? StreamSupport.stream(args.getLegacyGraphQLFilterByModes().spliterator(), false).map(mode -> {
                try {
                    return TransitMode.valueOf(mode.name());
                }
                catch (IllegalArgumentException ignored) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList()) : null;
            List<PlaceType> filterByPlaceTypes = args.getLegacyGraphQLFilterByPlaceTypes() != null ? StreamSupport.stream(args.getLegacyGraphQLFilterByPlaceTypes().spliterator(), false).map(placeType -> placeType.name()).map(placeType -> placeType.equals("DEPARTURE_ROW") ? "PATTERN_AT_STOP" : placeType).map(PlaceType::valueOf).collect(Collectors.toList()) : null;
            try {
                places = new ArrayList<PlaceAtDistance>(this.getRoutingService(environment).findClosestPlaces(args.getLegacyGraphQLLat(), args.getLegacyGraphQLLon(), args.getLegacyGraphQLMaxDistance().intValue(), args.getLegacyGraphQLMaxResults(), filterByModes, filterByPlaceTypes, filterByStops, filterByRoutes, filterByBikeRentalStations, filterByBikeParks, filterByCarParks, this.getRoutingService(environment)));
            }
            catch (RoutingValidationException e) {
                places = Collections.emptyList();
            }
            return new SimpleListConnection(places).get(environment);
        };
    }

    @Override
    public DataFetcher<PatternAtStop> departureRow() {
        return environment -> PatternAtStop.fromId(this.getRoutingService(environment), new LegacyGraphQLTypes.LegacyGraphQLQueryTypeDepartureRowArgs(environment.getArguments()).getLegacyGraphQLId());
    }

    @Override
    public DataFetcher<Object> stop() {
        return environment -> this.getRoutingService(environment).getStopForId(FeedScopedId.parseId(new LegacyGraphQLTypes.LegacyGraphQLQueryTypeStopArgs(environment.getArguments()).getLegacyGraphQLId()));
    }

    @Override
    public DataFetcher<Object> station() {
        return environment -> this.getRoutingService(environment).getStationById(FeedScopedId.parseId(new LegacyGraphQLTypes.LegacyGraphQLQueryTypeStationArgs(environment.getArguments()).getLegacyGraphQLId()));
    }

    @Override
    public DataFetcher<Iterable<Object>> stations() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeStationsArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeStationsArgs(environment.getArguments());
            RoutingService routingService = this.getRoutingService(environment);
            if (args.getLegacyGraphQLIds() != null) {
                return StreamSupport.stream(args.getLegacyGraphQLIds().spliterator(), false).map(FeedScopedId::parseId).map(routingService::getStationById).collect(Collectors.toList());
            }
            Stream<Station> stationStream = routingService.getStations().stream();
            if (args.getLegacyGraphQLName() != null) {
                String name = args.getLegacyGraphQLName().toLowerCase(environment.getLocale());
                stationStream = stationStream.filter(station -> station.getName().toLowerCase(environment.getLocale()).startsWith(name));
            }
            return stationStream.collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<Iterable<Route>> routes() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeRoutesArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeRoutesArgs(environment.getArguments());
            RoutingService routingService = this.getRoutingService(environment);
            if (args.getLegacyGraphQLIds() != null) {
                return StreamSupport.stream(args.getLegacyGraphQLIds().spliterator(), false).map(FeedScopedId::parseId).map(routingService::getRouteForId).collect(Collectors.toList());
            }
            Stream<Route> routeStream = routingService.getAllRoutes().stream();
            if (args.getLegacyGraphQLFeeds() != null) {
                List feeds = StreamSupport.stream(args.getLegacyGraphQLFeeds().spliterator(), false).collect(Collectors.toList());
                routeStream = routeStream.filter(route -> feeds.contains(route.getId().getFeedId()));
            }
            if (args.getLegacyGraphQLTransportModes() != null) {
                List modes = StreamSupport.stream(args.getLegacyGraphQLTransportModes().spliterator(), false).map(mode -> TransitMode.valueOf(mode.name())).collect(Collectors.toList());
                routeStream = routeStream.filter(route -> modes.contains((Object)route.getMode()));
            }
            if (args.getLegacyGraphQLName() != null) {
                String name = args.getLegacyGraphQLName().toLowerCase(environment.getLocale());
                routeStream = routeStream.filter(route -> Stream.of(route.getShortName(), route.getLongName()).filter(Objects::nonNull).map(s -> s.toLowerCase(environment.getLocale())).anyMatch(s -> s.startsWith(name)));
            }
            return routeStream.collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<Route> route() {
        return environment -> this.getRoutingService(environment).getRouteForId(FeedScopedId.parseId(new LegacyGraphQLTypes.LegacyGraphQLQueryTypeRouteArgs(environment.getArguments()).getLegacyGraphQLId()));
    }

    @Override
    public DataFetcher<Iterable<Trip>> trips() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeTripsArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeTripsArgs(environment.getArguments());
            Stream<Trip> tripStream = this.getRoutingService(environment).getTripForId().values().stream();
            if (args.getLegacyGraphQLFeeds() != null) {
                List feeds = StreamSupport.stream(args.getLegacyGraphQLFeeds().spliterator(), false).collect(Collectors.toList());
                tripStream = tripStream.filter(trip -> feeds.contains(trip.getId().getFeedId()));
            }
            return tripStream.collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<Trip> trip() {
        return environment -> this.getRoutingService(environment).getTripForId().get(FeedScopedId.parseId(new LegacyGraphQLTypes.LegacyGraphQLQueryTypeTripArgs(environment.getArguments()).getLegacyGraphQLId()));
    }

    @Override
    public DataFetcher<Trip> fuzzyTrip() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeFuzzyTripArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeFuzzyTripArgs(environment.getArguments());
            RoutingService routingService = this.getRoutingService(environment);
            return new GtfsRealtimeFuzzyTripMatcher(routingService).getTrip(routingService.getRouteForId(FeedScopedId.parseId(args.getLegacyGraphQLRoute())), args.getLegacyGraphQLDirection(), args.getLegacyGraphQLTime(), ServiceDate.parseString(args.getLegacyGraphQLDate()));
        };
    }

    @Override
    public DataFetcher<Iterable<TripTimeOnDate>> cancelledTripTimes() {
        return environment -> null;
    }

    @Override
    public DataFetcher<Iterable<TripPattern>> patterns() {
        return environment -> this.getRoutingService(environment).getTripPatterns();
    }

    @Override
    public DataFetcher<TripPattern> pattern() {
        return environment -> this.getRoutingService(environment).getTripPatternForId(FeedScopedId.parseId(new LegacyGraphQLTypes.LegacyGraphQLQueryTypePatternArgs(environment.getArguments()).getLegacyGraphQLId()));
    }

    @Override
    public DataFetcher<Iterable<Object>> clusters() {
        return environment -> Collections.EMPTY_LIST;
    }

    @Override
    public DataFetcher<Object> cluster() {
        return environment -> null;
    }

    @Override
    public DataFetcher<Iterable<TransitAlert>> alerts() {
        return environment -> {
            Collection<TransitAlert> alerts = this.getRoutingService(environment).getTransitAlertService().getAllAlerts();
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeAlertsArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeAlertsArgs(environment.getArguments());
            List severities = args.getLegacyGraphQLSeverityLevel() == null ? null : ((List)args.getLegacyGraphQLSeverityLevel()).stream().map(severity -> severity.name()).collect(Collectors.toList());
            List effects = args.getLegacyGraphQLEffect() == null ? null : ((List)args.getLegacyGraphQLEffect()).stream().map(effect -> effect.name()).collect(Collectors.toList());
            List causes = args.getLegacyGraphQLCause() == null ? null : ((List)args.getLegacyGraphQLCause()).stream().map(cause -> cause.name()).collect(Collectors.toList());
            return alerts.stream().filter(alert -> args.getLegacyGraphQLFeeds() == null || ((List)args.getLegacyGraphQLFeeds()).contains(alert.getFeedId())).filter(alert -> args.getLegacyGraphQLSeverityLevel() == null || severities.contains(LegacyGraphQLSeverityMapper.getLegacyGraphQLSeverity(alert.severity))).filter(alert -> args.getLegacyGraphQLEffect() == null || effects.contains(LegacyGraphQLEffectMapper.getLegacyGraphQLEffect(alert.effect))).filter(alert -> args.getLegacyGraphQLCause() == null || causes.contains(LegacyGraphQLCauseMapper.getLegacyGraphQLCause(alert.cause))).filter(alert -> {
                if (args.getLegacyGraphQLRoute() == null) return true;
                if (!alert.getEntities().stream().filter(entitySelector -> entitySelector instanceof EntitySelector.Route).map(EntitySelector.Route.class::cast).anyMatch(route -> ((List)args.getLegacyGraphQLRoute()).contains(route.routeId.toString()))) return false;
                return true;
            }).filter(alert -> {
                if (args.getLegacyGraphQLStop() == null) return true;
                if (!alert.getEntities().stream().filter(entitySelector -> entitySelector instanceof EntitySelector.Stop).map(EntitySelector.Stop.class::cast).anyMatch(stop -> ((List)args.getLegacyGraphQLStop()).contains(stop.stopId.toString()))) return false;
                return true;
            }).collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<Object> serviceTimeRange() {
        return environment -> new Object();
    }

    @Override
    public DataFetcher<Iterable<VehicleRentalPlace>> bikeRentalStations() {
        return environment -> {
            VehicleRentalStationService vehicleRentalStationService = this.getRoutingService(environment).getVehicleRentalStationService();
            if (vehicleRentalStationService == null) {
                return null;
            }
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeBikeRentalStationsArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeBikeRentalStationsArgs(environment.getArguments());
            if (args.getLegacyGraphQLIds() != null) {
                ArrayListMultimap vehicleRentalStations = (ArrayListMultimap)vehicleRentalStationService.getVehicleRentalPlaces().stream().collect(Multimaps.toMultimap(VehicleRentalPlace::getStationId, station -> station, ArrayListMultimap::create));
                return ((List)args.getLegacyGraphQLIds()).stream().flatMap(id -> vehicleRentalStations.get(id).stream()).collect(Collectors.toList());
            }
            return vehicleRentalStationService.getVehicleRentalPlaces();
        };
    }

    @Override
    public DataFetcher<VehicleRentalPlace> bikeRentalStation() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeBikeRentalStationArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeBikeRentalStationArgs(environment.getArguments());
            VehicleRentalStationService vehicleRentalStationService = this.getRoutingService(environment).getVehicleRentalStationService();
            if (vehicleRentalStationService == null) {
                return null;
            }
            return vehicleRentalStationService.getVehicleRentalPlaces().stream().filter(vehicleRentalStation -> vehicleRentalStation.getStationId().equals(args.getLegacyGraphQLId())).findAny().orElse(null);
        };
    }

    @Override
    public DataFetcher<Iterable<VehicleRentalStation>> vehicleRentalStations() {
        return environment -> {
            VehicleRentalStationService vehicleRentalStationService = this.getRoutingService(environment).getVehicleRentalStationService();
            if (vehicleRentalStationService == null) {
                return null;
            }
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeVehicleRentalStationsArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeVehicleRentalStationsArgs(environment.getArguments());
            if (args.getLegacyGraphQLIds() != null) {
                ArrayListMultimap vehicleRentalStations = (ArrayListMultimap)vehicleRentalStationService.getVehicleRentalStations().stream().collect(Multimaps.toMultimap(station -> station.getId().toString(), station -> station, ArrayListMultimap::create));
                return ((List)args.getLegacyGraphQLIds()).stream().flatMap(id -> vehicleRentalStations.get(id).stream()).collect(Collectors.toList());
            }
            return vehicleRentalStationService.getVehicleRentalStations();
        };
    }

    @Override
    public DataFetcher<VehicleRentalStation> vehicleRentalStation() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeVehicleRentalStationArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeVehicleRentalStationArgs(environment.getArguments());
            VehicleRentalStationService vehicleRentalStationService = this.getRoutingService(environment).getVehicleRentalStationService();
            if (vehicleRentalStationService == null) {
                return null;
            }
            return vehicleRentalStationService.getVehicleRentalStations().stream().filter(vehicleRentalStation -> vehicleRentalStation.getId().toString().equals(args.getLegacyGraphQLId())).findAny().orElse(null);
        };
    }

    @Override
    public DataFetcher<Iterable<VehicleRentalVehicle>> rentalVehicles() {
        return environment -> {
            VehicleRentalStationService vehicleRentalStationService = this.getRoutingService(environment).getVehicleRentalStationService();
            if (vehicleRentalStationService == null) {
                return null;
            }
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeRentalVehiclesArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeRentalVehiclesArgs(environment.getArguments());
            if (args.getLegacyGraphQLIds() != null) {
                ArrayListMultimap vehicleRentalVehicles = (ArrayListMultimap)vehicleRentalStationService.getVehicleRentalVehicles().stream().collect(Multimaps.toMultimap(vehicle -> vehicle.getId().toString(), vehicle -> vehicle, ArrayListMultimap::create));
                return ((List)args.getLegacyGraphQLIds()).stream().flatMap(id -> vehicleRentalVehicles.get(id).stream()).collect(Collectors.toList());
            }
            return vehicleRentalStationService.getVehicleRentalVehicles();
        };
    }

    @Override
    public DataFetcher<VehicleRentalVehicle> rentalVehicle() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeRentalVehicleArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeRentalVehicleArgs(environment.getArguments());
            VehicleRentalStationService vehicleRentalStationService = this.getRoutingService(environment).getVehicleRentalStationService();
            if (vehicleRentalStationService == null) {
                return null;
            }
            return vehicleRentalStationService.getVehicleRentalVehicles().stream().filter(vehicleRentalVehicle -> vehicleRentalVehicle.getId().toString().equals(args.getLegacyGraphQLId())).findAny().orElse(null);
        };
    }

    @Override
    public DataFetcher<Iterable<VehicleParking>> bikeParks() {
        return environment -> {
            VehicleParkingService vehicleParkingService = this.getRoutingService(environment).getVehicleParkingService();
            if (vehicleParkingService == null) {
                return null;
            }
            return vehicleParkingService.getBikeParks().collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<VehicleParking> bikePark() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeBikeParkArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeBikeParkArgs(environment.getArguments());
            VehicleParkingService vehicleParkingService = this.getRoutingService(environment).getVehicleParkingService();
            if (vehicleParkingService == null) {
                return null;
            }
            return vehicleParkingService.getBikeParks().filter(bikePark -> bikePark.getId().getId().equals(args.getLegacyGraphQLId())).findAny().orElse(null);
        };
    }

    @Override
    public DataFetcher<Iterable<VehicleParking>> carParks() {
        return environment -> {
            List idList;
            VehicleParkingService vehicleParkingService = this.getRoutingService(environment).getVehicleParkingService();
            if (vehicleParkingService == null) {
                return null;
            }
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeCarParksArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeCarParksArgs(environment.getArguments());
            if (args.getLegacyGraphQLIds() != null && !(idList = (List)args.getLegacyGraphQLIds()).isEmpty()) {
                Map<String, VehicleParking> carParkMap = vehicleParkingService.getCarParks().collect(Collectors.toMap(station -> station.getId().getId(), station -> station));
                return idList.stream().map(carParkMap::get).collect(Collectors.toList());
            }
            return vehicleParkingService.getCarParks().collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<VehicleParking> carPark() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeCarParkArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeCarParkArgs(environment.getArguments());
            VehicleParkingService vehicleParkingService = this.getRoutingService(environment).getVehicleParkingService();
            if (vehicleParkingService == null) {
                return null;
            }
            return vehicleParkingService.getCarParks().filter(carPark -> carPark.getId().getId().equals(args.getLegacyGraphQLId())).findAny().orElse(null);
        };
    }

    @Override
    public DataFetcher<Iterable<VehicleParking>> vehicleParkings() {
        return environment -> {
            List idList;
            VehicleParkingService vehicleParkingService = this.getRoutingService(environment).getVehicleParkingService();
            if (vehicleParkingService == null) {
                return null;
            }
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeVehicleParkingsArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeVehicleParkingsArgs(environment.getArguments());
            if (args.getLegacyGraphQLIds() != null && !(idList = (List)args.getLegacyGraphQLIds()).isEmpty()) {
                Map<String, VehicleParking> vehicleParkingMap = vehicleParkingService.getVehicleParkings().collect(Collectors.toMap(station -> station.getId().toString(), station -> station));
                return idList.stream().map(vehicleParkingMap::get).collect(Collectors.toList());
            }
            return vehicleParkingService.getVehicleParkings().collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<VehicleParking> vehicleParking() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeVehicleParkingArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeVehicleParkingArgs(environment.getArguments());
            VehicleParkingService vehicleParkingService = this.getRoutingService(environment).getVehicleParkingService();
            if (vehicleParkingService == null) {
                return null;
            }
            FeedScopedId vehicleParkingId = FeedScopedId.parseId(args.getLegacyGraphQLId());
            return vehicleParkingService.getVehicleParkings().filter(vehicleParking -> vehicleParking.getId().equals(vehicleParkingId)).findAny().orElse(null);
        };
    }

    @Override
    public DataFetcher<Object> viewer() {
        return environment -> new Object();
    }

    @Override
    public DataFetcher<DataFetcherResult<RoutingResponse>> plan() {
        return environment -> {
            LegacyGraphQLRequestContext context = (LegacyGraphQLRequestContext)environment.getContext();
            RoutingRequest request = context.getRouter().defaultRoutingRequest.clone();
            CallerWithEnvironment callWith = new CallerWithEnvironment(environment);
            callWith.argument("fromPlace", request::setFromString);
            callWith.argument("toPlace", request::setToString);
            callWith.argument("from", v -> {
                request.from = LegacyGraphQLQueryTypeImpl.toGenericLocation(v);
            });
            callWith.argument("to", v -> {
                request.to = LegacyGraphQLQueryTypeImpl.toGenericLocation(v);
            });
            request.setDateTime((String)environment.getArgument("date"), (String)environment.getArgument("time"), context.getRouter().graph.getTimeZone());
            callWith.argument("wheelchair", request::setWheelchairAccessible);
            callWith.argument("numItineraries", request::setNumItineraries);
            callWith.argument("searchWindow", m -> {
                request.searchWindow = Duration.ofSeconds(m);
            });
            callWith.argument("pageCursor", request::setPageCursor);
            callWith.argument("bikeReluctance", request::setBikeReluctance);
            callWith.argument("bikeWalkingReluctance", request::setBikeWalkingReluctance);
            callWith.argument("carReluctance", request::setCarReluctance);
            callWith.argument("walkReluctance", request::setWalkReluctance);
            callWith.argument("waitReluctance", request::setWaitReluctance);
            callWith.argument("waitAtBeginningFactor", request::setWaitAtBeginningFactor);
            callWith.argument("walkSpeed", v -> {
                request.walkSpeed = v;
            });
            callWith.argument("bikeWalkingSpeed", v -> {
                request.bikeWalkingSpeed = v;
            });
            callWith.argument("bikeSpeed", v -> {
                request.bikeSpeed = v;
            });
            callWith.argument("bikeSwitchTime", v -> {
                request.bikeSwitchTime = v;
            });
            callWith.argument("bikeSwitchCost", v -> {
                request.bikeSwitchCost = v;
            });
            callWith.argument("allowKeepingRentedBicycleAtDestination", v -> {
                request.allowKeepingRentedVehicleAtDestination = v;
            });
            callWith.argument("keepingRentedBicycleAtDestinationCost", v -> {
                request.keepingRentedVehicleAtDestinationCost = v.intValue();
            });
            callWith.argument("modeWeight", v -> request.setTransitReluctanceForMode(v.entrySet().stream().collect(Collectors.toMap(e -> TransitMode.valueOf((String)e.getKey()), e -> (Double)e.getValue()))));
            callWith.argument("debugItineraryFilter", v -> {
                request.itineraryFilters.debug = v;
            });
            callWith.argument("arriveBy", request::setArriveBy);
            request.showIntermediateStops = true;
            callWith.argument("intermediatePlaces", v -> {
                request.intermediatePlaces = v.stream().map(LegacyGraphQLQueryTypeImpl::toGenericLocation).collect(Collectors.toList());
            });
            callWith.argument("preferred.routes", request::setPreferredRoutesFromSting);
            callWith.argument("preferred.otherThanPreferredRoutesPenalty", request::setOtherThanPreferredRoutesPenalty);
            callWith.argument("preferred.agencies", request::setPreferredAgenciesFromString);
            callWith.argument("unpreferred.routes", request::setUnpreferredRoutesFromSting);
            callWith.argument("unpreferred.agencies", request::setUnpreferredAgenciesFromString);
            callWith.argument("walkBoardCost", request::setWalkBoardCost);
            callWith.argument("bikeBoardCost", request::setBikeBoardCost);
            callWith.argument("banned.routes", request::setBannedRoutesFromSting);
            callWith.argument("banned.agencies", request::setBannedAgenciesFromSting);
            callWith.argument("transferPenalty", v -> {
                request.transferCost = v;
            });
            if (environment.getArgument("optimize") != null) {
                BicycleOptimizeType optimize = BicycleOptimizeType.valueOf((String)environment.getArgument("optimize"));
                if (optimize == BicycleOptimizeType.TRIANGLE) {
                    double[] args = new double[3];
                    callWith.argument("triangle.safetyFactor", v -> {
                        args[0] = v;
                    });
                    callWith.argument("triangle.slopeFactor", v -> {
                        args[1] = v;
                    });
                    callWith.argument("triangle.timeFactor", v -> {
                        args[2] = v;
                    });
                    request.setTriangleNormalized(args[0], args[1], args[2]);
                }
                if (optimize == BicycleOptimizeType.TRANSFERS) {
                    optimize = BicycleOptimizeType.QUICK;
                    request.transferCost += 1800;
                }
                if (optimize != null) {
                    request.bicycleOptimizeType = optimize;
                }
            }
            if (LegacyGraphQLQueryTypeImpl.hasArgument(environment, "transportModes")) {
                QualifiedModeSet modes = new QualifiedModeSet("WALK");
                modes.qModes = ((List)environment.getArgument("transportModes")).stream().map(transportMode -> new QualifiedMode((String)transportMode.get("mode") + (String)(transportMode.get("qualifier") == null ? "" : "_" + (String)transportMode.get("qualifier")))).collect(Collectors.toSet());
                request.modes = modes.getRequestModes();
            }
            if (LegacyGraphQLQueryTypeImpl.hasArgument(environment, "allowedTicketTypes")) {
                // empty if block
            }
            if (LegacyGraphQLQueryTypeImpl.hasArgument(environment, "allowedBikeRentalNetworks")) {
                // empty if block
            }
            if (request.vehicleRental && !LegacyGraphQLQueryTypeImpl.hasArgument(environment, "bikeSpeed")) {
                request.bikeSpeed = 4.3;
            }
            callWith.argument("boardSlack", v -> {
                request.boardSlack = v;
            });
            callWith.argument("alightSlack", v -> {
                request.alightSlack = v;
            });
            callWith.argument("minTransferTime", v -> {
                request.transferSlack = v;
            });
            callWith.argument("nonpreferredTransferPenalty", v -> {
                request.nonpreferredTransferCost = v;
            });
            callWith.argument("maxTransfers", v -> {
                request.maxTransfers = v;
            });
            request.useVehicleRentalAvailabilityInformation = request.isTripPlannedForNow();
            callWith.argument("startTransitStopId", v -> {
                request.startingTransitStopId = FeedScopedId.parseId(v);
            });
            callWith.argument("startTransitTripId", v -> {
                request.startingTransitTripId = FeedScopedId.parseId(v);
            });
            callWith.argument("ignoreRealtimeUpdates", v -> {
                request.ignoreRealtimeUpdates = v;
            });
            callWith.argument("disableRemainingWeightHeuristic", v -> {
                request.disableRemainingWeightHeuristic = v;
            });
            callWith.argument("locale", v -> {
                request.locale = ResourceBundleSingleton.INSTANCE.getLocale((String)v);
            });
            RoutingResponse res = context.getRoutingService().route(request, context.getRouter());
            return DataFetcherResult.newResult().data((Object)res).localContext(Map.of("locale", request.locale)).build();
        };
    }

    private RoutingService getRoutingService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).getRoutingService();
    }

    private static <T> void call(Map<String, T> m, String name, Consumer<T> consumer) {
        if (!name.contains(".")) {
            if (LegacyGraphQLQueryTypeImpl.hasArgument(m, name)) {
                T v = m.get(name);
                consumer.accept(v);
            }
        } else {
            String[] parts = name.split("\\.");
            if (LegacyGraphQLQueryTypeImpl.hasArgument(m, parts[0])) {
                Map nm = (Map)m.get(parts[0]);
                LegacyGraphQLQueryTypeImpl.call(nm, String.join((CharSequence)".", Arrays.copyOfRange(parts, 1, parts.length)), consumer);
            }
        }
    }

    private static <T> void call(DataFetchingEnvironment environment, String name, Consumer<T> consumer) {
        if (!name.contains(".")) {
            if (LegacyGraphQLQueryTypeImpl.hasArgument(environment, name)) {
                consumer.accept(environment.getArgument(name));
            }
        } else {
            String[] parts = name.split("\\.");
            if (LegacyGraphQLQueryTypeImpl.hasArgument(environment, parts[0])) {
                Map nm = (Map)environment.getArgument(parts[0]);
                LegacyGraphQLQueryTypeImpl.call(nm, String.join((CharSequence)".", Arrays.copyOfRange(parts, 1, parts.length)), consumer);
            }
        }
    }

    private static GenericLocation toGenericLocation(Map<String, Object> m) {
        double lat = (Double)m.get("lat");
        double lng = (Double)m.get("lon");
        String address = (String)m.get("address");
        Object locationSlack = null;
        if (address != null) {
            return new GenericLocation(address, null, lat, lng);
        }
        return new GenericLocation(lat, lng);
    }

    private static boolean hasArgument(DataFetchingEnvironment environment, String name) {
        return environment.containsArgument(name) && environment.getArgument(name) != null;
    }

    public static <T> boolean hasArgument(Map<String, T> m, String name) {
        return m.containsKey(name) && m.get(name) != null;
    }

    private static class CallerWithEnvironment {
        private final DataFetchingEnvironment environment;

        public CallerWithEnvironment(DataFetchingEnvironment e) {
            this.environment = e;
        }

        private <T> void argument(String name, Consumer<T> consumer) {
            LegacyGraphQLQueryTypeImpl.call(this.environment, name, consumer);
        }
    }
}

