/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Geometry;
import org.opentripplanner.api.mapping.ServiceDateMapper;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLRequestContext;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.StopArrival;
import org.opentripplanner.model.plan.WalkStep;
import org.opentripplanner.routing.RoutingService;

public class LegacyGraphQLLegImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLLeg {
    @Override
    public DataFetcher<Long> startTime() {
        return environment -> this.getSource(environment).getStartTime().getTime().getTime();
    }

    @Override
    public DataFetcher<Long> endTime() {
        return environment -> this.getSource(environment).getEndTime().getTime().getTime();
    }

    @Override
    public DataFetcher<Integer> departureDelay() {
        return environment -> this.getSource(environment).getDepartureDelay();
    }

    @Override
    public DataFetcher<Integer> arrivalDelay() {
        return environment -> this.getSource(environment).getArrivalDelay();
    }

    @Override
    public DataFetcher<String> mode() {
        return environment -> this.getSource(environment).getMode().name();
    }

    @Override
    public DataFetcher<Double> duration() {
        return environment -> this.getSource(environment).getDuration();
    }

    @Override
    public DataFetcher<Integer> generalizedCost() {
        return environment -> this.getSource(environment).getGeneralizedCost();
    }

    @Override
    public DataFetcher<Geometry> legGeometry() {
        return environment -> this.getSource(environment).getLegGeometry();
    }

    @Override
    public DataFetcher<Agency> agency() {
        return environment -> this.getSource(environment).getAgency();
    }

    @Override
    public DataFetcher<Boolean> realTime() {
        return environment -> this.getSource(environment).getRealTime();
    }

    @Override
    public DataFetcher<String> realtimeState() {
        return environment -> null;
    }

    @Override
    public DataFetcher<Double> distance() {
        return environment -> this.getSource(environment).getDistanceMeters();
    }

    @Override
    public DataFetcher<Boolean> transitLeg() {
        return environment -> this.getSource(environment).isTransitLeg();
    }

    @Override
    public DataFetcher<Boolean> walkingBike() {
        return environment -> this.getSource(environment).getWalkingBike();
    }

    @Override
    public DataFetcher<Boolean> rentedBike() {
        return environment -> this.getSource(environment).getRentedVehicle();
    }

    @Override
    public DataFetcher<StopArrival> from() {
        return environment -> {
            Leg source = this.getSource(environment);
            return new StopArrival(source.getFrom(), source.getStartTime(), source.getStartTime(), source.getBoardStopPosInPattern(), source.getBoardingGtfsStopSequence());
        };
    }

    @Override
    public DataFetcher<StopArrival> to() {
        return environment -> {
            Leg source = this.getSource(environment);
            return new StopArrival(source.getTo(), source.getEndTime(), source.getEndTime(), source.getAlightStopPosInPattern(), source.getAlightGtfsStopSequence());
        };
    }

    @Override
    public DataFetcher<Route> route() {
        return environment -> this.getSource(environment).getRoute();
    }

    @Override
    public DataFetcher<Trip> trip() {
        return environment -> this.getSource(environment).getTrip();
    }

    @Override
    public DataFetcher<String> serviceDate() {
        return environment -> ServiceDateMapper.mapToApi(this.getSource(environment).getServiceDate());
    }

    @Override
    public DataFetcher<Iterable<Object>> intermediateStops() {
        return environment -> {
            List<StopArrival> intermediateStops = this.getSource(environment).getIntermediateStops();
            if (intermediateStops == null) {
                return null;
            }
            return intermediateStops.stream().map(intermediateStop -> intermediateStop.place.stop).filter(Objects::nonNull).collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<Iterable<StopArrival>> intermediatePlaces() {
        return environment -> this.getSource(environment).getIntermediateStops();
    }

    @Override
    public DataFetcher<Boolean> intermediatePlace() {
        return environment -> false;
    }

    @Override
    public DataFetcher<Iterable<WalkStep>> steps() {
        return environment -> this.getSource(environment).getWalkSteps();
    }

    @Override
    public DataFetcher<String> pickupType() {
        return environment -> {
            if (this.getSource(environment).getBoardRule() == null) {
                return PickDrop.SCHEDULED.name();
            }
            return this.getSource(environment).getBoardRule().name();
        };
    }

    @Override
    public DataFetcher<String> dropoffType() {
        return environment -> {
            if (this.getSource(environment).getAlightRule() == null) {
                return PickDrop.SCHEDULED.name();
            }
            return this.getSource(environment).getAlightRule().name();
        };
    }

    @Override
    public DataFetcher<Boolean> interlineWithPreviousLeg() {
        return environment -> this.getSource(environment).isInterlinedWithPreviousLeg();
    }

    @Override
    public DataFetcher<BookingInfo> dropOffBookingInfo() {
        return environment -> this.getSource(environment).getDropOffBookingInfo();
    }

    @Override
    public DataFetcher<BookingInfo> pickupBookingInfo() {
        return environment -> this.getSource(environment).getPickupBookingInfo();
    }

    private RoutingService getRoutingService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).getRoutingService();
    }

    private Leg getSource(DataFetchingEnvironment environment) {
        return (Leg)environment.getSource();
    }
}

