/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.model.SystemNotice;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.core.Fare;

public class LegacyGraphQLItineraryImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLItinerary {
    @Override
    public DataFetcher<Long> startTime() {
        return environment -> this.getSource(environment).startTime().getTime().getTime();
    }

    @Override
    public DataFetcher<Long> endTime() {
        return environment -> this.getSource(environment).endTime().getTime().getTime();
    }

    @Override
    public DataFetcher<Long> duration() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).durationSeconds;
    }

    @Override
    public DataFetcher<Integer> generalizedCost() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).generalizedCost;
    }

    @Override
    public DataFetcher<Long> waitingTime() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).waitingTimeSeconds;
    }

    @Override
    public DataFetcher<Long> walkTime() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).nonTransitTimeSeconds;
    }

    @Override
    public DataFetcher<Double> walkDistance() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).nonTransitDistanceMeters;
    }

    @Override
    public DataFetcher<Iterable<Leg>> legs() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).legs;
    }

    @Override
    public DataFetcher<Iterable<Map<String, Object>>> fares() {
        return environment -> {
            Fare fare = this.getSource((DataFetchingEnvironment)environment).fare;
            if (fare == null) {
                return null;
            }
            List results = fare.fare.keySet().stream().map(fareKey -> {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("name", fareKey.name());
                result.put("fare", fare.getFare((Fare.FareType)fareKey));
                result.put("details", fare.getDetails((Fare.FareType)fareKey));
                return result;
            }).collect(Collectors.toList());
            return results;
        };
    }

    @Override
    public DataFetcher<Double> elevationGained() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).elevationGained;
    }

    @Override
    public DataFetcher<Double> elevationLost() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).elevationLost;
    }

    @Override
    public DataFetcher<Boolean> arrivedAtDestinationWithRentedBicycle() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).arrivedAtDestinationWithRentedVehicle;
    }

    @Override
    public DataFetcher<Iterable<SystemNotice>> systemNotices() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).systemNotices;
    }

    private Itinerary getSource(DataFetchingEnvironment environment) {
        return (Itinerary)environment.getSource();
    }
}

