/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStationUris;

public class LegacyGraphQLBikeRentalStationImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLBikeRentalStation {
    final String STATE_ON = "Station on";
    final String STATE_OFF = "Station off";

    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> new Relay.ResolvedGlobalId("BikeRentalStation", this.getSource(environment).getId().toString());
    }

    @Override
    public DataFetcher<String> stationId() {
        return environment -> this.getSource(environment).getStationId();
    }

    @Override
    public DataFetcher<String> name() {
        return environment -> this.getSource(environment).getName().toString(environment.getLocale());
    }

    @Override
    public DataFetcher<Integer> bikesAvailable() {
        return environment -> this.getSource(environment).getVehiclesAvailable();
    }

    @Override
    public DataFetcher<Integer> spacesAvailable() {
        return environment -> this.getSource(environment).getSpacesAvailable();
    }

    @Override
    public DataFetcher<String> state() {
        return environment -> {
            VehicleRentalPlace rentalPlace = this.getSource(environment);
            if (rentalPlace.isFloatingVehicle() && rentalPlace.isAllowPickup()) {
                return "Station on";
            }
            if (rentalPlace.isAllowDropoff() && rentalPlace.isAllowPickup()) {
                return "Station on";
            }
            return "Station off";
        };
    }

    @Override
    public DataFetcher<Boolean> realtime() {
        return environment -> this.getSource(environment).isRealTimeData();
    }

    @Override
    public DataFetcher<Boolean> allowDropoff() {
        return environment -> this.getSource(environment).isAllowDropoff();
    }

    @Override
    public DataFetcher<Boolean> allowDropoffNow() {
        return environment -> this.getSource(environment).allowDropoffNow();
    }

    @Override
    public DataFetcher<Boolean> allowPickup() {
        return environment -> this.getSource(environment).isAllowPickup();
    }

    @Override
    public DataFetcher<Boolean> allowPickupNow() {
        return environment -> this.getSource(environment).allowPickupNow();
    }

    @Override
    public DataFetcher<Iterable<String>> networks() {
        return environment -> List.of(this.getSource(environment).getNetwork());
    }

    @Override
    public DataFetcher<Double> lon() {
        return environment -> this.getSource(environment).getLongitude();
    }

    @Override
    public DataFetcher<Double> lat() {
        return environment -> this.getSource(environment).getLatitude();
    }

    @Override
    public DataFetcher<Boolean> allowOverloading() {
        return environment -> this.getSource(environment).isAllowOverloading();
    }

    @Override
    public DataFetcher<Integer> capacity() {
        return environment -> this.getSource(environment).getCapacity();
    }

    @Override
    public DataFetcher<Boolean> operative() {
        return environment -> this.getSource(environment).isAllowPickup() && this.getSource(environment).isAllowDropoff();
    }

    @Override
    public DataFetcher<VehicleRentalStationUris> rentalUris() {
        return environment -> this.getSource(environment).getRentalUris();
    }

    private VehicleRentalPlace getSource(DataFetchingEnvironment environment) {
        return (VehicleRentalPlace)environment.getSource();
    }
}

