/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingSpaces;

public class LegacyGraphQLBikeParkImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLBikePark {
    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> new Relay.ResolvedGlobalId("BikePark", this.getSource(environment).getId().toString());
    }

    @Override
    public DataFetcher<String> bikeParkId() {
        return environment -> this.getSource(environment).getId().getId();
    }

    @Override
    public DataFetcher<String> name() {
        return environment -> this.getSource(environment).getName().toString();
    }

    @Override
    public DataFetcher<Integer> spacesAvailable() {
        return environment -> {
            VehicleParkingSpaces availability = this.getSource(environment).getAvailability();
            if (availability == null) {
                return null;
            }
            return availability.getBicycleSpaces();
        };
    }

    @Override
    public DataFetcher<Boolean> realtime() {
        return environment -> this.getSource(environment).hasRealTimeData();
    }

    @Override
    public DataFetcher<Double> lon() {
        return environment -> this.getSource(environment).getX();
    }

    @Override
    public DataFetcher<Double> lat() {
        return environment -> this.getSource(environment).getY();
    }

    @Override
    public DataFetcher<Iterable<String>> tags() {
        return environment -> this.getSource(environment).getTags();
    }

    @Override
    public DataFetcher<Iterable<Object>> openingHours() {
        return environment -> null;
    }

    private VehicleParking getSource(DataFetchingEnvironment environment) {
        return (VehicleParking)environment.getSource();
    }
}

