/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLRequestContext;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.ext.legacygraphqlapi.mapping.LegacyGraphQLCauseMapper;
import org.opentripplanner.ext.legacygraphqlapi.mapping.LegacyGraphQLEffectMapper;
import org.opentripplanner.ext.legacygraphqlapi.mapping.LegacyGraphQLSeverityMapper;
import org.opentripplanner.ext.legacygraphqlapi.model.LegacyGraphQLRouteTypeModel;
import org.opentripplanner.ext.legacygraphqlapi.model.LegacyGraphQLStopOnRouteModel;
import org.opentripplanner.ext.legacygraphqlapi.model.LegacyGraphQLStopOnTripModel;
import org.opentripplanner.ext.legacygraphqlapi.model.LegacyGraphQLUnknownModel;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.TripPattern;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.util.I18NString;
import org.opentripplanner.util.TranslatedString;

public class LegacyGraphQLAlertImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLAlert {
    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> new Relay.ResolvedGlobalId("Alert", this.getSource(environment).getId());
    }

    @Override
    public DataFetcher<Integer> alertHash() {
        return environment -> {
            TransitAlert alert = this.getSource(environment);
            return Objects.hash(new Object[]{alert.alertDescriptionText, alert.alertHeaderText, alert.alertUrl, alert.cause, alert.effect, alert.severity});
        };
    }

    @Override
    public DataFetcher<String> feed() {
        return environment -> this.getSource(environment).getFeedId();
    }

    @Override
    public DataFetcher<Agency> agency() {
        return environment -> this.getSource(environment).getEntities().stream().filter(entitySelector -> entitySelector instanceof EntitySelector.Agency).findAny().map(EntitySelector.Agency.class::cast).map(entitySelector -> this.getRoutingService(environment).getAgencyForId(entitySelector.agencyId)).orElse(null);
    }

    @Override
    public DataFetcher<Route> route() {
        return environment -> this.getSource(environment).getEntities().stream().filter(entitySelector -> entitySelector instanceof EntitySelector.Route).findAny().map(EntitySelector.Route.class::cast).map(entitySelector -> this.getRoutingService(environment).getRouteForId(entitySelector.routeId)).orElse(null);
    }

    @Override
    public DataFetcher<Trip> trip() {
        return environment -> this.getSource(environment).getEntities().stream().filter(entitySelector -> entitySelector instanceof EntitySelector.Trip).findAny().map(EntitySelector.Trip.class::cast).map(entitySelector -> this.getRoutingService(environment).getTripForId().get(entitySelector.tripId)).orElse(null);
    }

    @Override
    public DataFetcher<Object> stop() {
        return environment -> this.getSource(environment).getEntities().stream().filter(entitySelector -> entitySelector instanceof EntitySelector.Stop).findAny().map(EntitySelector.Stop.class::cast).map(entitySelector -> this.getRoutingService(environment).getStopForId(entitySelector.stopId)).orElse(null);
    }

    @Override
    public DataFetcher<Iterable<TripPattern>> patterns() {
        return environment -> Collections.emptyList();
    }

    @Override
    public DataFetcher<String> alertHeaderText() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).alertHeaderText.toString(environment.getLocale());
    }

    @Override
    public DataFetcher<Iterable<Map.Entry<String, String>>> alertHeaderTextTranslations() {
        return environment -> {
            I18NString text = this.getSource((DataFetchingEnvironment)environment).alertHeaderText;
            return this.getTranslations(text);
        };
    }

    @Override
    public DataFetcher<String> alertDescriptionText() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).alertDescriptionText.toString(environment.getLocale());
    }

    @Override
    public DataFetcher<Iterable<Map.Entry<String, String>>> alertDescriptionTextTranslations() {
        return environment -> {
            I18NString text = this.getSource((DataFetchingEnvironment)environment).alertDescriptionText;
            return this.getTranslations(text);
        };
    }

    @Override
    public DataFetcher<String> alertUrl() {
        return environment -> {
            I18NString alertUrl = this.getSource((DataFetchingEnvironment)environment).alertUrl;
            return alertUrl == null ? null : alertUrl.toString(environment.getLocale());
        };
    }

    @Override
    public DataFetcher<Iterable<Map.Entry<String, String>>> alertUrlTranslations() {
        return environment -> {
            I18NString url = this.getSource((DataFetchingEnvironment)environment).alertUrl;
            return this.getTranslations(url);
        };
    }

    @Override
    public DataFetcher<String> alertEffect() {
        return environment -> LegacyGraphQLEffectMapper.getLegacyGraphQLEffect(this.getSource((DataFetchingEnvironment)environment).effect);
    }

    @Override
    public DataFetcher<String> alertCause() {
        return environment -> LegacyGraphQLCauseMapper.getLegacyGraphQLCause(this.getSource((DataFetchingEnvironment)environment).cause);
    }

    @Override
    public DataFetcher<String> alertSeverityLevel() {
        return environment -> LegacyGraphQLSeverityMapper.getLegacyGraphQLSeverity(this.getSource((DataFetchingEnvironment)environment).severity);
    }

    @Override
    public DataFetcher<Long> effectiveStartDate() {
        return environment -> {
            Date effectiveStartDate = this.getSource(environment).getEffectiveStartDate();
            if (effectiveStartDate == null) {
                return null;
            }
            return effectiveStartDate.getTime() / 1000L;
        };
    }

    @Override
    public DataFetcher<Long> effectiveEndDate() {
        return environment -> {
            Date effectiveEndDate = this.getSource(environment).getEffectiveEndDate();
            if (effectiveEndDate == null) {
                return null;
            }
            return effectiveEndDate.getTime() / 1000L;
        };
    }

    @Override
    public DataFetcher<Iterable<Object>> entities() {
        return environment -> this.getSource(environment).getEntities().stream().map(entitySelector -> {
            if (entitySelector instanceof EntitySelector.Stop) {
                FeedScopedId id = ((EntitySelector.Stop)entitySelector).stopId;
                StopLocation stop = this.getRoutingService(environment).getStopForId(id);
                return List.of(this.getAlertEntityOrUnknown(stop, id.toString(), "stop"));
            }
            if (entitySelector instanceof EntitySelector.Agency) {
                FeedScopedId id = ((EntitySelector.Agency)entitySelector).agencyId;
                Agency agency = this.getRoutingService(environment).getAgencyForId(id);
                return List.of(this.getAlertEntityOrUnknown(agency, id.toString(), "agency"));
            }
            if (entitySelector instanceof EntitySelector.Route) {
                FeedScopedId id = ((EntitySelector.Route)entitySelector).routeId;
                Route route = this.getRoutingService(environment).getRouteForId(id);
                return List.of(this.getAlertEntityOrUnknown(route, id.toString(), "route"));
            }
            if (entitySelector instanceof EntitySelector.Trip) {
                FeedScopedId id = ((EntitySelector.Trip)entitySelector).tripId;
                Trip trip = this.getRoutingService(environment).getTripForId().get(id);
                return List.of(this.getAlertEntityOrUnknown(trip, id.toString(), "trip"));
            }
            if (entitySelector instanceof EntitySelector.StopAndRoute) {
                EntitySelector.StopAndRouteOrTripKey stopAndRouteKey = ((EntitySelector.StopAndRoute)entitySelector).stopAndRoute;
                FeedScopedId stopId = stopAndRouteKey.stop;
                FeedScopedId routeId = stopAndRouteKey.routeOrTrip;
                StopLocation stop = this.getRoutingService(environment).getStopForId(stopId);
                Route route = this.getRoutingService(environment).getRouteForId(routeId);
                return List.of(stop != null && route != null ? new LegacyGraphQLStopOnRouteModel(stop, route) : this.getUnknownForAlertEntityPair(stop, route, stopId.toString(), routeId.toString(), "stop", "route"));
            }
            if (entitySelector instanceof EntitySelector.StopAndTrip) {
                EntitySelector.StopAndRouteOrTripKey stopAndTripKey = ((EntitySelector.StopAndTrip)entitySelector).stopAndTrip;
                FeedScopedId stopId = stopAndTripKey.stop;
                FeedScopedId tripId = stopAndTripKey.routeOrTrip;
                StopLocation stop = this.getRoutingService(environment).getStopForId(stopId);
                Trip trip = this.getRoutingService(environment).getTripForId().get(tripId);
                return List.of(stop != null && trip != null ? new LegacyGraphQLStopOnTripModel(stop, trip) : this.getUnknownForAlertEntityPair(stop, trip, stopId.toString(), tripId.toString(), "stop", "trip"));
            }
            if (entitySelector instanceof EntitySelector.RouteTypeAndAgency) {
                FeedScopedId agencyId = ((EntitySelector.RouteTypeAndAgency)entitySelector).agencyId;
                int routeType = ((EntitySelector.RouteTypeAndAgency)entitySelector).routeType;
                Agency agency = this.getRoutingService(environment).getAgencyForId(agencyId);
                return List.of(agency != null ? new LegacyGraphQLRouteTypeModel(agency, routeType, agency.getId().getFeedId()) : this.getUnknownForAlertEntityPair(agency, routeType, agency.toString(), Integer.toString(routeType), "agency", "route type"));
            }
            if (entitySelector instanceof EntitySelector.RouteType) {
                int routeType = ((EntitySelector.RouteType)entitySelector).routeType;
                String feedId = ((EntitySelector.RouteType)entitySelector).feedId;
                return List.of(new LegacyGraphQLRouteTypeModel(null, routeType, feedId));
            }
            if (entitySelector instanceof EntitySelector.DirectionAndRoute) {
                int directionId = ((EntitySelector.DirectionAndRoute)entitySelector).directionId;
                FeedScopedId routeId = ((EntitySelector.DirectionAndRoute)entitySelector).routeId;
                Route route = this.getRoutingService(environment).getRouteForId(routeId);
                return route != null ? this.getRoutingService(environment).getPatternsForRoute().get((Object)route).stream().filter(pattern -> pattern.getDirection().gtfsCode == directionId).collect(Collectors.toList()) : List.of(this.getUnknownForAlertEntityPair(route, directionId, route.toString(), Integer.toString(directionId), "route", "direction"));
            }
            if (entitySelector instanceof EntitySelector.Unknown) {
                return List.of(new LegacyGraphQLUnknownModel(((EntitySelector.Unknown)entitySelector).description));
            }
            return List.of();
        }).flatMap(list -> list.stream()).map(Object.class::cast).collect(Collectors.toList());
    }

    private Object getAlertEntityOrUnknown(Object entity, String id, String type) {
        if (entity != null) {
            return entity;
        }
        return new LegacyGraphQLUnknownModel(String.format("Alert's entity selector was %s with id %s but the %s doesn't exist.", type, id, type));
    }

    private Object getUnknownForAlertEntityPair(Object entityA, Object entityB, String idA, String idB, String typeA, String typeB) {
        if (entityA == null && entityB == null) {
            return new LegacyGraphQLUnknownModel(String.format("Alert's entity selector was %s with id %s and %s with id %s but the %s and %s don't exist.", typeA, idA, typeB, idB, typeA, typeB));
        }
        if (entityA == null) {
            return new LegacyGraphQLUnknownModel(String.format("Alert's entity selector was %s with id %s and %s with id %s but the %s doesn't exist.", typeA, idA, typeB, idB, typeA));
        }
        return new LegacyGraphQLUnknownModel(String.format("Alert's entity selector was %s with id %s and %s with id %s but the %s doesn't exist.", typeA, idA, typeB, idB, typeB));
    }

    private RoutingService getRoutingService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).getRoutingService();
    }

    private TransitAlert getSource(DataFetchingEnvironment environment) {
        return (TransitAlert)environment.getSource();
    }

    private Iterable<Map.Entry<String, String>> getTranslations(I18NString text) {
        return text instanceof TranslatedString ? ((TranslatedString)text).getTranslations() : Collections.emptyList();
    }
}

