/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ExecutionResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.opentripplanner.api.json.GraphQLResponseSerializer;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLIndex;
import org.opentripplanner.standalone.server.OTPServer;
import org.opentripplanner.standalone.server.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/routers/{ignoreRouterId}/index/graphql")
@Produces(value={"application/json"})
public class LegacyGraphQLAPI {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyGraphQLAPI.class);
    private final Router router;
    private final ObjectMapper deserializer = new ObjectMapper();
    @Deprecated
    @PathParam(value="ignoreRouterId")
    private String ignoreRouterId;

    public LegacyGraphQLAPI(@Context OTPServer otpServer) {
        this.router = otpServer.getRouter();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response getGraphQL(HashMap<String, Object> queryParameters, @HeaderParam(value="OTPTimeout") @DefaultValue(value="30000") int timeout, @HeaderParam(value="OTPMaxResolves") @DefaultValue(value="1000000") int maxResolves, @Context HttpHeaders headers) {
        Map<String, Object> variables;
        if (queryParameters == null || !queryParameters.containsKey("query")) {
            LOG.debug("No query found in body");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)"No query found in body").build();
        }
        Locale locale = headers.getAcceptableLanguages().size() > 0 ? (Locale)headers.getAcceptableLanguages().get(0) : this.router.defaultRoutingRequest.locale;
        String query = (String)queryParameters.get("query");
        Object queryVariables = queryParameters.getOrDefault("variables", null);
        String operationName = queryParameters.getOrDefault("operationName", null);
        if (queryVariables instanceof Map) {
            variables = queryVariables;
        } else if (queryVariables instanceof String && !((String)queryVariables).isEmpty()) {
            try {
                variables = (Map)this.deserializer.readValue((String)queryVariables, Map.class);
            }
            catch (IOException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)"Variables must be a valid json object").build();
            }
        } else {
            variables = new HashMap<String, Object>();
        }
        return LegacyGraphQLIndex.getGraphQLResponse(query, this.router, variables, operationName, maxResolves, timeout, locale);
    }

    @POST
    @Consumes(value={"application/graphql"})
    public Response getGraphQL(String query, @HeaderParam(value="OTPTimeout") @DefaultValue(value="30000") int timeout, @HeaderParam(value="OTPMaxResolves") @DefaultValue(value="1000000") int maxResolves, @Context HttpHeaders headers) {
        Locale locale = headers.getAcceptableLanguages().size() > 0 ? (Locale)headers.getAcceptableLanguages().get(0) : this.router.defaultRoutingRequest.locale;
        return LegacyGraphQLIndex.getGraphQLResponse(query, this.router, null, null, maxResolves, timeout, locale);
    }

    @POST
    @Path(value="/batch")
    @Consumes(value={"application/json"})
    public Response getGraphQLBatch(List<HashMap<String, Object>> queries, @HeaderParam(value="OTPTimeout") @DefaultValue(value="30000") int timeout, @HeaderParam(value="OTPMaxResolves") @DefaultValue(value="1000000") int maxResolves, @Context HttpHeaders headers) {
        ArrayList<Callable<ExecutionResult>> futures = new ArrayList<Callable<ExecutionResult>>();
        Locale locale = headers.getAcceptableLanguages().size() > 0 ? (Locale)headers.getAcceptableLanguages().get(0) : this.router.defaultRoutingRequest.locale;
        for (HashMap<String, Object> query : queries) {
            Map variables;
            if (query.get("variables") instanceof Map) {
                variables = (Map)query.get("variables");
            } else if (query.get("variables") instanceof String && ((String)query.get("variables")).length() > 0) {
                try {
                    variables = (Map)this.deserializer.readValue((String)query.get("variables"), Map.class);
                }
                catch (IOException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)"Variables must be a valid json object").build();
                }
            } else {
                variables = null;
            }
            String operationName = query.getOrDefault("operationName", null);
            futures.add(() -> LegacyGraphQLIndex.getGraphQLExecutionResult((String)query.get("query"), this.router, variables, operationName, maxResolves, timeout, locale));
        }
        try {
            List<Future<ExecutionResult>> results = LegacyGraphQLIndex.threadPool.invokeAll(futures);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)GraphQLResponseSerializer.serializeBatch(queries, results)).build();
        }
        catch (InterruptedException e) {
            LOG.error("Batch query interrupted", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

