/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher;

import java.io.File;
import java.util.ArrayList;

public class SetupResult {
    private final File configDataDir;
    private final boolean buildStreet;
    private final boolean buildTransit;
    private final boolean saveGraph;
    private final boolean serveGraph;

    public SetupResult(File configDataDir, boolean buildStreet, boolean buildTransit, boolean saveGraph, boolean serveGraph) {
        this.configDataDir = configDataDir;
        this.buildStreet = buildStreet;
        this.buildTransit = buildTransit;
        this.saveGraph = saveGraph;
        this.serveGraph = serveGraph;
    }

    File configDataDir() {
        return this.configDataDir;
    }

    boolean buildStreet() {
        return this.buildStreet;
    }

    boolean buildTransit() {
        return this.buildTransit;
    }

    boolean buildAll() {
        return this.buildStreet && this.buildTransit;
    }

    boolean buildStreetOnly() {
        return this.buildStreet && !this.buildTransit;
    }

    boolean saveGraph() {
        return this.saveGraph;
    }

    boolean serveGraph() {
        return this.serveGraph;
    }

    public String toString() {
        return "SetupResult{configDataDir=" + this.configDataDir.getAbsolutePath() + (this.buildStreet ? ", buildStreet" : "") + (this.buildTransit ? ", buildTransit" : "") + (this.saveGraph ? ", saveGraph" : "") + (this.serveGraph ? ", serveGraph" : "") + "}";
    }

    String[] asOtpArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.buildAll()) {
            args.add("--build");
        } else if (this.buildStreet) {
            args.add("--buildStreet");
        } else if (this.buildTransit) {
            args.add("--loadStreet");
        } else {
            args.add("--load");
        }
        if (this.saveGraph && (this.buildTransit || this.buildStreet)) {
            args.add("--save");
        }
        if (this.serveGraph && !this.buildStreetOnly()) {
            args.add("--serve");
        }
        args.add(this.configDataDir.getAbsolutePath());
        return args.toArray(new String[0]);
    }

    public String toCliString() {
        return String.join((CharSequence)" ", this.asOtpArgs());
    }
}

