/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.interactivelauncher;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.opentripplanner.ext.interactivelauncher.DebugLoggingSupport;
import org.opentripplanner.ext.interactivelauncher.SearchForOtpConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Model
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Model.class);
    private static final File MODEL_FILE = new File("interactive_otp_main.json");
    private final Map<String, Boolean> debugLogging = new HashMap<String, Boolean>();
    @JsonIgnore
    private transient Consumer<String> commandLineChange;
    private String rootDirectory = null;
    private String dataSource = null;
    private boolean buildStreet = false;
    private boolean buildTransit = true;
    private boolean saveGraph = false;
    private boolean serveGraph = true;

    public Model() {
        this.setupListOfDebugLoggers();
    }

    public static Model load() {
        return MODEL_FILE.exists() ? Model.readFromFile() : new Model();
    }

    private static Model readFromFile() {
        try {
            return (Model)new ObjectMapper().readValue(MODEL_FILE, Model.class);
        }
        catch (IOException e) {
            System.err.println("Unable to read the InteractiveOtpMain state cache. If the model changed this is expected, and it will work next time. Cause: " + e.getMessage());
            return new Model();
        }
    }

    public void subscribeCmdLineUpdates(Consumer<String> commandLineChange) {
        this.commandLineChange = commandLineChange;
    }

    public String getRootDirectory() {
        return this.rootDirectory == null ? System.getProperty("user.dir") : this.rootDirectory;
    }

    public void setRootDirectory(String rootDirectory) {
        if (rootDirectory != null) {
            this.rootDirectory = rootDirectory;
        }
        this.notifyChangeListener();
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
        this.notifyChangeListener();
    }

    @JsonIgnore
    public List<String> getDataSourceOptions() {
        ArrayList<String> dataSourceOptions = new ArrayList<String>();
        File rootDir = new File(this.getRootDirectory());
        List<File> dirs = SearchForOtpConfig.search(rootDir);
        int length = rootDir.getAbsolutePath().length() + 1;
        for (File dir : dirs) {
            String path = dir.getAbsolutePath();
            if (path.length() <= length) {
                LOG.warn("The root directory contains a config file, choose the parent directory or delete the config file.");
                continue;
            }
            dataSourceOptions.add(path.substring(length));
        }
        return dataSourceOptions;
    }

    public boolean isBuildStreet() {
        return this.buildStreet;
    }

    public void setBuildStreet(boolean buildStreet) {
        this.buildStreet = buildStreet;
        this.notifyChangeListener();
    }

    public boolean isBuildTransit() {
        return this.buildTransit;
    }

    public void setBuildTransit(boolean buildTransit) {
        this.buildTransit = buildTransit;
        this.notifyChangeListener();
    }

    public boolean isSaveGraph() {
        return this.saveGraph;
    }

    public void setSaveGraph(boolean saveGraph) {
        this.saveGraph = saveGraph;
        this.notifyChangeListener();
    }

    public boolean isServeGraph() {
        return this.serveGraph;
    }

    public void setServeGraph(boolean serveGraph) {
        this.serveGraph = serveGraph;
        this.notifyChangeListener();
    }

    public Map<String, Boolean> getDebugLogging() {
        return this.debugLogging;
    }

    public void setDebugLogging(Map<String, Boolean> map) {
        for (Map.Entry<String, Boolean> e : map.entrySet()) {
            if (!this.debugLogging.containsKey(e.getKey())) continue;
            this.debugLogging.put(e.getKey(), e.getValue());
        }
    }

    public String toString() {
        return "(data-source-dir: " + this.getDataSourceDirectory() + (this.buildStreet ? ", buildStreet" : "") + (this.buildTransit ? ", buildTransit" : "") + (this.saveGraph ? ", saveGraph" : "") + (this.serveGraph ? ", serveGraph" : "") + ")";
    }

    public String toCliString() {
        return String.join((CharSequence)" ", this.asOtpArgs());
    }

    public void save() {
        try {
            new ObjectMapper().writeValue(MODEL_FILE, (Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @JsonIgnore
    String getDataSourceDirectory() {
        if (this.dataSource == null) {
            return "DATA_SOURCE_NOT_SET";
        }
        return this.rootDirectory + File.separatorChar + this.dataSource;
    }

    String[] asOtpArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.buildAll()) {
            args.add("--build");
        } else if (this.buildStreet) {
            args.add("--buildStreet");
        } else if (this.buildTransit) {
            args.add("--loadStreet");
        } else {
            args.add("--load");
        }
        if (this.saveGraph && (this.buildTransit || this.buildStreet)) {
            args.add("--save");
        }
        if (this.serveGraph && !this.buildStreetOnly()) {
            args.add("--serve");
        }
        args.add(this.getDataSourceDirectory());
        return args.toArray(new String[0]);
    }

    private void notifyChangeListener() {
        if (this.commandLineChange != null) {
            this.commandLineChange.accept(this.toCliString());
        }
    }

    private boolean buildAll() {
        return this.buildStreet && this.buildTransit;
    }

    private boolean buildStreetOnly() {
        return this.buildStreet && !this.buildTransit;
    }

    private void setupListOfDebugLoggers() {
        for (String log : DebugLoggingSupport.getLogs()) {
            this.debugLogging.put(log, Boolean.FALSE);
        }
    }
}

