/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.trip;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.ext.flex.FlexParameters;
import org.opentripplanner.ext.flex.FlexServiceDate;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.template.FlexAccessTemplate;
import org.opentripplanner.ext.flex.template.FlexEgressTemplate;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.FlexLocationGroup;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.Trip;
import org.opentripplanner.routing.graphfinder.NearbyStop;

public class UnscheduledTrip
extends FlexTrip {
    private static final Set<Integer> N_STOPS = Set.of(Integer.valueOf(1), Integer.valueOf(2));
    private final UnscheduledStopTime[] stopTimes;
    private final BookingInfo[] dropOffBookingInfos;
    private final BookingInfo[] pickupBookingInfos;

    public static boolean isUnscheduledTrip(List<StopTime> stopTimes) {
        Predicate<StopTime> noExplicitTimes = Predicate.not(st -> st.isArrivalTimeSet() || st.isDepartureTimeSet());
        Predicate<StopTime> notContinuousStop = stopTime -> stopTime.getFlexContinuousDropOff() == PickDrop.NONE.getGtfsCode() && stopTime.getFlexContinuousPickup() == PickDrop.NONE.getGtfsCode();
        return N_STOPS.contains(stopTimes.size()) && stopTimes.stream().allMatch(noExplicitTimes) && stopTimes.stream().allMatch(notContinuousStop);
    }

    public UnscheduledTrip(Trip trip, List<StopTime> stopTimes) {
        super(trip);
        if (!UnscheduledTrip.isUnscheduledTrip(stopTimes)) {
            throw new IllegalArgumentException("Incompatible stopTimes for unscheduled trip");
        }
        int size = stopTimes.size();
        this.stopTimes = new UnscheduledStopTime[size];
        this.dropOffBookingInfos = new BookingInfo[size];
        this.pickupBookingInfos = new BookingInfo[size];
        for (int i = 0; i < size; ++i) {
            this.stopTimes[i] = new UnscheduledStopTime(stopTimes.get(i));
            this.dropOffBookingInfos[i] = stopTimes.get(0).getDropOffBookingInfo();
            this.pickupBookingInfos[i] = stopTimes.get(0).getPickupBookingInfo();
        }
    }

    @Override
    public Stream<FlexAccessTemplate> getFlexAccessTemplates(NearbyStop access, FlexServiceDate date, FlexPathCalculator calculator, FlexParameters params) {
        int fromIndex = this.getFromIndex(access);
        int toIndex = this.stopTimes.length - 1;
        if (fromIndex == -1 || fromIndex > toIndex || this.getDropOffType(toIndex).isNotRoutable()) {
            return Stream.empty();
        }
        ArrayList<FlexAccessTemplate> res = new ArrayList<FlexAccessTemplate>();
        for (StopLocation stop : this.expandStops(this.stopTimes[toIndex].stop)) {
            res.add(new FlexAccessTemplate(access, this, fromIndex, toIndex, stop, date, calculator, params));
        }
        return res.stream();
    }

    @Override
    public Stream<FlexEgressTemplate> getFlexEgressTemplates(NearbyStop egress, FlexServiceDate date, FlexPathCalculator calculator, FlexParameters params) {
        int fromIndex = 0;
        int toIndex = this.getToIndex(egress);
        if (toIndex == -1 || fromIndex > toIndex || this.getPickupType(fromIndex).isNotRoutable()) {
            return Stream.empty();
        }
        ArrayList<FlexEgressTemplate> res = new ArrayList<FlexEgressTemplate>();
        for (StopLocation stop : this.expandStops(this.stopTimes[fromIndex].stop)) {
            res.add(new FlexEgressTemplate(egress, this, fromIndex, toIndex, stop, date, calculator, params));
        }
        return res.stream();
    }

    @Override
    public int earliestDepartureTime(int departureTime, int fromStopIndex, int toStopIndex, int flexTime) {
        UnscheduledStopTime fromStopTime = this.stopTimes[fromStopIndex];
        UnscheduledStopTime toStopTime = this.stopTimes[toStopIndex];
        if (fromStopTime.flexWindowEnd < departureTime || toStopTime.flexWindowEnd < departureTime + flexTime) {
            return -1;
        }
        return Math.max(departureTime, fromStopTime.flexWindowStart);
    }

    @Override
    public int latestArrivalTime(int arrivalTime, int fromStopIndex, int toStopIndex, int flexTime) {
        UnscheduledStopTime fromStopTime = this.stopTimes[fromStopIndex];
        UnscheduledStopTime toStopTime = this.stopTimes[toStopIndex];
        if (toStopTime.flexWindowStart > arrivalTime || fromStopTime.flexWindowStart > arrivalTime - flexTime) {
            return -1;
        }
        return Math.min(arrivalTime, toStopTime.flexWindowEnd);
    }

    @Override
    public Set<StopLocation> getStops() {
        return Arrays.stream(this.stopTimes).map(scheduledDeviatedStopTime -> scheduledDeviatedStopTime.stop).collect(Collectors.toSet());
    }

    @Override
    public BookingInfo getDropOffBookingInfo(int i) {
        return this.dropOffBookingInfos[i];
    }

    @Override
    public BookingInfo getPickupBookingInfo(int i) {
        return this.pickupBookingInfos[i];
    }

    @Override
    public PickDrop getBoardRule(int i) {
        return this.stopTimes[i].pickupType;
    }

    @Override
    public PickDrop getAlightRule(int i) {
        return this.stopTimes[i].dropOffType;
    }

    @Override
    public boolean isBoardingPossible(NearbyStop stop) {
        return this.getFromIndex(stop) != -1;
    }

    @Override
    public boolean isAlightingPossible(NearbyStop stop) {
        return this.getToIndex(stop) != -1;
    }

    public PickDrop getPickupType(int i) {
        return this.stopTimes[i].pickupType;
    }

    public PickDrop getDropOffType(int i) {
        return this.stopTimes[i].dropOffType;
    }

    private Collection<StopLocation> expandStops(StopLocation stop) {
        return stop instanceof FlexLocationGroup ? ((FlexLocationGroup)stop).getLocations() : Collections.singleton(stop);
    }

    private int getFromIndex(NearbyStop accessEgress) {
        for (int i = 0; i < this.stopTimes.length; ++i) {
            StopLocation stop;
            if (this.getPickupType(i).isNotRoutable() || !((stop = this.stopTimes[i].stop) instanceof FlexLocationGroup ? ((FlexLocationGroup)stop).getLocations().contains(accessEgress.stop) : stop.equals(accessEgress.stop))) continue;
            return i;
        }
        return -1;
    }

    private int getToIndex(NearbyStop accessEgress) {
        for (int i = this.stopTimes.length - 1; i >= 0; --i) {
            StopLocation stop;
            if (this.getDropOffType(i).isNotRoutable() || !((stop = this.stopTimes[i].stop) instanceof FlexLocationGroup ? ((FlexLocationGroup)stop).getLocations().contains(accessEgress.stop) : stop.equals(accessEgress.stop))) continue;
            return i;
        }
        return -1;
    }

    private static class UnscheduledStopTime
    implements Serializable {
        private final StopLocation stop;
        private final int flexWindowStart;
        private final int flexWindowEnd;
        private final PickDrop pickupType;
        private final PickDrop dropOffType;

        private UnscheduledStopTime(StopTime st) {
            this.stop = st.getStop();
            this.flexWindowStart = st.getFlexWindowStart();
            this.flexWindowEnd = st.getFlexWindowEnd();
            this.pickupType = st.getPickupType();
            this.dropOffType = st.getDropOffType();
        }
    }
}

