/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.trip;

import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.opentripplanner.ext.flex.FlexParameters;
import org.opentripplanner.ext.flex.FlexServiceDate;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.template.FlexAccessTemplate;
import org.opentripplanner.ext.flex.template.FlexEgressTemplate;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.FlexLocationGroup;
import org.opentripplanner.model.FlexStopLocation;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.TransitEntity;
import org.opentripplanner.model.Trip;
import org.opentripplanner.routing.graphfinder.NearbyStop;

public abstract class FlexTrip
extends TransitEntity {
    protected final Trip trip;

    public FlexTrip(Trip trip) {
        super(trip.getId());
        this.trip = trip;
    }

    public abstract Stream<FlexAccessTemplate> getFlexAccessTemplates(NearbyStop var1, FlexServiceDate var2, FlexPathCalculator var3, FlexParameters var4);

    public abstract Stream<FlexEgressTemplate> getFlexEgressTemplates(NearbyStop var1, FlexServiceDate var2, FlexPathCalculator var3, FlexParameters var4);

    public abstract int earliestDepartureTime(int var1, int var2, int var3, int var4);

    public abstract int latestArrivalTime(int var1, int var2, int var3, int var4);

    public abstract Set<StopLocation> getStops();

    public Trip getTrip() {
        return this.trip;
    }

    public abstract BookingInfo getDropOffBookingInfo(int var1);

    public abstract BookingInfo getPickupBookingInfo(int var1);

    public abstract PickDrop getBoardRule(int var1);

    public abstract PickDrop getAlightRule(int var1);

    public abstract boolean isBoardingPossible(NearbyStop var1);

    public abstract boolean isAlightingPossible(NearbyStop var1);

    public static boolean containsFlexStops(List<StopTime> stopTimes) {
        return stopTimes.stream().map(StopTime::getStop).anyMatch(FlexTrip::isFlexStop);
    }

    public static boolean isFlexStop(StopLocation stop) {
        return stop instanceof FlexLocationGroup || stop instanceof FlexStopLocation;
    }
}

