/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.template;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.ext.flex.FlexParameters;
import org.opentripplanner.ext.flex.FlexServiceDate;
import org.opentripplanner.ext.flex.edgetype.FlexTripEdge;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.template.FlexAccessEgressTemplate;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.graphfinder.NearbyStop;

public class FlexEgressTemplate
extends FlexAccessEgressTemplate {
    public FlexEgressTemplate(NearbyStop accessEgress, FlexTrip trip, int fromStopTime, int toStopTime, StopLocation transferStop, FlexServiceDate date, FlexPathCalculator calculator, FlexParameters config) {
        super(accessEgress, trip, fromStopTime, toStopTime, transferStop, date, calculator, config);
    }

    @Override
    protected List<Edge> getTransferEdges(PathTransfer transfer) {
        return Lists.reverse(transfer.getEdges());
    }

    @Override
    protected Stop getFinalStop(PathTransfer transfer) {
        return transfer.from instanceof Stop ? (Stop)transfer.from : null;
    }

    @Override
    protected Collection<PathTransfer> getTransfersFromTransferStop(Graph graph) {
        return graph.index.getFlexIndex().transfersToStop.get((Object)this.transferStop);
    }

    @Override
    protected Vertex getFlexVertex(Edge edge) {
        return edge.getToVertex();
    }

    protected boolean isRouteable(Vertex flexVertex) {
        if (this.accessEgress.state.getVertex() == flexVertex) {
            return false;
        }
        return this.calculator.calculateFlexPath(flexVertex, this.accessEgress.state.getVertex(), this.fromStopIndex, this.toStopIndex) != null;
    }

    @Override
    protected int[] getFlexTimes(FlexTripEdge flexEdge, State state) {
        int postFlexTime = (int)this.accessEgress.state.getElapsedTimeSeconds();
        int edgeTimeInSeconds = flexEdge.getTimeInSeconds();
        int preFlexTime = (int)state.getElapsedTimeSeconds() - postFlexTime - edgeTimeInSeconds;
        return new int[]{preFlexTime, edgeTimeInSeconds, postFlexTime};
    }

    @Override
    protected FlexTripEdge getFlexEdge(Vertex flexFromVertex, StopLocation transferStop) {
        return new FlexTripEdge(flexFromVertex, this.accessEgress.state.getVertex(), transferStop, this.accessEgress.stop, this.trip, this, this.calculator);
    }
}

