/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.template;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.opentripplanner.ext.flex.FlexAccessEgress;
import org.opentripplanner.ext.flex.FlexParameters;
import org.opentripplanner.ext.flex.FlexServiceDate;
import org.opentripplanner.ext.flex.edgetype.FlexTripEdge;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.model.Stop;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.vertextype.TransitStopVertex;

public abstract class FlexAccessEgressTemplate {
    protected final NearbyStop accessEgress;
    protected final FlexTrip trip;
    public final int fromStopIndex;
    public final int toStopIndex;
    protected final StopLocation transferStop;
    protected final int secondsFromStartOfTime;
    public final ServiceDate serviceDate;
    protected final FlexPathCalculator calculator;
    private final FlexParameters flexParams;

    FlexAccessEgressTemplate(NearbyStop accessEgress, FlexTrip trip, int fromStopIndex, int toStopIndex, StopLocation transferStop, FlexServiceDate date, FlexPathCalculator calculator, FlexParameters flexParams) {
        this.accessEgress = accessEgress;
        this.trip = trip;
        this.fromStopIndex = fromStopIndex;
        this.toStopIndex = toStopIndex;
        this.transferStop = transferStop;
        this.secondsFromStartOfTime = date.secondsFromStartOfTime;
        this.serviceDate = date.serviceDate;
        this.calculator = calculator;
        this.flexParams = flexParams;
    }

    public StopLocation getTransferStop() {
        return this.transferStop;
    }

    public StopLocation getAccessEgressStop() {
        return this.accessEgress.stop;
    }

    public FlexTrip getFlexTrip() {
        return this.trip;
    }

    protected abstract List<Edge> getTransferEdges(PathTransfer var1);

    protected abstract Stop getFinalStop(PathTransfer var1);

    protected abstract Collection<PathTransfer> getTransfersFromTransferStop(Graph var1);

    protected abstract Vertex getFlexVertex(Edge var1);

    protected abstract int[] getFlexTimes(FlexTripEdge var1, State var2);

    protected abstract FlexTripEdge getFlexEdge(Vertex var1, StopLocation var2);

    public Stream<FlexAccessEgress> createFlexAccessEgressStream(Graph graph) {
        if (this.transferStop instanceof Stop) {
            TransitStopVertex flexVertex = graph.index.getStopVertexForStop().get(this.transferStop);
            return Stream.of(this.getFlexAccessEgress(new ArrayList<Edge>(), flexVertex, (Stop)this.transferStop)).filter(Objects::nonNull);
        }
        return this.getTransfersFromTransferStop(graph).stream().filter(pathTransfer -> pathTransfer.getDistanceMeters() <= this.flexParams.maxTransferMeters).filter(transfer -> this.getFinalStop((PathTransfer)transfer) != null).map(transfer -> {
            List<Edge> edges = this.getTransferEdges((PathTransfer)transfer);
            return this.getFlexAccessEgress(edges, this.getFlexVertex(edges.get(0)), this.getFinalStop((PathTransfer)transfer));
        }).filter(Objects::nonNull);
    }

    protected FlexAccessEgress getFlexAccessEgress(List<Edge> transferEdges, Vertex flexVertex, Stop stop) {
        FlexTripEdge flexEdge = this.getFlexEdge(flexVertex, this.transferStop);
        State state = flexEdge.traverse(this.accessEgress.state);
        if (state == null) {
            return null;
        }
        for (Edge e : transferEdges) {
            state = e.traverse(state);
            if (state != null) continue;
            return null;
        }
        int[] times = this.getFlexTimes(flexEdge, state);
        return new FlexAccessEgress(stop, times[0], times[1], times[2], this.fromStopIndex, this.toStopIndex, this.secondsFromStartOfTime, this.trip, state, transferEdges.isEmpty());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accessEgress", (Object)this.accessEgress).add("trip", (Object)this.trip).add("fromStopIndex", this.fromStopIndex).add("toStopIndex", this.toStopIndex).add("transferStop", (Object)this.transferStop).add("secondsFromStartOfTime", this.secondsFromStartOfTime).add("serviceDate", (Object)this.serviceDate).add("calculator", (Object)this.calculator).add("flexParams", (Object)this.flexParams).toString();
    }
}

