/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.flexpathcalculator;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPath;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.routing.algorithm.astar.AStar;
import org.opentripplanner.routing.algorithm.astar.strategies.DurationSkipEdgeStrategy;
import org.opentripplanner.routing.algorithm.astar.strategies.TrivialRemainingWeightHeuristic;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.spt.DominanceFunction;
import org.opentripplanner.routing.spt.GraphPath;
import org.opentripplanner.routing.spt.ShortestPathTree;

public class StreetFlexPathCalculator
implements FlexPathCalculator {
    private static final long MAX_FLEX_TRIP_DURATION_SECONDS = Duration.ofMinutes(45L).toSeconds();
    private final Graph graph;
    private final Map<Vertex, ShortestPathTree> cache = new HashMap<Vertex, ShortestPathTree>();
    private final boolean reverseDirection;

    public StreetFlexPathCalculator(Graph graph, boolean reverseDirection) {
        this.graph = graph;
        this.reverseDirection = reverseDirection;
    }

    @Override
    public FlexPath calculateFlexPath(Vertex fromv, Vertex tov, int fromStopIndex, int toStopIndex) {
        ShortestPathTree shortestPathTree;
        Vertex destinationVertex;
        Vertex originVertex = this.reverseDirection ? tov : fromv;
        Vertex vertex = destinationVertex = this.reverseDirection ? fromv : tov;
        if (this.cache.containsKey(originVertex)) {
            shortestPathTree = this.cache.get(originVertex);
        } else {
            shortestPathTree = this.routeToMany(originVertex);
            this.cache.put(originVertex, shortestPathTree);
        }
        GraphPath path = shortestPathTree.getPath(destinationVertex, false);
        if (path == null) {
            return null;
        }
        int distance = (int)path.getDistanceMeters();
        int duration = path.getDuration();
        return new FlexPath(distance, duration, path::getGeometry);
    }

    private ShortestPathTree routeToMany(Vertex vertex) {
        RoutingRequest routingRequest = new RoutingRequest(TraverseMode.CAR);
        routingRequest.arriveBy = this.reverseDirection;
        if (this.reverseDirection) {
            routingRequest.setRoutingContext(this.graph, null, vertex);
        } else {
            routingRequest.setRoutingContext(this.graph, vertex, null);
        }
        routingRequest.disableRemainingWeightHeuristic = true;
        routingRequest.rctx.remainingWeightHeuristic = new TrivialRemainingWeightHeuristic();
        routingRequest.dominanceFunction = new DominanceFunction.EarliestArrival();
        routingRequest.oneToMany = true;
        AStar search = new AStar();
        search.setSkipEdgeStrategy(new DurationSkipEdgeStrategy(MAX_FLEX_TRIP_DURATION_SECONDS));
        ShortestPathTree spt = search.getShortestPathTree(routingRequest);
        routingRequest.cleanup();
        return spt;
    }
}

