/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex;

import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.ext.flex.edgetype.FlexTripEdge;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.Agency;
import org.opentripplanner.model.BookingInfo;
import org.opentripplanner.model.Operator;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.Trip;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.Place;
import org.opentripplanner.model.plan.StopArrival;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.core.TraverseMode;

public class FlexibleTransitLeg
implements Leg {
    private final Trip trip;
    private final Calendar startTime;
    private final Calendar endTime;
    private final Double distanceMeters;
    private final ServiceDate serviceDate;
    private final Place from;
    private final Place to;
    private final LineString legGeometry;
    private final Set<TransitAlert> transitAlerts = new HashSet<TransitAlert>();
    private final PickDrop boardRule;
    private final PickDrop alightRule;
    private final BookingInfo dropOffBookingInfo;
    private final BookingInfo pickupBookingInfo;
    private final Integer boardStopPosInPattern;
    private final Integer alightStopPosInPattern;
    private final int generalizedCost;

    public FlexibleTransitLeg(FlexTripEdge flexTripEdge, Calendar startTime, Calendar endTime, int generalizedCost) {
        this.trip = flexTripEdge.getTrip();
        this.startTime = startTime;
        this.endTime = endTime;
        this.from = Place.forFlexStop(flexTripEdge.s1, flexTripEdge.getFromVertex());
        this.to = Place.forFlexStop(flexTripEdge.s2, flexTripEdge.getToVertex());
        this.distanceMeters = flexTripEdge.getDistanceMeters();
        this.serviceDate = flexTripEdge.flexTemplate.serviceDate;
        this.legGeometry = flexTripEdge.getGeometry();
        this.boardStopPosInPattern = flexTripEdge.flexTemplate.fromStopIndex;
        this.alightStopPosInPattern = flexTripEdge.flexTemplate.toStopIndex;
        FlexTrip flexTrip = flexTripEdge.getFlexTrip();
        this.dropOffBookingInfo = flexTrip.getDropOffBookingInfo(this.boardStopPosInPattern);
        this.pickupBookingInfo = flexTrip.getPickupBookingInfo(this.alightStopPosInPattern);
        this.boardRule = flexTrip.getBoardRule(this.boardStopPosInPattern);
        this.alightRule = flexTrip.getAlightRule(this.alightStopPosInPattern);
        this.generalizedCost = generalizedCost;
    }

    @Override
    public boolean isTransitLeg() {
        return true;
    }

    @Override
    public void addAlert(TransitAlert alert) {
        this.transitAlerts.add(alert);
    }

    @Override
    public Agency getAgency() {
        return this.getRoute().getAgency();
    }

    @Override
    public Operator getOperator() {
        return this.trip.getOperator();
    }

    @Override
    public Route getRoute() {
        return this.trip.getRoute();
    }

    @Override
    public Trip getTrip() {
        return this.trip;
    }

    @Override
    public TraverseMode getMode() {
        return TraverseMode.fromTransitMode(this.trip.getRoute().getMode());
    }

    @Override
    public Calendar getStartTime() {
        return this.startTime;
    }

    @Override
    public Calendar getEndTime() {
        return this.endTime;
    }

    @Override
    public boolean isFlexibleTrip() {
        return true;
    }

    @Override
    public Double getDistanceMeters() {
        return this.distanceMeters;
    }

    @Override
    public Integer getRouteType() {
        return this.trip.getRoute().getGtfsType();
    }

    @Override
    public String getHeadsign() {
        return this.trip.getTripHeadsign();
    }

    @Override
    public ServiceDate getServiceDate() {
        return this.serviceDate;
    }

    @Override
    public Place getFrom() {
        return this.from;
    }

    @Override
    public Place getTo() {
        return this.to;
    }

    @Override
    public List<StopArrival> getIntermediateStops() {
        return List.of();
    }

    @Override
    public LineString getLegGeometry() {
        return this.legGeometry;
    }

    @Override
    public Set<TransitAlert> getTransitAlerts() {
        return this.transitAlerts;
    }

    @Override
    public PickDrop getBoardRule() {
        return this.boardRule;
    }

    @Override
    public PickDrop getAlightRule() {
        return this.alightRule;
    }

    @Override
    public BookingInfo getDropOffBookingInfo() {
        return this.dropOffBookingInfo;
    }

    @Override
    public BookingInfo getPickupBookingInfo() {
        return this.pickupBookingInfo;
    }

    @Override
    public Integer getBoardStopPosInPattern() {
        return this.boardStopPosInPattern;
    }

    @Override
    public Integer getAlightStopPosInPattern() {
        return this.alightStopPosInPattern;
    }

    @Override
    public int getGeneralizedCost() {
        return this.generalizedCost;
    }

    public String toString() {
        return ToStringBuilder.of(FlexibleTransitLeg.class).addObj("from", this.from).addObj("to", this.to).addTimeCal("startTime", this.startTime).addTimeCal("endTime", this.endTime).addNum("distance", (Number)this.distanceMeters, "m").addNum("cost", this.generalizedCost).addEntityId("agencyId", this.getAgency()).addEntityId("routeId", this.getRoute()).addEntityId("tripId", this.trip).addObj("serviceDate", this.serviceDate).addObj("legGeometry", this.legGeometry).addCol("transitAlerts", this.transitAlerts).addNum("boardingStopIndex", this.boardStopPosInPattern).addNum("alightStopIndex", this.alightStopPosInPattern).addEnum("boardRule", this.boardRule).addEnum("alightRule", this.alightRule).addObj("pickupBookingInfo", this.pickupBookingInfo).addObj("dropOffBookingInfo", this.dropOffBookingInfo).toString();
    }
}

