/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.ext.flex.FlexAccessEgress;
import org.opentripplanner.ext.flex.FlexIndex;
import org.opentripplanner.ext.flex.FlexParameters;
import org.opentripplanner.ext.flex.FlexServiceDate;
import org.opentripplanner.ext.flex.flexpathcalculator.DirectFlexPathCalculator;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.flexpathcalculator.StreetFlexPathCalculator;
import org.opentripplanner.ext.flex.template.FlexAccessTemplate;
import org.opentripplanner.ext.flex.template.FlexEgressTemplate;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.model.calendar.ServiceDate;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.raptoradapter.transit.mappers.DateMapper;
import org.opentripplanner.routing.core.Fare;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graphfinder.NearbyStop;

public class FlexRouter {
    private final Graph graph;
    private final FlexParameters config;
    private final Collection<NearbyStop> streetAccesses;
    private final Collection<NearbyStop> streetEgresses;
    private final FlexIndex flexIndex;
    private final FlexPathCalculator accessFlexPathCalculator;
    private final FlexPathCalculator egressFlexPathCalculator;
    private final ZonedDateTime startOfTime;
    private final int departureTime;
    private final boolean arriveBy;
    private final FlexServiceDate[] dates;
    private List<FlexAccessTemplate> flexAccessTemplates = null;
    private List<FlexEgressTemplate> flexEgressTemplates = null;

    public FlexRouter(Graph graph, FlexParameters config, Instant searchInstant, boolean arriveBy, int additionalPastSearchDays, int additionalFutureSearchDays, Collection<NearbyStop> streetAccesses, Collection<NearbyStop> egressTransfers) {
        this.graph = graph;
        this.config = config;
        this.streetAccesses = streetAccesses;
        this.streetEgresses = egressTransfers;
        this.flexIndex = graph.index.getFlexIndex();
        if (graph.hasStreets) {
            this.accessFlexPathCalculator = new StreetFlexPathCalculator(graph, false);
            this.egressFlexPathCalculator = new StreetFlexPathCalculator(graph, true);
        } else {
            this.accessFlexPathCalculator = new DirectFlexPathCalculator(graph);
            this.egressFlexPathCalculator = new DirectFlexPathCalculator(graph);
        }
        ZoneId tz = graph.getTimeZone().toZoneId();
        LocalDate searchDate = LocalDate.ofInstant(searchInstant, tz);
        this.startOfTime = DateMapper.asStartOfService(searchDate, tz);
        this.departureTime = DateMapper.secondsSinceStartOfTime(this.startOfTime, searchInstant);
        this.arriveBy = arriveBy;
        int totalDays = additionalPastSearchDays + 1 + additionalFutureSearchDays;
        this.dates = new FlexServiceDate[totalDays];
        for (int d = -additionalPastSearchDays; d <= additionalFutureSearchDays; ++d) {
            LocalDate date = searchDate.plusDays(d);
            int index = d + additionalPastSearchDays;
            ServiceDate serviceDate = new ServiceDate(date);
            this.dates[index] = new FlexServiceDate(serviceDate, DateMapper.secondsSinceStartOfTime(this.startOfTime, date), graph.index.getServiceCodesRunningForDate().get(serviceDate));
        }
    }

    public Collection<Itinerary> createFlexOnlyItineraries() {
        this.calculateFlexAccessTemplates();
        this.calculateFlexEgressTemplates();
        HashMultimap streetEgressByStop = HashMultimap.create();
        this.streetEgresses.forEach(arg_0 -> FlexRouter.lambda$createFlexOnlyItineraries$0((Multimap)streetEgressByStop, arg_0));
        ArrayList<Itinerary> itineraries = new ArrayList<Itinerary>();
        for (FlexAccessTemplate template : this.flexAccessTemplates) {
            StopLocation transferStop = template.getTransferStop();
            if (!this.flexEgressTemplates.stream().anyMatch(t -> t.getAccessEgressStop().equals(transferStop))) continue;
            for (NearbyStop egress : streetEgressByStop.get((Object)transferStop)) {
                Itinerary itinerary = template.createDirectItinerary(egress, this.arriveBy, this.departureTime, this.startOfTime);
                if (itinerary == null) continue;
                FareService fareService = this.graph.getService(FareService.class);
                if (fareService != null) {
                    Fare fare;
                    itinerary.fare = fare = fareService.getCost(itinerary);
                }
                itineraries.add(itinerary);
            }
        }
        return itineraries;
    }

    public Collection<FlexAccessEgress> createFlexAccesses() {
        this.calculateFlexAccessTemplates();
        return this.flexAccessTemplates.stream().flatMap(template -> template.createFlexAccessEgressStream(this.graph)).collect(Collectors.toList());
    }

    public Collection<FlexAccessEgress> createFlexEgresses() {
        this.calculateFlexEgressTemplates();
        return this.flexEgressTemplates.stream().flatMap(template -> template.createFlexAccessEgressStream(this.graph)).collect(Collectors.toList());
    }

    private void calculateFlexAccessTemplates() {
        if (this.flexAccessTemplates != null) {
            return;
        }
        this.flexAccessTemplates = this.getClosestFlexTrips(this.streetAccesses, true).flatMap(t2 -> Arrays.stream(this.dates).filter(date -> date.isFlexTripRunning((FlexTrip)t2.second, this.graph)).flatMap(date -> ((FlexTrip)t2.second).getFlexAccessTemplates((NearbyStop)t2.first, (FlexServiceDate)date, this.accessFlexPathCalculator, this.config))).collect(Collectors.toList());
    }

    private void calculateFlexEgressTemplates() {
        if (this.flexEgressTemplates != null) {
            return;
        }
        this.flexEgressTemplates = this.getClosestFlexTrips(this.streetEgresses, false).flatMap(t2 -> Arrays.stream(this.dates).filter(date -> date.isFlexTripRunning((FlexTrip)t2.second, this.graph)).flatMap(date -> ((FlexTrip)t2.second).getFlexEgressTemplates((NearbyStop)t2.first, (FlexServiceDate)date, this.egressFlexPathCalculator, this.config))).collect(Collectors.toList());
    }

    private Stream<T2<NearbyStop, FlexTrip>> getClosestFlexTrips(Collection<NearbyStop> nearbyStops, boolean pickup) {
        Stream<Map<FlexTrip, List<T2>>> flexTripsReachableFromNearbyStops = nearbyStops.stream().flatMap(accessEgress -> this.flexIndex.getFlexTripsByStop(accessEgress.stop).filter(flexTrip -> pickup ? flexTrip.isBoardingPossible((NearbyStop)accessEgress) : flexTrip.isAlightingPossible((NearbyStop)accessEgress)).map(flexTrip -> new T2<NearbyStop, FlexTrip>((NearbyStop)accessEgress, (FlexTrip)flexTrip)));
        Collection<List<T2>> groupedReachableFlexTrips = flexTripsReachableFromNearbyStops.collect(Collectors.groupingBy(t2 -> (FlexTrip)t2.second)).values();
        return groupedReachableFlexTrips.stream().map(t2s -> t2s.stream().min(Comparator.comparingLong(t2 -> ((NearbyStop)t2.first).state.getElapsedTimeSeconds()))).flatMap(Optional::stream);
    }

    private static /* synthetic */ void lambda$createFlexOnlyItineraries$0(Multimap streetEgressByStop, NearbyStop it) {
        streetEgressByStop.put((Object)it.stop, (Object)it);
    }
}

