/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex;

import java.util.HashMap;
import java.util.HashSet;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.common.geometry.GeometryUtils;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.graph_builder.services.GraphBuilderModule;
import org.opentripplanner.model.FlexStopLocation;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.impl.StreetVertexIndex;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.util.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexLocationsToStreetEdgesMapper
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(FlexLocationsToStreetEdgesMapper.class);

    @Override
    public void buildGraph(Graph graph, HashMap<Class<?>, Object> extra, DataImportIssueStore issueStore) {
        if (graph.locationsById.isEmpty()) {
            return;
        }
        StreetVertexIndex streetIndex = graph.getStreetIndex();
        ProgressTracker progress = ProgressTracker.track("Add flex locations to street vertices", 1, graph.locationsById.size());
        LOG.info(progress.startMessage());
        for (FlexStopLocation flexStopLocation : graph.locationsById.values()) {
            for (Vertex vertx : streetIndex.getVerticesForEnvelope(flexStopLocation.getGeometry().getEnvelopeInternal())) {
                if (!(vertx instanceof StreetVertex) || !((StreetVertex)vertx).isEligibleForCarPickupDropoff()) continue;
                Point p = GeometryUtils.getGeometryFactory().createPoint(vertx.getCoordinate());
                if (flexStopLocation.getGeometry().disjoint((Geometry)p)) continue;
                StreetVertex streetVertex = (StreetVertex)vertx;
                if (streetVertex.flexStopLocations == null) {
                    streetVertex.flexStopLocations = new HashSet<FlexStopLocation>();
                }
                streetVertex.flexStopLocations.add(flexStopLocation);
            }
            progress.step(m -> LOG.info(m));
        }
        LOG.info(progress.completeMessage());
    }

    @Override
    public void checkInputs() {
    }
}

