/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.opentripplanner.common.geometry.HashGridSpatialIndex;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.FlexLocationGroup;
import org.opentripplanner.model.FlexStopLocation;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.model.Route;
import org.opentripplanner.model.StopLocation;
import org.opentripplanner.routing.graph.Graph;

public class FlexIndex {
    public Multimap<StopLocation, PathTransfer> transfersToStop = ArrayListMultimap.create();
    public Multimap<StopLocation, FlexTrip> flexTripsByStop = HashMultimap.create();
    public Multimap<StopLocation, FlexLocationGroup> locationGroupsByStop = ArrayListMultimap.create();
    public HashGridSpatialIndex<FlexStopLocation> locationIndex = new HashGridSpatialIndex();
    public Map<FeedScopedId, Route> routeById = new HashMap<FeedScopedId, Route>();
    public Map<FeedScopedId, FlexTrip> tripById = new HashMap<FeedScopedId, FlexTrip>();

    public FlexIndex(Graph graph) {
        for (PathTransfer transfer : graph.transfersByStop.values()) {
            this.transfersToStop.put((Object)transfer.to, (Object)transfer);
        }
        for (FlexTrip flexTrip : graph.flexTripsById.values()) {
            this.routeById.put(flexTrip.getTrip().getRoute().getId(), flexTrip.getTrip().getRoute());
            this.tripById.put(flexTrip.getTrip().getId(), flexTrip);
            for (StopLocation stop : flexTrip.getStops()) {
                if (stop instanceof FlexLocationGroup) {
                    for (StopLocation stopElement : ((FlexLocationGroup)stop).getLocations()) {
                        this.flexTripsByStop.put((Object)stopElement, (Object)flexTrip);
                    }
                    continue;
                }
                this.flexTripsByStop.put((Object)stop, (Object)flexTrip);
            }
        }
        for (FlexLocationGroup flexLocationGroup : graph.locationGroupsById.values()) {
            for (StopLocation stop : flexLocationGroup.getLocations()) {
                this.locationGroupsByStop.put((Object)stop, (Object)flexLocationGroup);
            }
        }
        for (FlexStopLocation flexStopLocation : graph.locationsById.values()) {
            this.locationIndex.insert(flexStopLocation.getGeometry().getEnvelopeInternal(), (Object)flexStopLocation);
        }
    }

    Stream<FlexTrip> getFlexTripsByStop(StopLocation stopLocation) {
        return this.flexTripsByStop.get((Object)stopLocation).stream();
    }
}

