/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex;

import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.Stop;
import org.opentripplanner.routing.core.State;

public class FlexAccessEgress {
    public final Stop stop;
    public final int preFlexTime;
    public final int flexTime;
    public final int postFlexTime;
    private final int fromStopIndex;
    private final int toStopIndex;
    private final int differenceFromStartOfTime;
    private final FlexTrip trip;
    public final State lastState;
    public final boolean directToStop;

    public FlexAccessEgress(Stop stop, int preFlexTime, int flexTime, int postFlexTime, int fromStopIndex, int toStopIndex, int differenceFromStartOfTime, FlexTrip trip, State lastState, boolean directToStop) {
        this.stop = stop;
        this.preFlexTime = preFlexTime;
        this.flexTime = flexTime;
        this.postFlexTime = postFlexTime;
        this.fromStopIndex = fromStopIndex;
        this.toStopIndex = toStopIndex;
        this.differenceFromStartOfTime = differenceFromStartOfTime;
        this.trip = trip;
        this.lastState = lastState;
        this.directToStop = directToStop;
    }

    public int earliestDepartureTime(int departureTime) {
        int requestedTransitDepartureTime = departureTime + this.preFlexTime - this.differenceFromStartOfTime;
        int earliestAvailableTransitDepartureTime = this.trip.earliestDepartureTime(requestedTransitDepartureTime, this.fromStopIndex, this.toStopIndex, this.flexTime);
        if (earliestAvailableTransitDepartureTime == -1) {
            return -1;
        }
        return earliestAvailableTransitDepartureTime - this.preFlexTime + this.differenceFromStartOfTime;
    }

    public int latestArrivalTime(int arrivalTime) {
        int requestedTransitArrivalTime = arrivalTime - this.postFlexTime - this.differenceFromStartOfTime;
        int latestAvailableTransitArrivalTime = this.trip.latestArrivalTime(requestedTransitArrivalTime, this.fromStopIndex, this.toStopIndex, this.flexTime);
        if (latestAvailableTransitArrivalTime == -1) {
            return -1;
        }
        return latestAvailableTransitArrivalTime + this.postFlexTime + this.differenceFromStartOfTime;
    }
}

