/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.examples.statistics.api.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.opentripplanner.ext.examples.statistics.api.model.StatisticsGraphQLSchemaFactory;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.standalone.server.OTPServer;
import org.opentripplanner.util.HttpToGraphQLMapper;

@Path(value="/routers/statistics")
@Produces(value={"application/json"})
public class GraphStatisticsResource {
    private final ObjectMapper deserializer = new ObjectMapper();
    private GraphQL graphQL;

    public GraphStatisticsResource(@Context OTPServer server) {
        this(server.createRoutingRequestService());
    }

    GraphStatisticsResource(RoutingService routingService) {
        this.graphQL = GraphQL.newGraphQL((GraphQLSchema)StatisticsGraphQLSchemaFactory.createSchema(routingService)).build();
    }

    @POST
    @Path(value="/graphql")
    @Consumes(value={"application/json"})
    public Response getGraphQLAsJson(Map<String, Object> queryParameters) {
        HttpToGraphQLMapper.QlRequestParams req = HttpToGraphQLMapper.mapHttpQuerryParamsToQLParams(queryParameters, this.deserializer);
        ExecutionResult executionResult = this.graphQL.execute(req.query, req.operationName, null, req.variables);
        return HttpToGraphQLMapper.mapExecutionResultToHttpResponse(executionResult);
    }

    @POST
    @Path(value="/graphql")
    @Consumes(value={"application/graphql"})
    public Response getGraphQL(String query) {
        ExecutionResult executionResult = this.graphQL.execute(query);
        return HttpToGraphQLMapper.mapExecutionResultToHttpResponse(executionResult);
    }
}

