/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.datastore.gs;

import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.opentripplanner.datastore.DataSource;
import org.opentripplanner.datastore.FileType;
import org.opentripplanner.ext.datastore.gs.AbstractGsDataSource;

class GsOutFileDataSource
extends AbstractGsDataSource
implements DataSource {
    private final Storage storage;

    GsOutFileDataSource(Storage storage, BlobId blobId, FileType type) {
        super(blobId, type);
        this.storage = storage;
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public OutputStream asOutputStream() {
        BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)this.blobId()).build();
        return Channels.newOutputStream((WritableByteChannel)this.storage.writer(blobInfo, new Storage.BlobWriteOption[0]));
    }
}

