/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.datastore.gs;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.zip.GZIPInputStream;
import org.opentripplanner.datastore.DataSource;
import org.opentripplanner.datastore.FileType;
import org.opentripplanner.ext.datastore.gs.AbstractGsDataSource;

class GsFileDataSource
extends AbstractGsDataSource
implements DataSource {
    private final Blob blob;

    GsFileDataSource(Blob blob, FileType type) {
        super(blob.getBlobId(), type);
        this.blob = blob;
    }

    @Override
    public long size() {
        return this.blob.getSize();
    }

    @Override
    public long lastModified() {
        return this.blob.getUpdateTime();
    }

    @Override
    public boolean exists() {
        return this.blob.exists(new Blob.BlobSourceOption[0]);
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public InputStream asInputStream() {
        InputStream in = Channels.newInputStream((ReadableByteChannel)this.blob.reader(new Blob.BlobSourceOption[0]));
        if (this.blob.getName().endsWith(".gz")) {
            try {
                return new GZIPInputStream(in);
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getLocalizedMessage(), e);
            }
        }
        return in;
    }

    @Override
    public OutputStream asOutputStream() {
        return Channels.newOutputStream((WritableByteChannel)this.blob.writer(new Storage.BlobWriteOption[0]));
    }
}

