/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.datastore.gs;

import com.google.cloud.storage.BlobId;
import org.opentripplanner.datastore.DataSource;
import org.opentripplanner.datastore.FileType;
import org.opentripplanner.ext.datastore.gs.GsHelper;

abstract class AbstractGsDataSource
implements DataSource {
    private final BlobId blobId;
    private final FileType type;

    AbstractGsDataSource(BlobId blobId, FileType type) {
        this.blobId = blobId;
        this.type = type;
    }

    BlobId blobId() {
        return this.blobId;
    }

    String bucketName() {
        return this.blobId.getBucket();
    }

    @Override
    public final String name() {
        return this.blobId.getName();
    }

    @Override
    public final String path() {
        return GsHelper.toUriString(this.blobId);
    }

    @Override
    public final FileType type() {
        return this.type;
    }

    public final String toString() {
        return this.type + " " + this.path();
    }
}

