/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.dataoverlay.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.ext.dataoverlay.api.ParameterName;
import org.opentripplanner.ext.dataoverlay.api.ParameterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataOverlayParameters
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DataOverlayParameters.class);
    private final Map<T2<ParameterName, ParameterType>, Double> values = new HashMap<T2<ParameterName, ParameterType>, Double>();

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public static DataOverlayParameters parseQueryParams(Map<String, List<String>> params) {
        DataOverlayParameters result = new DataOverlayParameters();
        for (String key : params.keySet()) {
            T2<ParameterName, ParameterType> name = DataOverlayParameters.resolveKey(key);
            if (name == null) continue;
            List<String> values = params.get(key);
            if (values == null || values.isEmpty()) {
                LOG.warn("The data-overlay parameter value is missing. Parameter: {}", (Object)key);
                continue;
            }
            Double value = DataOverlayParameters.resolveValue(values.get(0));
            if (value == null) {
                LOG.warn("The data-overlay parameter value is null. Parameter: {}", (Object)key);
                continue;
            }
            result.put(name, value);
        }
        return result;
    }

    public static List<String> parametersAsString() {
        ArrayList<String> list = new ArrayList<String>();
        for (ParameterName name : ParameterName.values()) {
            for (ParameterType type : ParameterType.values()) {
                list.add((name + "_" + type).toLowerCase());
            }
        }
        return list;
    }

    public Double get(String param) {
        return this.get(DataOverlayParameters.resolveKey(param));
    }

    public Double get(ParameterName name, ParameterType type) {
        return this.values.get(new T2<ParameterName, ParameterType>(name, type));
    }

    private Double get(T2<ParameterName, ParameterType> param) {
        return this.values.get(param);
    }

    public void put(String param, Double value) {
        this.put(DataOverlayParameters.resolveKey(param), value);
    }

    public void put(ParameterName name, ParameterType type, Double value) {
        this.put(new T2<ParameterName, ParameterType>(name, type), value);
    }

    private void put(T2<ParameterName, ParameterType> param, Double value) {
        if (param == null) {
            return;
        }
        this.values.put(param, value);
    }

    public static String toStringKey(ParameterName name, ParameterType type) {
        return (name + "_" + type).toLowerCase();
    }

    public Iterable<ParameterName> listParameterNames() {
        return this.values.keySet().stream().map(it -> (ParameterName)((Object)((Object)it.first))).collect(Collectors.toSet());
    }

    @Nullable
    static T2<ParameterName, ParameterType> resolveKey(String parameter) {
        try {
            int pos = parameter.lastIndexOf(95);
            if (pos < 0 || pos > parameter.length() - 2) {
                return null;
            }
            ParameterName name = ParameterName.valueOf(parameter.substring(0, pos).toUpperCase());
            ParameterType type = ParameterType.valueOf(parameter.substring(pos + 1).toUpperCase());
            return new T2<ParameterName, ParameterType>(name, type);
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }

    @Nullable
    static Double resolveValue(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NullPointerException | NumberFormatException ignore) {
            return null;
        }
    }
}

