/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.dataoverlay;

import java.awt.geom.Point2D;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.referencing.GeodeticCalculator;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.ext.dataoverlay.DataOverlayStreetEdgeCostExtension;
import org.opentripplanner.ext.dataoverlay.EdgeGenQuality;
import org.opentripplanner.ext.dataoverlay.GenericDataFile;
import org.opentripplanner.ext.dataoverlay.configuration.TimeUnit;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayLong;
import ucar.ma2.Index;

class GenericEdgeUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(GenericEdgeUpdater.class);
    private static final int REPORT_EVERY_N_EDGE = 10000;
    private final GenericDataFile dataFile;
    private final Collection<StreetEdge> streetEdges;
    private final TimeUnit timeFormat;
    private final Map<String, Array> genericVariablesData;
    private int edgesUpdated;
    private final long dataStartTime;

    GenericEdgeUpdater(GenericDataFile dataFile, TimeUnit timeFormat, Collection<StreetEdge> streetEdges) {
        this.dataFile = dataFile;
        this.streetEdges = streetEdges;
        this.timeFormat = timeFormat;
        this.edgesUpdated = 0;
        this.dataStartTime = this.calculateDataStartTime(timeFormat);
        this.genericVariablesData = dataFile.getNetcdfDataForVariable();
        LOG.info("Street edges update from {} starting from time stamp {}", (Object)dataFile.getDataSource(), (Object)this.dataStartTime);
    }

    private long calculateDataStartTime(TimeUnit timeFormat) {
        Array timeArray = this.dataFile.getTimeArray();
        Class dataType = timeArray.getDataType().getPrimitiveClassType();
        Instant originInstant = this.dataFile.getOriginDate().toInstant();
        if ((timeFormat == null || timeFormat == TimeUnit.SECONDS) && dataType.equals(Integer.TYPE)) {
            return originInstant.plusSeconds(timeArray.getInt(0)).toEpochMilli();
        }
        if (timeFormat == TimeUnit.MS_EPOCH && dataType.equals(Long.TYPE)) {
            return timeArray.getLong(0);
        }
        long addSeconds = 0L;
        if (dataType.equals(Double.TYPE)) {
            addSeconds = (long)(timeArray.getDouble(0) * 3600.0);
        } else if (dataType.equals(Float.TYPE)) {
            addSeconds = (long)(timeArray.getFloat(0) * 3600.0f);
        }
        return originInstant.plusSeconds(addSeconds).toEpochMilli();
    }

    public void updateEdges() {
        this.streetEdges.forEach(this::updateEdge);
    }

    private void updateEdge(StreetEdge streetEdge) {
        Vertex fromVertex = streetEdge.getFromVertex();
        Vertex toVertex = streetEdge.getToVertex();
        Coordinate fromCoordinate = fromVertex.getCoordinate();
        Coordinate toCoordinate = toVertex.getCoordinate();
        HashMap<String, float[]> edgeGenericDataValues = new HashMap<String, float[]>();
        for (Map.Entry<String, Array> variableValues : this.genericVariablesData.entrySet()) {
            float[] averageDataValue = this.getAverageValue(fromCoordinate.x, fromCoordinate.y, toCoordinate.x, toCoordinate.y, variableValues.getKey());
            edgeGenericDataValues.put(variableValues.getKey(), averageDataValue);
        }
        DataOverlayStreetEdgeCostExtension edgeGenData = new DataOverlayStreetEdgeCostExtension(this.dataStartTime, edgeGenericDataValues, this.timeFormat);
        streetEdge.setCostExtension(edgeGenData);
        ++this.edgesUpdated;
        if (LOG.isInfoEnabled() && this.edgesUpdated % 10000 == 0) {
            LOG.info(String.format("%d / %d street edges updated", this.edgesUpdated, this.streetEdges.size()));
        }
    }

    private float[] getAverageValue(double fromLongitude, double fromLatitude, double toLongitude, double toLatitude, String propertyName) {
        EdgeGenQuality edgeGenQuality = new EdgeGenQuality();
        this.getClosestSamples(fromLongitude, fromLatitude, toLongitude, toLatitude, propertyName).forEach(sample -> {
            for (int time = 0; time < sample.size(); ++time) {
                edgeGenQuality.addPropertyValueSample(time, (Number)sample.get(time));
            }
        });
        return edgeGenQuality.getPropertyValueAverage((int)this.dataFile.getTimeArray().getSize());
    }

    private <E> List<List<E>> getClosestSamples(double fromLongitude, double fromLatitude, double toLongitude, double toLatitude, String propertyName) {
        ArrayList<List<List<E>>> result = new ArrayList<List<List<E>>>();
        double azimuth = this.getAzimuth(fromLongitude, fromLatitude, toLongitude, toLatitude);
        double distance = this.getDistance(fromLongitude, fromLatitude, toLongitude, toLatitude);
        double spacing = 12.0;
        int i = 0;
        while ((double)i < distance / spacing) {
            Point2D samplePoint = this.moveTo(fromLongitude, fromLatitude, azimuth, (double)i * spacing);
            List<E> closestPropertyValue = this.getClosestPropertyValue(samplePoint, propertyName);
            result.add(closestPropertyValue);
            ++i;
        }
        return result;
    }

    private <E> List<E> getClosestPropertyValue(Point2D samplePoint, String propertyName) {
        double lon = samplePoint.getX();
        double lat = samplePoint.getY();
        int lonIndex = this.getClosestIndex(this.dataFile.getLongitudeArray(), lon);
        int latIndex = this.getClosestIndex(this.dataFile.getLatitudeArray(), lat);
        int timeSize = (int)this.dataFile.getTimeArray().getSize();
        ArrayList<Number> result = new ArrayList<Number>();
        int height = 0;
        for (int timeIndex = 0; timeIndex < timeSize; ++timeIndex) {
            Array dataArray = this.genericVariablesData.get(propertyName);
            Index selectIndex = dataArray.getIndex();
            if (selectIndex.getRank() == 3) {
                selectIndex.set(timeIndex, latIndex, lonIndex);
            } else if (selectIndex.getRank() == 4) {
                selectIndex.set(timeIndex, height, latIndex, lonIndex);
            } else {
                throw new IllegalArgumentException(String.format("Invalid data array shape for %s", propertyName));
            }
            Class dataArrayType = dataArray.getDataType().getPrimitiveClassType();
            if (dataArrayType.equals(Integer.TYPE)) {
                result.add(timeIndex, ((ArrayInt)dataArray).get(selectIndex));
                continue;
            }
            if (dataArrayType.equals(Double.TYPE)) {
                result.add(timeIndex, ((ArrayDouble)dataArray).get(selectIndex));
                continue;
            }
            if (dataArrayType.equals(Float.TYPE)) {
                result.add(timeIndex, Float.valueOf(((ArrayFloat)dataArray).get(selectIndex)));
                continue;
            }
            if (dataArrayType.equals(Long.TYPE)) {
                result.add(timeIndex, ((ArrayLong)dataArray).get(selectIndex));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unsupported format %s of %s variable", dataArrayType, propertyName));
        }
        return result;
    }

    private int getClosestIndex(Array array, double value) {
        double distance = Double.MAX_VALUE;
        int i = 0;
        while ((long)i < array.getSize()) {
            double current = array.getDouble(i);
            double currentDistance = Math.abs(current - value);
            if (!(currentDistance < distance)) {
                return i - 1;
            }
            distance = currentDistance;
            ++i;
        }
        return (int)(array.getSize() - 1L);
    }

    private double getAzimuth(double fromLongitude, double fromLatitude, double toLongitude, double toLatitude) {
        GeodeticCalculator geodeticCalculator = new GeodeticCalculator();
        geodeticCalculator.setStartingGeographicPoint(fromLongitude, fromLatitude);
        geodeticCalculator.setDestinationGeographicPoint(toLongitude, toLatitude);
        return geodeticCalculator.getAzimuth();
    }

    private double getDistance(double fromLongitude, double fromLatitude, double toLongitude, double toLatitude) {
        GeodeticCalculator geodeticCalculator = new GeodeticCalculator();
        geodeticCalculator.setStartingGeographicPoint(fromLongitude, fromLatitude);
        geodeticCalculator.setDestinationGeographicPoint(toLongitude, toLatitude);
        return geodeticCalculator.getOrthodromicDistance();
    }

    private Point2D moveTo(double longitude, double latitude, double azimuth, double amount) {
        GeodeticCalculator geodeticCalculator = new GeodeticCalculator();
        geodeticCalculator.setStartingGeographicPoint(longitude, latitude);
        geodeticCalculator.setDirection(azimuth, amount);
        return geodeticCalculator.getDestinationGeographicPoint();
    }
}

