/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.dataoverlay;

import java.io.File;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opentripplanner.ext.dataoverlay.configuration.DataOverlayConfig;
import org.opentripplanner.ext.dataoverlay.configuration.IndexVariable;
import ucar.ma2.Array;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Variable;
import ucar.nc2.units.DateUnit;

public class GenericDataFile {
    private final String dataSource;
    private OffsetDateTime originDate;
    private String error = null;
    private Array timeArray;
    private Array latitudeArray;
    private Array longitudeArray;
    private Map<String, Array> netcdfDataForVariable;

    public GenericDataFile(File file, DataOverlayConfig dataOverlayConfig) {
        this.dataSource = file.getPath();
        try {
            if (!file.exists()) {
                this.error = String.format("Missing data file from %s file", file.getAbsolutePath());
                return;
            }
            NetcdfFile netcdfFile = this.readNetcdfFile(file);
            Variable time = netcdfFile.findVariable(dataOverlayConfig.getTimeVariable());
            if (time == null) {
                this.error = String.format("Missing time variable from %s file", file.getAbsolutePath());
                return;
            }
            Variable latitude = netcdfFile.findVariable(dataOverlayConfig.getLatitudeVariable());
            Variable longitude = netcdfFile.findVariable(dataOverlayConfig.getLongitudeVariable());
            HashMap<IndexVariable, Variable> genVariables = new HashMap<IndexVariable, Variable>();
            for (IndexVariable indexVariable : dataOverlayConfig.getIndexVariables()) {
                genVariables.put(indexVariable, netcdfFile.findVariable(indexVariable.getVariable()));
            }
            DateUnit dateUnit = new DateUnit(time.getUnitsString());
            Date dateOrigin = dateUnit.getDateOrigin();
            if (dateOrigin == null) {
                this.error = String.format("Missing origin date from %s file", file.getAbsolutePath());
                return;
            }
            if (latitude == null) {
                this.error = String.format("Missing latitude variable from %s file", file.getAbsolutePath());
                return;
            }
            if (longitude == null) {
                this.error = String.format("Missing longitude variable from %s file", file.getAbsolutePath());
                return;
            }
            this.originDate = OffsetDateTime.ofInstant(dateOrigin.toInstant(), ZoneId.systemDefault());
            this.timeArray = time.read();
            this.latitudeArray = latitude.read();
            this.longitudeArray = longitude.read();
            this.netcdfDataForVariable = new HashMap<String, Array>(genVariables.size());
            for (Map.Entry genVariable : genVariables.entrySet()) {
                this.netcdfDataForVariable.put(((IndexVariable)genVariable.getKey()).getName(), ((Variable)genVariable.getValue()).read());
            }
        }
        catch (Exception e) {
            this.error = e.getMessage();
        }
    }

    String getDataSource() {
        return this.dataSource;
    }

    public Map<String, Array> getNetcdfDataForVariable() {
        return this.netcdfDataForVariable;
    }

    public boolean isValid() {
        return this.error == null;
    }

    public String getError() {
        return this.error;
    }

    public Array getTimeArray() {
        return this.timeArray;
    }

    public Array getLatitudeArray() {
        return this.latitudeArray;
    }

    public Array getLongitudeArray() {
        return this.longitudeArray;
    }

    public OffsetDateTime getOriginDate() {
        return this.originDate;
    }

    private NetcdfFile readNetcdfFile(File file) throws IOException {
        return NetcdfFiles.open((String)file.getAbsolutePath());
    }
}

