/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.dataoverlay;

import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.tokenizer.UnknownFunctionOrVariableException;
import org.opentripplanner.ext.dataoverlay.configuration.TimeUnit;
import org.opentripplanner.ext.dataoverlay.routing.DataOverlayContext;
import org.opentripplanner.ext.dataoverlay.routing.Parameter;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.edgetype.StreetEdgeCostExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataOverlayStreetEdgeCostExtension
implements StreetEdgeCostExtension,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DataOverlayStreetEdgeCostExtension.class);
    private final long dataStartTime;
    private final Map<String, float[]> variableValues;
    private final TimeUnit timeUnit;

    DataOverlayStreetEdgeCostExtension(long dataStartTime, Map<String, float[]> variableValues, TimeUnit timeUnit) {
        this.dataStartTime = dataStartTime;
        this.variableValues = variableValues;
        this.timeUnit = timeUnit;
    }

    @Override
    public double calculateExtraCost(RoutingRequest options, int edgeLength, TraverseMode traverseMode) {
        if (traverseMode.isWalking() || traverseMode.isCycling()) {
            return this.calculateDataOverlayPenalties(options) * (double)edgeLength / 1000.0;
        }
        return 0.0;
    }

    private double calculateDataOverlayPenalties(RoutingRequest requestOptions) {
        if (this.variableValues == null) {
            return 0.0;
        }
        double totalPenalty = 0.0;
        Instant requestInstant = requestOptions.getDateTime();
        DataOverlayContext context = requestOptions.getRoutingContext().dataOverlayContext;
        for (Parameter parameter : context.getParameters()) {
            Instant aqiTimeInstant;
            int dataQualityRequestedTime;
            double threshold = parameter.getThreshold();
            double penalty = parameter.getPenalty();
            String indexVariableName = parameter.getVariable();
            long dataStartTime = 0L;
            float[] genDataValuesForTime = new float[]{};
            if (this.variableValues.containsKey(indexVariableName)) {
                dataStartTime = this.dataStartTime;
                genDataValuesForTime = this.variableValues.get(indexVariableName);
            }
            if ((dataQualityRequestedTime = this.timeUnit.between(aqiTimeInstant = Instant.ofEpochMilli(dataStartTime), requestInstant)) < 0) continue;
            if (dataQualityRequestedTime < genDataValuesForTime.length) {
                float value = genDataValuesForTime[dataQualityRequestedTime];
                String penaltyFormulaString = parameter.getFormula();
                double penaltyForParameters = this.calculatePenaltyFromParameters(penaltyFormulaString, value, threshold, penalty);
                if (!(penaltyForParameters >= 0.0)) continue;
                totalPenalty += penaltyForParameters;
                continue;
            }
            LOG.warn("No available data overlay for the given time");
        }
        return totalPenalty;
    }

    private double calculatePenaltyFromParameters(String formula, float value, double threshold, double penalty) {
        HashMap<String, Double> variables = new HashMap<String, Double>();
        variables.put("THRESHOLD", threshold);
        variables.put("PENALTY", penalty);
        variables.put("VALUE", Double.valueOf(value));
        try {
            Expression expression = new ExpressionBuilder(formula).variables(variables.keySet().toArray(new String[0])).build().setVariables(variables);
            return expression.evaluate();
        }
        catch (UnknownFunctionOrVariableException ex) {
            throw new IllegalArgumentException(String.format("Formula %s did not receive all the required parameters", formula));
        }
    }
}

