/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.file;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.opentripplanner.datastore.DataSource;
import org.opentripplanner.datastore.FileType;
import org.opentripplanner.datastore.file.ZipFileDataSource;

public class ZipFileEntryDataSource
implements DataSource {
    private final ZipFileDataSource dataSource;
    private final ZipEntry entry;

    ZipFileEntryDataSource(ZipFileDataSource dataSource, ZipEntry entry) {
        this.dataSource = dataSource;
        this.entry = entry;
    }

    @Override
    public String name() {
        return this.entry.getName();
    }

    @Override
    public String path() {
        return this.name() + " (" + this.dataSource.path() + ")";
    }

    @Override
    public FileType type() {
        return this.dataSource.type();
    }

    @Override
    public long size() {
        return this.entry.getSize();
    }

    @Override
    public long lastModified() {
        return this.entry.getLastModifiedTime().toMillis();
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public InputStream asInputStream() {
        try {
            return this.dataSource.zipFile().getInputStream(this.entry);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read " + this.path() + ": " + e.getLocalizedMessage(), e);
        }
    }

    public String toString() {
        return this.type() + " " + this.path();
    }
}

