/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.opentripplanner.datastore.CompositeDataSource;
import org.opentripplanner.datastore.DataSource;
import org.opentripplanner.datastore.FileType;
import org.opentripplanner.datastore.file.AbstractFileDataSource;
import org.opentripplanner.datastore.file.ZipFileEntryDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipFileDataSource
extends AbstractFileDataSource
implements CompositeDataSource {
    private static final Logger LOG = LoggerFactory.getLogger(ZipFileDataSource.class);
    private boolean contentLoaded = false;
    private ZipFile zipFile;
    private final Collection<DataSource> content = new ArrayList<DataSource>();

    public ZipFileDataSource(File file, FileType type) {
        super(file, type);
    }

    @Override
    public void close() {
        try {
            if (this.zipFile != null) {
                this.zipFile.close();
                this.zipFile = null;
            }
        }
        catch (IOException e) {
            LOG.error(this.path() + " close failed. Details: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public Collection<DataSource> content() {
        this.loadContent();
        return this.content;
    }

    @Override
    public DataSource entry(String name) {
        this.loadContent();
        return this.content.stream().filter(it -> it.name().equals(name)).findFirst().orElse(null);
    }

    ZipFile zipFile() {
        return this.zipFile;
    }

    private void loadContent() {
        if (this.contentLoaded) {
            return;
        }
        this.contentLoaded = true;
        try {
            this.zipFile = new ZipFile(this.file, 1);
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                this.content.add(new ZipFileEntryDataSource(this, entry));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load " + this.path() + ": " + e.getLocalizedMessage(), e);
        }
    }
}

