/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import org.opentripplanner.datastore.FileType;
import org.opentripplanner.datastore.file.AbstractFileDataSource;

public class FileDataSource
extends AbstractFileDataSource {
    public FileDataSource(File file, FileType type) {
        super(file, type);
    }

    @Override
    public InputStream asInputStream() {
        try {
            if (this.file.getName().endsWith(".gz")) {
                return new GZIPInputStream(new FileInputStream(this.file));
            }
            return new FileInputStream(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load " + this.path() + ": " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public OutputStream asOutputStream() {
        try {
            return new FileOutputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File not found " + this.path() + ": " + e.getLocalizedMessage(), e);
        }
    }
}

