/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.opentripplanner.datastore.CompositeDataSource;
import org.opentripplanner.datastore.DataSource;
import org.opentripplanner.datastore.FileType;
import org.opentripplanner.datastore.file.AbstractFileDataSource;
import org.opentripplanner.datastore.file.FileDataSource;

public class DirectoryDataSource
extends AbstractFileDataSource
implements CompositeDataSource {
    public DirectoryDataSource(File path, FileType type) {
        super(path, type);
    }

    @Override
    public Collection<DataSource> content() {
        ArrayList<DataSource> content = new ArrayList<DataSource>();
        if (this.file.exists()) {
            for (File file : this.file.listFiles()) {
                if (file.isDirectory()) continue;
                content.add(new FileDataSource(file, this.type));
            }
        }
        return content;
    }

    @Override
    public DataSource entry(String filename) {
        if (!this.file.exists()) {
            this.file.mkdirs();
        }
        return new FileDataSource(new File(this.file, filename), this.type);
    }

    @Override
    public void delete() {
        try {
            if (this.file.exists()) {
                FileUtils.deleteDirectory((File)this.file);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to delete " + this.path() + ": " + e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void close() {
    }
}

