/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.configure;

import java.io.File;
import java.util.ArrayList;
import org.opentripplanner.datastore.CompositeDataSource;
import org.opentripplanner.datastore.FileType;
import org.opentripplanner.datastore.OtpDataStore;
import org.opentripplanner.datastore.OtpDataStoreConfig;
import org.opentripplanner.datastore.base.DataSourceRepository;
import org.opentripplanner.datastore.file.FileDataSourceRepository;
import org.opentripplanner.ext.datastore.gs.GsDataSourceRepository;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DataStoreFactory.class);
    private final OtpDataStoreConfig config;

    public DataStoreFactory(OtpDataStoreConfig config) {
        this.config = config;
    }

    public static CompositeDataSource compositeSource(File file, FileType type) {
        return FileDataSourceRepository.compositeSource(file, type);
    }

    public OtpDataStore open() {
        ArrayList<DataSourceRepository> repositories = new ArrayList<DataSourceRepository>();
        if (OTPFeature.GoogleCloudStorage.isOn()) {
            LOG.info("Google Cloud Store Repository enabled - GS resources detected.");
            repositories.add(new GsDataSourceRepository(this.config.gsCredentials()));
        }
        repositories.add(new FileDataSourceRepository(this.config.baseDirectory(), this.config.gtfsLocalFilePattern(), this.config.netexLocalFilePattern(), this.config.osmLocalFilePattern(), this.config.demLocalFilePattern()));
        OtpDataStore store = new OtpDataStore(this.config, repositories);
        store.open();
        return store;
    }
}

