/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.opentripplanner.datastore.CompositeDataSource;
import org.opentripplanner.datastore.DataSource;
import org.opentripplanner.datastore.FileType;
import org.opentripplanner.datastore.base.ByteArrayDataSource;

public class ZipStreamDataSourceDecorator
implements CompositeDataSource {
    private final DataSource delegate;
    private boolean contentLoaded = false;
    private List<DataSource> content = new ArrayList<DataSource>();

    public ZipStreamDataSourceDecorator(DataSource delegate) {
        this.delegate = delegate;
    }

    @Override
    public String name() {
        return this.delegate.name();
    }

    @Override
    public String path() {
        return this.delegate.path();
    }

    @Override
    public FileType type() {
        return this.delegate.type();
    }

    @Override
    public long size() {
        return this.delegate.size();
    }

    @Override
    public long lastModified() {
        return this.delegate.lastModified();
    }

    @Override
    public boolean exists() {
        return this.delegate.exists();
    }

    @Override
    public String detailedInfo() {
        return this.delegate.detailedInfo();
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public Collection<DataSource> content() {
        this.loadContent();
        return this.content;
    }

    @Override
    public DataSource entry(String name) {
        this.loadContent();
        return this.content.stream().filter(it -> name.equals(it.name())).findFirst().orElse(null);
    }

    @Override
    public InputStream asInputStream() {
        throw new UnsupportedOperationException("This datasource type " + this.type() + " do not support READING. Can not read from: " + this.path());
    }

    @Override
    public OutputStream asOutputStream() {
        throw new UnsupportedOperationException("This datasource type " + this.type() + " do not support WRITING. Can not write to: " + this.path());
    }

    @Override
    public void close() {
        this.content = null;
    }

    public String toString() {
        return this.path();
    }

    private void loadContent() {
        if (this.content == null) {
            throw new NullPointerException("The content is accessed after the zip file is closed: " + this.path());
        }
        if (this.contentLoaded) {
            return;
        }
        this.contentLoaded = true;
        try (ZipInputStream zis = new ZipInputStream(this.delegate.asInputStream());){
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    ByteArrayOutputStream buf = new ByteArrayOutputStream(4048);
                    zis.transferTo(buf);
                    byte[] bArray = buf.toByteArray();
                    this.content.add(new ByteArrayDataSource(entry.getName() + " (" + this.path() + ")", entry.getName(), this.type(), bArray.length, entry.getLastModifiedTime().toMillis(), false).withBytes(bArray));
                }
                entry = zis.getNextEntry();
            }
        }
        catch (ZipException ex) {
            throw new RuntimeException("Can not read zip file " + this.path() + ": " + ex.getLocalizedMessage(), ex);
        }
        catch (IOException ie) {
            throw new RuntimeException("Failed to load " + this.path() + ": " + ie.getLocalizedMessage(), ie);
        }
    }
}

