/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;

public interface OtpDataStoreConfig {
    public static final String DEFAULT_GTFS_PATTERN = "(?i)gtfs";
    public static final String DEFAULT_NETEX_PATTERN = "(?i)netex";
    public static final String DEFAULT_OSM_PATTERN = "(?i)(\\.pbf|\\.osm|\\.osm\\.xml)$";
    public static final String DEFAULT_DEM_PATTERN = "(?i)\\.tiff?$";

    public File baseDirectory();

    public URI reportDirectory();

    public String gsCredentials();

    public List<URI> osmFiles();

    public List<URI> demFiles();

    @NotNull
    public List<URI> gtfsFiles();

    @NotNull
    public List<URI> netexFiles();

    public URI graph();

    public URI streetGraph();

    public Pattern gtfsLocalFilePattern();

    public Pattern netexLocalFilePattern();

    public Pattern osmLocalFilePattern();

    public Pattern demLocalFilePattern();
}

